<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-project-innovation-initiative
* @subpackage config
*/

/**
* File and directory Modes
* 
* These prefs are used when checking and setting modes when working
* with the file system.  The defaults are fine on servers with proper
* security, but you may wish (or even need) to change the values in
* certain environments (Apache running a separate process for each
* user, PHP under CGI with Apache suEXEC, etc.).  Octal values should
* always be used to set the mode correctly.
*/

define('FILE_READ_MODE', 0644);
define('FILE_WRITE_MODE', 0666);
define('DIR_READ_MODE', 0755);
define('DIR_WRITE_MODE', 0777);

/**
* File Stream Modes
* 
* These modes are used when working with fopen()/popen()
*/
define('FOPEN_READ',							'rb');
define('FOPEN_READ_WRITE',						'r+b');
define('FOPEN_WRITE_CREATE_DESTRUCTIVE',		'wb'); // truncates existing file data, use with care
define('FOPEN_READ_WRITE_CREATE_DESTRUCTIVE',	'w+b'); // truncates existing file data, use with care
define('FOPEN_WRITE_CREATE',					'ab');
define('FOPEN_READ_WRITE_CREATE',				'a+b');
define('FOPEN_WRITE_CREATE_STRICT',				'xb');
define('FOPEN_READ_WRITE_CREATE_STRICT',		'x+b');

/**
* Application Settings
*/
define('APPLICATION_BUILD_VERSION','1.9.0');
define('PORTAL_TITLE_PREFIX', 'VA Direct Project - ');
define('INBOX_DISPLAY_PER_PAGE', '25');
define('ADMINPANEL_DISPLAY_PER_PAGE', '10');
define('ADMINPANEL_LOG_DISPLAY_PER_PAGE', '50');
define('SESSION_TIMEOUT_MINS', '10');
define('CUSTOM_MAILBOX_PREFIX', '[Custom].');
define('NESTED_FOLDER_MAX_DEPTH', '3');
define('GROUP_MAILBOX_PREFIX', 'Public');
define('WARNING_TEXT_TITLE','VA Notice and Consent');
define('WARNING_TEXT',
'<h2>VA NOTICE AND CONSENT BANNER</h2>
<p>VA systems are intended to be used by authorized VA network users for viewing and retrieving information only except as otherwise explicitly authorized for official business and limited personal use under VA policy.</p>
<p>
	Information from this system resides on and transmits through computer systems and networks funded by the VA.
 	All access or use constitutes understanding and acceptance that there is no reasonable expectation of privacy in the use of Government networks or systems.
</p>
<p>All access or use of this system constitutes user understanding and acceptance of these terms and constitutes unconditional consent to review and action including (but not limited to) monitoring recording copying auditing inspecting investigating restricting access blocking  tracking disclosing to authorized personnel or any other authorized actions by all authorized VA and law enforcement personnel.</p>
<p>Unauthorized user attempts or acts to
<ul style="list-style-type: none;">
<li>(1) access upload download change or delete information on this system</li>
<li>(2) modify this system</li>  
<li>(3) deny access to this system</li>
<li>(4) accrue resources for unauthorized use or</li> 
<li>(5) otherwise misuse this system are strictly prohibited.</li>
</ul></p>
<p>Such attempts or acts are subject to action that may result in criminal civil or administrative penalties.</p>');

define('NUMBER_OF_BYTES_IN_MB', 1048576); //since this is not as definite a number as it ought to be, define what we consider this to be in this operating system
define('MAX_ATTACHMENTS_SIZE_IN_BYTES', (5 * NUMBER_OF_BYTES_IN_MB)); //total size allowed for all the attachments of a message (currently 5MB)
define('MAX_FILE_TRANSFER_SIZE_IN_BYTES', (200 * NUMBER_OF_BYTES_IN_MB)); //size allowed for a single file transfer - total file transfers on a message is unlimited (currently 1GB)

//kill switch to quickly and completely turn on/off the process to convert MSWord attachments to PDFs for attachment previews
define('USE_DOC_TO_PDF_CONVERSION_PROCESS', TRUE);

//this will call the command line directly instead of using our compiled dll conversion engine, it is less stable in terms of error handling
//but it has the advantage of not requiring the COM library / compiled dll, disadvantage is it will only work with LibreOffice
define('USE_COMMAND_LINE_DOC_TO_PDF', FALSE);

define('DOC_TO_PDF_MAX_SIZE', 10000000); //max size in bytes of word files that we'll attempt to convert to pdf - for larger files, we won't attempt to preview files via pdf


/**
* Application Security Settings
*/
define('USE_CAC_AUTH', FALSE);
define('USE_PIV_AUTH', TRUE);
define('MAX_LOGIN_ATTEMPTS', '7');
define('IS_AJAX', isset($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest');


//set up constants based on our ini file for sensitive or extremely envrionment-specific data
$application_ini_config = parse_ini_file(APPLICATION_INI_LOCATION);
define('DATABASE_PASSWORD', $application_ini_config['database_password']);
define('LDAP_ADMIN_PASSWORD', $application_ini_config['ldap_admin_password']);
define('LDAP_SEARCH_PASSWORD', $application_ini_config['ldap_search_password']);
define('WEBSERVICE_PUBLIC_KEY', $application_ini_config['webservice_public_key']);
define('WEBSERVICE_PRIVATE_KEY', $application_ini_config['webservice_private_key']);
define('TLS_SERVER_CERT_PATH', $application_ini_config['tls_server_cert_path']);
define('TLS_SERVER_KEY_PATH', $application_ini_config['tls_server_key_path']);

define('LOG_ENTRY_MAX_LENGTH_IN_BYTES', (array_key_exists('log_entry_max_length_in_bytes', $application_ini_config) ? $application_ini_config['log_entry_max_length_in_bytes'] : 10240));

/**
* Environment Settings
*/

define('DP_ENVIRONMENT', 'DEMO');	

switch(DP_ENVIRONMENT) {
	
	case 'DEMO':

		define('API_ADMIN_URL', 'http://developer.demo.direct.DNS   ');
		define('ENVIRONMENT_COUNTRY', 'US');
		define('ENVIRONMENT_TIMEZONE','America/New_York');
		define('CONNECT_GATEWAY_HOSTNAME', 'nhiapp-sqa1.DNS   ');
		define('CONNECT_GATEWAY_PORT', '443');
		define('CONNECT_DOCUMENT_QUERY_WSDL', 'https://'.CONNECT_GATEWAY_HOSTNAME.':'.CONNECT_GATEWAY_PORT.'/NHINAdapterDocQuery/AdapterDocQuery?wsdl');
		define('CONNECT_DOCUMENT_RETRIEVE_WSDL', 'https://'.CONNECT_GATEWAY_HOSTNAME.':'.CONNECT_GATEWAY_PORT.'/NHINAdapterDocRetrieve/AdapterDocRetrieve?wsdl');
		define('CONNECT_HOME_COMMUNITY_ID', '2.16.840.1.113883.4.349.1'); 
		define('CONNECT_TEST_PATIENT_ID', '1012638924V546709');
		define('MVI_PATIENT_SEARCH_WSDL', 'D:/app/htdocs/webmail/application/third_party/MVI/wsdl/IdmHl7v3.wsdl'); 
		define('MVI_PATIENT_SEARCH_ENDPOINT', ''); 
		define('MVI_PROCESSING_CODE', 'T'); 
		define('SMTP_HOSTNAME', 'DNS     dem11.aac.DNS   ');
		define('SMTP_PORT', '25');
		define('SMTP_TIMEOUT', '1');
		define('CLINICAL_DOMAIN', 'demo.direct.DNS   ');
		define('DIRECT_USERAGENT', '');
		define('DIRECT_SEND_PROTOCOL', 'smtp');
		define('GATEWAY_SMTP_HOSTNAME', 'DNS     dem11.aac.DNS   ');
		define('GATEWAY_EXTERNAL_EMAIL_PORT', '587');
		define('GATEWAY_SMTP_TIMEOUT', '1');
		define('GATEWAY_HOSTNAME','DNS     dem11.aac.DNS   ');
		define('GATEWAY_SMTP_PORT', '25');
		define('EMAIL_SIGNATURE', 'VLER Direct Team');
		define('EXTERNAL_EMAILS_FROM', 'notifications@'.CLINICAL_DOMAIN);		
		define('ALL_USERS_MOCK_ADDRESS', 'all-va-direct-users@'.CLINICAL_DOMAIN);	
		define('LDAP_HOSTNAME', 'DNS     dem10.aac.DNS   ');
		define('LDAP_PORT', '389');
		define('LDAP_BASE_DOMAIN', 'dc=demo,dc=direct,dc=va,dc=gov');
		define('LDAP_ROLES_GROUP', 'ou=roles,'.LDAP_BASE_DOMAIN);
		define('LDAP_ADMIN_GROUP1', 'ou=admins,' . LDAP_BASE_DOMAIN);
		define('LDAP_ADMIN_USERNAME', 'cn=admin,' . LDAP_BASE_DOMAIN);
		define('LDAP_SEARCH_USERNAME', 'cn=webmailsearch,' . LDAP_BASE_DOMAIN);
		define('LDAP_ACCOUNTS_DN','ou=accounts,' . LDAP_BASE_DOMAIN);
		define('LDAP_GROUPS_DN','ou=groups,' . LDAP_BASE_DOMAIN);
		define('LDAP_DELETED_ACCOUNTS_DN','ou=deletedaccounts,' . LDAP_BASE_DOMAIN);
		define('LDAP_DELETED_GROUPS_DN','ou=deletedgroups,' . LDAP_BASE_DOMAIN);
		define('LDAP_DISTRUBUTION_LIST_DN','ou=distributionlists,' . LDAP_BASE_DOMAIN);
		define('LDAP_DELETED_DISTRUBUTION_LIST_DN','ou=deleteddistributionlists,' . LDAP_BASE_DOMAIN);
		define('DATABASE_HOSTNAME', 'DNS  .aac.dva.DNS   \DNS  DIRSQL811,1433');
		define('DATABASE_NAME', 'direct');
		define('DATABASE_USERNAME', 'dpi-db');
		define('DATABASE_DRIVER', 'sqlsrv');
		define('TLS_SERVER_VERIFYHOST', FALSE);
		define('TLS_SERVER_VERIFYPEER', FALSE);
		define('VLERDAS_PROTOCOL', 'https');
		define('VLERDAS_HOSTNAME', '.vaco.DNS   ');
		define('VLERDAS_PORT', '443');
		define('VLERDAS_ECRUD_RESOURCE', 'ecrud/v1');
		define('VLERDAS_DATABASE', 'core');
		define('VLERDAS_COLLECTION', 'directSecureMessaging.cda/transform');
		define('WEBSERVICE_URL', 'http://api.demo.direct.DNS   ');
		define('WKHTMLTOPDF_EXE_PATH', 'C:\Program Files (x86)\wkhtmltopdf\wkhtmltopdf.exe');
		define('VIDEO_PATH', $_SERVER['DOCUMENT_ROOT'].'/videos/');
		break;
}

/* End of file constants.php */
/* Location: ./application/config/constants.php */
