<?php
/**
* @package icarus
* @subpackage partials-lister
*/

/** */
require_once '/wwwroot/htdocs/webapps/Excel_Writer/Writer.php';
$CI = get_instance();
$CI->output->enable_profiler(false);

$items = $lister->items_for_page();
$rows = array();
foreach($items as $item){
	$row = array();
	foreach($lister->columns as $column){
		$row[$column] = strip_tags($lister->markup_for_table_column($column, $item));
	}
	$rows[] = $row;
}

$column_labels = array();
foreach($lister->columns as $column){
	$column_labels[$column] = $lister->alias_for_column($column);
}

#$filename = 'Search_Export.xls';
$filename = $CI->router->method.'_'.unix_to_mysql_date(mktime());
if(is_on_dev()) error_reporting(E_ALL ^ E_NOTICE);

  
//Creating a workbook
$workbook = new Spreadsheet_Excel_Writer();
//Creating a worksheet
$worksheet=&$workbook->addWorksheet();
$worksheet->setLandscape();

$header_format =& $workbook->addFormat(array('bold'=>1,'top'=>1,'size'=>9));
$normal_format =& $workbook->addFormat(array('size'=>9, 'align'=>'left')); 

if(empty($items)){
	$worksheet->write(0, 0, 'There are no '.plural(humanize($lister->model->model_alias())).' to display.', $normal_format );
}
else{
	//set all columns same width
	$worksheet->setColumn (0, count($column_labels), $column_width = 20);
	
	/*Speadsheet writer is in format y,x (row, column)
	 *  column1  |  column2 |  column3
	 *   (0,0)      (0,1)      (0,2) */
		
	$column_number = 0;
	$row_number    = 0;
		
	//Write column titles two rows beneath sheet title
	foreach ($column_labels as $label) {
		$worksheet->write($row_number, $column_number, $label, $header_format);
		$column_number++;
	}
	
	//Write each datapoint to the sheet starting one row beneath
	foreach ($rows as $row){
		$row_number++;
		$column_number = 0;
		foreach($row as $cell_value){
			//Loop through each row's columns
			$worksheet->write($row_number, $column_number, $cell_value, $normal_format );
			$column_number++;
		}
	}
}
$workbook->close();
//Sending HTTP headers
$workbook->send($filename); 
?>