<?PHP  if ( ! defined('BASEPATH')) exit('No direct script access allowed'); 
/**
* Any changes to this library need to be made in both Webmail and the API.
* @package vler
* @subpackage libraries
*/ /** */

/**
* @package vler
* @subpackage libraries
*/
class Zip_attachment extends Attachment{	
	protected $_children; //an array of Attachment objects for the files inside this Zip archive
	protected $_child_patient_documents; //a subset of just the Patient_document_attachments stored in $_children
	

////////////////////
// GETTERS
////////////////////
	 
	function children(){
		if(!isset($this->_children)){
			$children = array();
			$values_to_pass = array('parent' => $this);
			if(isset($this->message_id))
				$values_to_pass['message_id'] = $this->message_id;
			
			$tmp_file = tmpfile();
			fwrite($tmp_file, $this->_binary_string);
			$zip = new ZipArchive;
			if($zip->open(element('uri', stream_get_meta_data($tmp_file))) === TRUE) { 
				for($i = 0; $i < $zip->numFiles; $i++){ 									
					$binary_string = $zip->getFromIndex(intval($i));
					
					//make sure that this item isn't a directory
					$bom = pack('H*','EFBBBF');
					if(empty(preg_replace("/^$bom/", '', $binary_string))) continue; 
					
					$path_in_parent = element('name', $zip->statIndex(intval($i)));
					$name = basename($path_in_parent);
					$path_in_parent = strip_from_end($name, $path_in_parent);
					if(!empty($path_in_parent))
						$values_to_pass['path_in_parent'] = $path_in_parent;
					
					$values_to_pass['index_in_parent'] = $i;
					
					$children[$i] = Attachment::create($name, $binary_string, $values_to_pass);
				}
			}
			fclose($tmp_file);			
			$this->_children = $children;
		}
		return $this->_children;
	}
	
	public function child_patient_documents(){
		if(!isset($this->_child_patient_documents)){
			$child_patient_documents = array();
			foreach($this->children as $index => $child){
				if(is_a($child, 'Patient_document_attachment'))
					$child_patient_documents[$index] = $child;
			}
			$this->_child_patient_documents = $child_patient_documents;
		}
		return $this->_child_patient_documents;
	}

	 public function download($zip_index = null){
	 	if(is_null($zip_index)) return parent::download();
		if(!array_key_exists($zip_index, $this->children)) return $this->error->should_be_an_x('valid index for a child file of '.$this->describe(), $zip_index);

		$this->children[$zip_index]->download();
	}

	public function download_as_pdf($zip_index = null){
	 	if(is_null($zip_index)) return parent::download_as_pdf();
		if(!array_key_exists($zip_index, $this->children)) return $this->error->should_be_an_x('valid index for a child file of '.$this->describe(), $zip_index);

		$this->children[$zip_index]->download_as_pdf();
	}	
	
	function metadata(){
		$metadata = parent::metadata();
		$metadata['children'] = collect('metadata', $this->children);
		$metadata['child_patient_documents'] = collect('metadata', $this->child_patient_documents());
		return $metadata;
	} 

//////////////////////
// SETTERS
//////////////////////

	
/////////////////////
// STATIC FUNCTIONS
/////////////////////

	/**
	* Checks the content of a file and casts it as the appropriate child class.
	*
	*
	* @param string Name of the file
	* @param string Content of the file
	* @param array Any additional metadata, formatted array('message_id' => $message_id, 'directory' => $directory)
	* @return Zip_attachment
	*/
	public static function create($name, $binary_string, $more_values = array()){
		if(!static::matches_file($name, $binary_string)) return get_instance()->error->should_be_an_x('name of a '.humanize(get_called_class()).' file', $name);

		require_library('attachments/XDM_attachment');
		$xdm_class = class_name_for_library('attachments/XDM_attachment');
	
		if($xdm_class::matches_file($name, $binary_string)){
			return $xdm_class::create($name, $binary_string, $more_values);
		}

		return new Zip_attachment(array_merge(compact('name', 'binary_string'), $more_values));
	}

	/**
	* True if the given file can be cast as an instance of this class.
	* @param string Name of the file
	* @param string Content of the file
	* @return boolean
	*/
	public static function matches_file($name, $binary_string){
		if(!parent::matches_file($name, $binary_string)) return false;
		$extension = strtolower(pathinfo($name, PATHINFO_EXTENSION));
		//we can also try to open the file as a zip to see if it's a valid file, even if the extension is different
		$valid_zip = false;
		//do this by writing temp file and attempting to open as zip
		$tmp_file = tmpfile();
		$metadata = stream_get_meta_data($tmp_file);
		$tmp_filename = $metadata['uri'];
		fwrite($tmp_file, $binary_string);
		$zip = new ZipArchive;
		if($zip->open($tmp_filename) === TRUE) { $zip->close(); $valid_zip = true; }
		fclose($tmp_file);
		return ((!empty($binary_string) && $valid_zip) || $extension == 'zip');
	}
	
}
?>