<?PHP  if ( ! defined('BASEPATH')) exit('No direct script access allowed'); 
/**
* Any changes to this library need to be made in both Webmail and the API.
* @package vler
* @subpackage libraries
*/ /** */

/**
* @package vler
* @subpackage libraries
*/
class XDM_attachment extends Zip_Attachment{		
		

////////////////////
// GETTERS
////////////////////
			

//////////////////////
// SETTERS
//////////////////////


////////////////////////
// PROTECTED FUNCTIONS
////////////////////////




	
/////////////////////
// STATIC FUNCTIONS
/////////////////////

	/**
	* Checks the content of a file and casts it as the appropriate child class.
	*
	*
	* @param string Name of the file
	* @param string Content of the file
	* @param array Any additional metadata, formatted array('message_id' => $message_id, 'directory' => $directory)
	* @return XDM_attachment
	*/
	public static function create($name, $binary_string, $more_values = array()){
		if(!static::matches_file($name, $binary_string)) return get_instance()->error->should_be_an_x('name of a '.humanize(get_called_class()).' file', $name);
		return new XDM_attachment(array_merge(compact('name', 'binary_string'), $more_values));
	}

	/**
	* True if the given file can be cast as an instance of this class.
	* @param string Name of the file
	* @param string Content of the file
	* @return boolean
	*/
	public static function matches_file($name, $binary_string){
		if(!parent::matches_file($name, $binary_string)) return false;
		$extension = strtolower(pathinfo($name, PATHINFO_EXTENSION));
		//we can also try to open the file as a zip to see if it's a valid file, even if the extension is different
		$valid_xdm = false;
		//do this by writing temp file and attempting to open as zip
		$tmp_file = tmpfile();
		$metadata = stream_get_meta_data($tmp_file);
		$tmp_filename = $metadata['uri'];
		fwrite($tmp_file, $binary_string);
		$zip = new ZipArchive;
		if($zip->open($tmp_filename) === TRUE) { 
			for($i = 0; $i < $zip->numFiles; $i++){ 
			    $stat = $zip->statIndex($i);
			    if(string_contains('IHE_XDM/', $stat['name'])) { $valid_xdm = true; }
			}
		}
		fclose($tmp_file);
		return ((!empty($binary_string) && $valid_xdm));
	}
	
}
?>