<?PHP  if ( ! defined('BASEPATH')) exit('No direct script access allowed'); 
/**
* Any changes to this library need to be made in both Webmail and the API.
* @package vler
* @subpackage libraries
*/ /** */

/**
* @package vler
* @subpackage libraries
*/
class Text_attachment extends Attachment{	
	protected static $extensions = array('txt', 'css'); 

	protected $_use_lightbox_preview = true;
	
	public function download(){
		header('Content-Type: text/plain');
		header('Content-Disposition: attachment; filename="' . $this->name . '"');
		header('Content-Transfer-Encoding: binary');
		echo $this->binary_string;	
	}
	
	public function view(){
		header('Content-Type: text/plain');
		header('Content-Disposition: inline; filename="' . $this->name . '"');
		echo nl2br($this->binary_string);	
	}
	
///////////////////////
// PROTECTED FUNCTIONS
///////////////////////	

	
/////////////////////
// STATIC FUNCTIONS
/////////////////////

	public static function create($name, $binary_string, $more_values = array()){
		if(empty($binary_string)) return get_instance()->error->should_be_an_x('name of a '.humanize(get_called_class()).' file', $name);
		if(!static::matches_file($name, $binary_string)) return get_instance()->error->should_be_an_x('name of a '.humanize(get_called_class()).' file', $name);
		return new Text_attachment(array_merge(compact('name', 'binary_string'), $more_values));
	}

	public static function matches_file($name, $binary_string){
		if(!parent::matches_file($name, $binary_string)) return false;
		if(empty($binary_string)) return false;
		return in_array(strtolower(pathinfo($name, PATHINFO_EXTENSION)), static::$extensions);
	}
	
}
?>