<?PHP  if ( ! defined('BASEPATH')) exit('No direct script access allowed'); 
/**
* Any changes to this library need to be made in both Webmail and the API.
* @package vler
* @subpackage libraries
*/ /** */

/**
* @package vler
* @subpackage libraries
*/
class Image_attachment extends Attachment{		
	protected static $extensions = array('jpg', 'jpeg', 'gif', 'png', /*'tif', 'tiff' */); //tif and tiff don't work with our image previewing at the moment, so we'll comment out for now. -- MG 2014-11-3

	protected $_use_lightbox_preview = true;
	
	public function download(){
		header('Content-Type: application/octet-stream');
		header('Content-Disposition: attachment; filename="' . $this->name . '"');
		header('Content-Transfer-Encoding: binary');
		echo $this->binary_string;	
	}
	
	public function view(){
		header('Content-Type: image/'. $this->extension);
		header('Content-Disposition: inline; filename="' . $this->name . '"');
		echo $this->binary_string;	
	}
	
///////////////////////
// PROTECTED FUNCTIONS
///////////////////////	
	protected function _attributes_for_link($attributes = array()){
		$attributes = parent::_attributes_for_link($attributes);
		//as long as we're using a lightbox to view this image, make sure it has the gallery attribute
		//only images should be part of the gallery - documents have scrolling problems
		if(!string_contains('lightbox', element('class', $attributes))) return $attributes;
		$default_attributes = array('rel' => 'gallery'); 
		return merge_attributes($default_attributes, $attributes);
	}
		
	
/////////////////////
// STATIC FUNCTIONS
/////////////////////

	public static function create($name, $binary_string, $more_values = array()){
		if(empty($binary_string)) return get_instance()->error->should_be_an_x('name of a '.humanize(get_called_class()).' file', $name);
		if(!static::matches_file($name, $binary_string)) return get_instance()->error->should_be_an_x('name of a '.humanize(get_called_class()).' file', $name);
		return new Image_attachment(array_merge(compact('name', 'binary_string'), $more_values));
	}

	public static function matches_file($name, $binary_string){
		if(!parent::matches_file($name, $binary_string)) return false;
		if(empty($binary_string)) return false;
		return in_array(strtolower(pathinfo($name, PATHINFO_EXTENSION)), static::$extensions);
	}
	
}
?>