<?php 
/**
* Functions designed to be used in tandem with the routing customizations described in {@link Icarus_Router} and {@link Icarus_URI}.
*
* @package icarus
* @subpackage helpers
*/

//ok, MG, these function names don't reflect that you're returning the current url, adjusted.
//how to make these names more descriptive without making ridiculously verbose even by your standards?

/**
* Set the var/value pairs of the (:get) portion of the current URL.
* Note that this will completely overwrite the current value of (:get).  If you'd like to preserve those values, use {@link merge_url_params()}.
* @see Icarus_URI::base_uri_string()
* @param array Map of query string var to query string value.
* @return string The current URL, with the (:get) portion set to the values of the given array.
*/
if(!function_exists('set_url_params')){
	function set_url_params($params){
		if(!validates_as('associative_array', $params)) return should_be('associative array', $params);
		
		$CI =& get_instance();
		if(empty($params))
			return $CI->uri->base_uri_string();
		else{
			return $CI->uri->base_uri_string().'/'.key_value_implode($params, '/', '/');
		}
	}
}


if(!function_exists('set_url_param')){
	function set_url_param($param, $value){
		if(!validates_as('nonempty_string', $param)) return should_be('nonempty string', $param);
		if(!validates_as('nonempty_string', $value) && !validates_as('numeric', $value)) return should_be('nonempty string or a number');
		return merge_url_params(array($param => $value));
	}
}

if(!function_exists('unset_url_param')){
	function unset_url_param($param){
		if(!validates_as('nonempty_string', $param)) return should_be('nonempty string', $param);
		$CI =& get_instance();
		$params = $CI->uri->url_params_to_assoc();
		if(array_key_exists($param, $params))
			unset($params[$param]);
		return set_url_params($params);
	}
}

if(!function_exists('merge_url_params')){
	function merge_url_params($new_params){
		if(!validates_as('associative_array', $new_params)) return should_be('associative array', $new_params);
		
		$CI =& get_instance();	
		$params = array_merge($CI->uri->url_params_to_assoc(), $new_params);
		return set_url_params($params);
	}
}

if(!function_exists('set_url_param_and_redirect')){
	function set_url_param_and_redirect($param, $value){
		if(!validates_as('nonempty_string', $param)) return should_be('nonempty string', $param);
		if(!validates_as('nonempty_string', $value) && !validates_as('numeric', $value)) return should_be('nonempty string or a number');
		redirect(set_url_param($param, $value));
	}
}

if(!function_exists('unset_url_param_and_redirect')){
	function unset_url_param_and_redirect($param){
		if(!validates_as('nonempty_string', $param)) return should_be('nonempty string', $param);
		redirect(unset_url_param($param));
	}
}

if(!function_exists('merge_url_params_and_redirect')){
	function merge_url_params_and_redirect($new_params){
		redirect(merge_url_params($new_params));
	}
}

if(!function_exists('set_url_params_and_redirect')){
	function set_url_params_and_redirect($params){
		redirect(merge_url_params($params));
	}
}

/* End of file url_helper.php */
/* Location: ./system/helpers/url_helper.php */