<?php 
/**
* Extension of the Codeigniter URL helper.
*
* @see https://ellislab.com/codeigniter/user-guide/helpers/url_helper.html
*
* @package vler
* @subpackage helpers
*/

if(!function_exists('raw_http_build_query')){
	/**
	* @param array
	* @return string
	*/
	function raw_http_build_query($query_vars){
		if(empty($query_vars)) return '';
		
		foreach($query_vars as $key => $value){
			if(is_null($value))
				$query_vars[$key] = ''; //keep nulls from getting removed - due to type juggling during string converstion, this ends up being the same thing. -- 2015-09-16 MG
		}
		
		return http_build_query($query_vars, null, '&', PHP_QUERY_RFC3986); 	
	}
}