<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package vler
* @subpackage core
*/


/**
* Extends Codeigniter library  to add a way of finding out if the profiler is enabled.
*
* Any changes to this library need to be made in both Webmail and the API.
*
* @package vler
* @subpackage core
*/
class VLER_Output extends CI_Output {
	
	//note - with the transition to CI 3.0, this is no longer needed - enable_profiler is now a public var.
	//when we are no longer swamped with required CI 3.0 changes, we may want to deprecate & remove this so that we can reduce the number of VLER extension libs  -- MG 2015-05-22
	function profiler_is_enabled(){
		return $this->enable_profiler; 
	}
	
	
	public function enable_profiler($val = TRUE){
		parent::enable_profiler($val);
		
		//since we now have a default value in the database library that determines whether or not to save queries based on whether or not the profilers on, we need to reset it after turning the profiler on
		foreach (get_object_vars(get_instance()) as $db_name => $CI_object){
			if(!is_object($CI_object) || !is_subclass_of(get_class($CI_object), 'CI_DB'))
				continue;
			get_instance()->$db_name->save_queries = get_instance()->$db_name->default_save_queries_value();
		}
		
		return $this;
	}	
}