<?php
/**
* @package direct-as-a-service
* @subpackage views
 * @filesource
*/ /** */

	$this->load->view('api/header');
	$this->load->view('api/nav');
	$this->load->helper('form');
?>
<script>
	var which_report = 'logins';
	$(function() {
		$('[id^=details-modal]').dialog({ autoOpen: false })
		$('[id^=details-link]').click(function(e){
			e.preventDefault();
			var id = $(e.target).attr('id').replace('details-link','');
			$('[id^=details-modal]').dialog({
				modal:true,
				width:460,
				height:500
			});
			$('[id=details-modal'+id+']').dialog('open');
		});

		$('[id^=details-modal]').on('click', '#close_pop_up', function(){
			$(this).closest('[id^=details-modal]').dialog('close');
		});
	});
</script>
				<h1>Logins</h1>
				<div class="column">
					<div id="tabs" class="column ui-tabs ui-widget ui-widget-content ui-corner-all">
						<ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
							<?php echo $tabs;?>
						</ul>
					<div class="tab-content">
						<p>This table lists the logins.</p>
						<?PHP $this->load->view('api/reports/adhoc_Reports/adhoc_report_info'); ?>
						<?PHP echo form_open('/reports/logins',array('id'=>'reports_form','onsubmit'=>"javascript:submitPaginationForm('', 1, ".$form_data['items_per_page'].", '');")); ?>
							<table class="form" role="presentation">
								<tr class="form_row">
									<td><label for="successful">Success:</label></td>
									<td>
										<select class="fill_row" id="successful" name="successful" onkeydown="if(event.keyCode == 13){this.form.submit();return false;}">
											<option value="(ALL)">(ALL)</option>
											<option value="1" <?php if(isset($form_data['successful']) && '1'==$form_data['successful']){echo "selected";}?>>TRUE</option>
											<option value="0" <?php if(isset($form_data['successful']) && '0'==$form_data['successful']){echo "selected";}?>>FALSE</option>
										</select>
									</td>
								</tr>
								<tr class="form_row">
									<td><label for="id">ID:</label></td>
									<td>
										<p class="hidden_context" style="display:none;" id="id_help">Table ID of the login request</p>
										<input class="ttFocus" aria-describedby="id_help" title="Table ID of the login request" id="id" name="id" type="text" value="<?php if(isset($form_data['id'])) { echo htmlentities($form_data['id']); } ?>" onkeydown="if(event.keyCode == 13){$('#id').onfocus = function(){this.form.submit();return false;}}"></input>
									</td>
									<td>
										<label for="id_type" class="hidden_context">Compare options for ID</label>
										<select id="id_type" name="id_type">
											<?php foreach($compare as $key => $value){ ?>
											<option value="<?php echo $key;?>" <?php if(isset($form_data['id_type']) && $key == $form_data['id_type']){echo "selected";}?>><?php echo $value?></option>
											<?php  } ?>
										</select>
									</td>
									<td><label for="username">Username:</label></td>
									<td>
										<p class="hidden_context" style="display:none;" id="username_help">Username of the user that logged in</p>
										<input class="ttFocus" aria-describedby="username_help" title="Username of the user that logged in" id="username" name="username" type="text" value="<?php if(isset($form_data['username'])) { echo htmlentities($form_data['username']); } ?>" onkeydown="if(event.keyCode == 13){$('#username').onfocus = function(){this.form.submit();return false;}}"></input>
									</td>
									<td>
										<label for="username_type" class="hidden_context">Compare options for Username</label>
										<select id="username_type" name="username_type">
											<?php foreach($compare as $key => $value){ ?>
											<option value="<?php echo $key;?>" <?php if(isset($form_data['username_type']) && $key==$form_data['username_type']){echo "selected";}?>><?php echo $value?></option>
											<?php  } ?>
										</select>
									</td>
								</tr>
								<tr class="form_row">
									<td><label for="session_id">Session ID:</label></td>
									<td>
										<p class="hidden_context" style="display:none;" id="session_id_help">The Session ID is a unique identified assigned by the server for the duration of the users visit</p>
										<input class="ttFocus" aria-describedby="session_id_help" title="The Session ID is a unique identified assigned by the server for the duration of the users visit" id="session_id" name="session_id" type="text" value="<?php if(isset($form_data['session_id'])) { echo htmlentities($form_data['session_id']); } ?>" onkeydown="if(event.keyCode == 13){$('#session_id').onfocus = function(){this.form.submit();return false;}}"></input>
									</td>
									<td>
										<label for="session_id_type" class="hidden_context">Compare options for Session ID</label>
										<select id="session_id_type" name="session_id_type">
											<?php foreach($compare as $key => $value){ ?>
											<option value="<?php echo $key;?>" <?php if(isset($form_data['session_id_type']) && $key == $form_data['session_id_type']){echo "selected";}?>><?php echo $value?></option>
											<?php  } ?>
										</select>
									</td>
									<td><label for="ip_address">IP Address:</label></td>
									<td>
										<p class="hidden_context" style="display:none;" id="ip_address_help">IP Address of user</p>
										<input class="ttFocus" aria-describedby="ip_address_help" title="IP Address of user" id="ip_address" name="ip_address" type="text" value="<?php if(isset($form_data['ip_address'])) { echo htmlentities($form_data['ip_address']); } ?>" onkeydown="if(event.keyCode == 13){$('#ip_address').onfocus = function(){this.form.submit();return false;}}"></input>
									</td>
									<td>
										<label for="ip_address_type" class="hidden_context">Compare options for IP Address</label>
										<select id="ip_address_type" name="ip_address_type">
											<?php foreach($compare as $key => $value){ ?>
											<option value="<?php echo $key;?>" <?php if(isset($form_data['ip_address_type']) && $key == $form_data['ip_address_type']){echo "selected";}?>><?php echo $value?></option>
											<?php  } ?>
										</select>
									</td>
								</tr>
								<tr class="form_row">
									<td><label for="message">Message:</label></td>
									<td>
										<p class="hidden_context" style="display:none;" id="message_help">Login message (Success/Unregistered/Error)</p>
										<input class="ttFocus" aria-describedby="message_help" title="Login message (Success/Unregistered/Error)" id="message" name="message" type="text" value="<?php if(isset($form_data['message'])) { echo htmlentities($form_data['message']); } ?>" onkeydown="if(event.keyCode == 13){$('#message').onfocus = function(){this.form.submit();return false;}}"></input>
									</td>
									<td>
										<label for="message_type" class="hidden_context">Compare options for Message</label>
										<select id="message_type" name="message_type">
											<?php foreach($compare as $key => $value){ ?>
											<option value="<?php echo $key;?>" <?php if(isset($form_data['message_type']) && $key == $form_data['message_type']){echo "selected";}?>><?php echo $value?></option>
											<?php  } ?>
										</select>
									</td>
									<td><label for="org_id">Org ID:</label></td>
									<td>
										<p class="hidden_context" style="display:none;" id="org_id_help">Organization ID for user</p>
										<input class="ttFocus" aria-describedby="org_id_help" title="Organization ID for user" id="org_id" name="org_id" type="text" value="<?php if(isset($form_data['org_id'])) { echo htmlentities($form_data['org_id']); } ?>" onkeydown="if(event.keyCode == 13){$('#org_id').onfocus = function(){this.form.submit();return false;}}"></input>
									</td>
									<td>
										<label for="org_id_type" class="hidden_context">Compare options for Org ID</label>
										<select id="org_id_type" name="org_id_type">
											<?php foreach($compare as $key => $value){ ?>
											<option value="<?php echo $key;?>" <?php if(isset($form_data['org_id_type']) && $key == $form_data['org_id_type']){echo "selected";}?>><?php echo $value?></option>
											<?php  } ?>
										</select>
									</td>
								</tr>
								<tr class="form_row">
									<td><label for="start_date">Start Date:</label></td>
									<td><input type="text" id="start_date" name="start_date" class="date" value="<?php if(isset($form_data['start_date'])) { echo htmlentities($form_data['start_date']); } ?>"onkeydown="if(event.keyCode == 13){$('#start_date').onfocus=function(){this.form.submit();return false;}}" onchange="checkBeforeAfterDates('start_date', 'end_date', 'End Date cannot be before Start Date.');"/></td>
									<td>&nbsp;</td>
									<td><label for="end_date">End Date:</label></td>
									<td><input type="text" id="end_date" name="end_date" class="date" value="<?php if(isset($form_data['end_date'])) { echo htmlentities($form_data['end_date']); } ?>"onkeydown="if(event.keyCode == 13){$('#end_date').onfocus = function(){this.form.submit();return false;}}" onchange="checkBeforeAfterDates('start_date', 'end_date', 'End Date cannot be before Start Date.');"/></td>
								</tr>
								<script>$('input.date').datetimepicker({timeFormat: "hh:mm tt", timeSuffix: ' '+timezone_abbr});</script>
							</table>
							<?PHP
								$export_file_name = 'Login Report';
								if (isset($form_data['report_name'])){
									$export_file_name = $form_data['report_name'];
								}
								$hidden_inputs = array(
									'order' => isset($form_data['order']) ? $form_data['order'] : '',
									'direction' => isset($form_data['direction']) ? $form_data['direction'] : '',
									'lastorder' => isset($form_data['order']) ? $form_data['order']  : '',
									'change' => 'false',
									'export' => '0',
									'export_pdf' => '0',
									'print_page' => '0',
									'page_on_bar' => '',
									'items_per_page' => ITEMS_PER_PAGE_DEFAULT,
									'export_file_name' => $export_file_name,
								);
								echo form_hidden($hidden_inputs,TRUE);
							?>
							<div class="center">
								<input class="blue-button" id="filter_button" name="filter_button" type="submit" value="Filter"></input>
								<input class="blue-button" id="details-link" name="details-link" type="submit" value="Save Report"></input>
								<input class="blue-button" id="clear_button" name="clear_button" type="button" value="Clear" onclick="$('#clear_form').submit();"></input>
							</div>
							<div id="date_error_message" class="message_error" style="display: none;"></div>
							<?php if(sizeof($login_list) == 0) { ?>
								<div class="message">There are currently no logins.</div>
							<?php }
							    {
								if(!empty($form_data['date_warning_message'])) { ?>
									<div class="message"><?php echo $form_data['date_warning_message']; ?></div>
								<?PHP } ?>
								<?php if(sizeof($login_list) > 0) { ?>
									<div class="pagination">
										<?php echo $form_data['pages']->display_result_num();?>
										<span>&nbsp;&nbsp;&nbsp;&nbsp;<?php echo $form_data['pages']->display_pages();?></span>
										<?php echo $form_data['pages']->display_items_per_page('top');?>
										<div class="pagination-options">
											<?PHP if ($form_data['pages']->items_total <= 1000) { ?>
												<a href="#" class="export"><img src="/images/icons/page_white_excel.png" class="link" style="border : 0;" alt="Export Excel" title="Export Excel"  /></a>
											<?PHP }
											else { ?>
												<a href="#" class="export"><img src="/images/icons/page_white_excel.png" class="link" style="border : 0;" alt="Export Excel" title="Export Excel"  /></a>
											<?PHP } ?>
											<a id="export_pdf_top" class="export_pdf"  href="#" ><img src="/images/icons/page_white_acrobat.png" class="link" style="border : 0;" alt="Export PDF" title="Export PDF"/></a>
											<a href="#"  onclick="submitPaginationForm('<?php echo $form_data['cur_page'];?>', '', '<?php echo $form_data['items_per_page'];?>', '', '', 1);"><img src="/images/icons/printer.png" class="link" style="border : 0;" alt="Print" title="Print"  /></a>
											<label for="page_select" class="hidden_context">Page Selector</label>
											<input id="page_select" class="page_selector_input" name="page_select" onchange="javascript:submitPaginationForm('', this.value, <?php echo $form_data['items_per_page'];?>, '', <?php echo $form_data['num_pages'];?>);" value="<?PHP echo $form_data['cur_page']?>">
											<span class="paginate"> of <?php echo $form_data['num_pages'];?></span>
										</div>
									</div>
								<?php } ?>
							<?php }?>
						<?PHP echo form_close(); ?>
						<a name="reportContent" id="reportContent" class="hidden_context hidden_link">Report Content</a>
						<?PHP echo form_open('/reports/logins',array('id'=>'clear_form')); echo form_close();
							  if(sizeof($login_list) > 0) {
								$this->load->view('api/reports/result_tables/result_logins');
						?>
							<div class="pagination">
								<?php echo $form_data['pages']->display_result_num();?>
								<span>&nbsp;&nbsp;&nbsp;&nbsp;<?php echo $form_data['pages']->display_pages();?></span>
								<?php echo $form_data['pages']->display_items_per_page('bottom');?>
								<div class="pagination-options">
									<?PHP if ($form_data['pages']->items_total <= 1000) { ?>
										<a href="#" class="export"><img src="/images/icons/page_white_excel.png" class="link" style="border : 0;" alt="Export Excel" title="Export Excel"  /></a>
									<?PHP }
									else { ?>
										<a href="#" class="export"><img src="/images/icons/page_white_excel.png" class="link" style="border : 0;" alt="Export Excel" title="Export Excel"  /></a>
									<?PHP } ?>
									<a id="export_pdf_bottom" class="export_pdf"  href="#" ><img src="/images/icons/page_white_acrobat.png" class="link" style="border : 0;" alt="Export PDF" title="Export PDF"/></a>
									<a href="#"  onclick="submitPaginationForm('<?php echo $form_data['cur_page'];?>', '', '<?php echo $form_data['items_per_page'];?>', '', '', 1);"><img src="/images/icons/printer.png" class="link" style="border : 0;" alt="Print" title="Print"  /></a>
									<label for="page_select_bottom" class="hidden_context">Page Selector</label>
									<input id="page_select_bottom" class="page_selector_input" name="page_select" onchange="javascript:submitPaginationForm('', this.value, <?php echo $form_data['items_per_page'];?>, '', <?php echo $form_data['num_pages'];?>);" value="<?PHP echo $form_data['cur_page']?>">
									<span class="paginate"> of <?php echo $form_data['num_pages'];?></span>
								</div>
							</div>
							<?php }?>
							<div id="details-modal" title="Save Current Report">
								<div class="adhoc_report">
									<?PHP
										$this->load->view('api/reports/adhoc_reports/adhoc_logins');
									?>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<?php $this->load->view('api/reports/result_tables/file_downloading_window');?>
			<?PHP $this->load->view('api/footer'); ?>
		</div>
	</body>
</html>