<?php
/**
* @package direct-as-a-service
* @subpackage views
 * @filesource
*/ /** */

	$this->load->view('api/header'); 
	$this->load->view('api/nav'); 
?>
				<h1><a href="/onboarding/documentation/" class="underline">Documentation</a> &rarr; <a class="underline" href="/onboarding/send">/direct/send</a> - POST</h1>
				<p>The send web service allows authorized applications to send messages using the Direct standards and can be accessed by sending a POST request to /direct/send. Below are some code examples for sending a message using the send web service.</p>
				<h3>Java</h3>
				<p>
					<?php 
			require_once APPPATH.'third_party/luminous/luminous.php'; 
			echo luminous::highlight('java', 'import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Properties;
import java.util.Map;
import java.util.HashMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
 
public class VLERDirectTest {
    private boolean validate(String address, Properties props) {
        boolean rtc = false;
        HttpURLConnection conn = null;
      
        try {
            String encaddress = new sun.misc.BASE64Encoder().encode(address.getBytes());
            URL url = new URL(((String)props.get("vler.validateurl")) + "?address=" + encaddress);
            conn = (HttpURLConnection)url.openConnection();
            java.util.Date dt = new java.util.Date();
            SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss z");
            String dstr = sdf.format(dt);
            String reqstr = "GET\n" + dstr + "\n" + ((String)props.get("vler.validatepath")) + "?address=" + encaddress;
            Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
            SecretKeySpec secret_key = new SecretKeySpec(((String)props.get("vler.privatekey")).getBytes(),"HmacSHA256");
            sha256_HMAC.init(secret_key);
            byte[] sha = sha256_HMAC.doFinal(reqstr.getBytes());
            String encsha = new sun.misc.BASE64Encoder().encode(sha);
            String auth = "DAAS " + ((String)props.get("vler.publickey")) + ":" + encsha;
            conn.setRequestProperty("Authorization", auth);
            conn.setRequestProperty("Date", dstr);
            conn.setRequestProperty("Accept", "application/json");
            conn.setRequestMethod("GET");
            if (conn.getResponseCode() != 200) {
                throw new RuntimeException("Failed : HTTP error code : " + conn.getResponseCode());
            }
            BufferedReader br = new BufferedReader(new InputStreamReader((conn.getInputStream())));
            String output;
            String resp = "";
            while ((output = br.readLine()) != null) {
                resp += output;
            }
            if (resp.indexOf("\"valid\":true") >= 0) {
                  rtc = true;
            }
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        } catch (InvalidKeyException e) {
            e.printStackTrace();
        } catch (MalformedURLException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rtc;
    }
    private boolean send(String sender, String to, String cc, String mailtype, String priority, String subject, String body, String[] files, Properties props) {
        boolean rtc = false;
        HttpURLConnection conn = null;
      
        try {
            URL url = new URL(((String)props.get("vler.sendurl")));
            conn = (HttpURLConnection)url.openConnection();
            java.util.Date dt = new java.util.Date();
            SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss z");
            String dstr = sdf.format(dt);
            String reqstr = "POST\n" + dstr + "\n" + ((String)props.get("vler.sendpath"));
            Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
            SecretKeySpec secret_key = new SecretKeySpec(((String)props.get("vler.privatekey")).getBytes(),"HmacSHA256");
            sha256_HMAC.init(secret_key);
            byte[] sha = sha256_HMAC.doFinal(reqstr.getBytes());
            String encsha = new sun.misc.BASE64Encoder().encode(sha);
            String auth = "DAAS " + ((String)props.get("vler.publickey")) + ":" + encsha;
            conn.setRequestProperty("Authorization", auth);
            conn.setRequestProperty("Date", dstr);
            String charset = "UTF-8";
            String boundary = Long.toString(System.currentTimeMillis(), 16);
            String lineEnd = "\r\n";
            String twoHyphens = "--";
            String uploadFile = "c32input.xml";
           
            // Allow Inputs
            conn.setDoInput(true);
 
            // Allow Outputs
            conn.setDoOutput(true);
 
            // Don\'t use a cached copy.
            conn.setUseCaches(false);
 
            // Use a post method.
            conn.setRequestMethod("POST");
            
            conn.setRequestProperty("Connection", "Keep-Alive");
            conn.setRequestProperty("Accept-Charset", charset);
            conn.setRequestProperty("Charset", charset);
            conn.setRequestProperty("ENCTYPE", "multipart/form-data");
            conn.setRequestProperty("Cache-Control", "no-cache");
            conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary); //boundary was misspelled here as boundry
           
            DataOutputStream ds = new DataOutputStream(conn.getOutputStream());
           
       		//put plain text post data into an array so we can build the raw request
            Map<String, String> post_fields = new HashMap<String, String>();
            post_fields.put("sender",sender);
            post_fields.put("to",to);
            if (cc != null && cc.length() > 0) {post_fields.put("cc",cc); }
            if (subject != null && subject.length() > 0) { post_fields.put("subject",subject); }
            if (body != null && body.length() > 0) { post_fields.put("body",body); }
            if (mailtype != null && mailtype.length() > 0) { post_fields.put("mailtype",mailtype); }
            if (priority != null && priority.length() > 0) { post_fields.put("priority",priority); }
            
			//setRequestProperty seems to set headers for the overall request, but the POST body comes after those
            //so loop through normal POST fields and add to raw request body instead
            for(Map.Entry<String, String> entry : post_fields.entrySet()) {
            	ds.writeBytes(twoHyphens + boundary + lineEnd);
            	ds.writeBytes("Content-Disposition: form-data; name=\""+entry.getKey()+"\"" + lineEnd + lineEnd + entry.getValue() + lineEnd);
            }
                 
            //if you have more than one file you\'d loop through them here, but let\'s just use your one example file for now
            ds.writeBytes(twoHyphens + boundary + lineEnd);
            ds.writeBytes("Content-Disposition: form-data; name=\"files\";filename=\"" + uploadFile +"\"" + lineEnd);
            //added generic content type for the file and specified transfer encoding, this appears to be necessary for files
            ds.writeBytes("Content-Type: application/octet-stream" + lineEnd);
            ds.writeBytes("Content-Transfer-Encoding: binary" + lineEnd);
            ds.writeBytes(lineEnd);
 			
            FileInputStream fStream = new FileInputStream(uploadFile);
            int bufferSize = 1024;
            byte[] buffer = new byte[bufferSize];
            int length = -1;
 
            while((length = fStream.read(buffer)) != -1) {
              ds.write(buffer, 0, length);
            }
            ds.writeBytes(lineEnd);
            ds.writeBytes(twoHyphens + boundary + twoHyphens + lineEnd);
            /* close streams */
			
            fStream.close();
            ds.flush();
            ds.close();
			//conn.connect();
           
           	//added the response message on failure as well, because it can help with debugging potentially
            if (conn.getResponseCode() != 200) {
                throw new RuntimeException("\nFailed : HTTP error code : " + conn.getResponseCode() + "\nHTTP response : " + conn.getResponseMessage());
            }
            BufferedReader br = new BufferedReader(new InputStreamReader((conn.getInputStream())));
            String output;
            String resp = "";
            while ((output = br.readLine()) != null) {
                resp += output;
            }
			System.err.println("resp = " + resp);
            if (resp.indexOf("\"message\":\"Message sent.\"") >= 0) { //for a successful send, you should get a messsage field saying Message sent
                  rtc = true;
            }
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        } catch (InvalidKeyException e) {
            e.printStackTrace();
        } catch (MalformedURLException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rtc;
    }
   
    public static void main(String[] args) {
        VLERDirectTest test = new VLERDirectTest();
        Properties props = System.getProperties();
        props.put("vler.publickey", "YOUR_PUBLIC_API_KEY");
        props.put("vler.privatekey", "YOU_PRIVATE_API_KEY");
        props.put("vler.validateurl", "https://'.API_DOMAIN.'/direct/validate/format/json");
        props.put("vler.validatepath","/direct/validate/format/json");
        props.put("vler.sendurl", "https://'.API_DOMAIN.'/direct/send/format/json");
        props.put("vler.sendpath","multipart/form-data\n/direct/send/format/json");
       
        System.out.println("user@example.com: " + test.validate("user@example.com", props));
        System.out.println("send user@demo.example.com: " + test.send("user@demo.example.com", "abell2@demo.example.com", "", "", "", "Test subject", "Test body", null, props));
     }
}
', false);
		?>
				</p>
				<h3>HTML and JavaScript</h3>
				<p>
					<?php 
						echo luminous::highlight('php', html_entity_decode('&#x3C;html lang=&#x22;en&#x22;&#x3E;
&#x3C;head&#x3E;
    &#x3C;meta charset=&#x22;UTF-8&#x22;&#x3E;
    &#x3C;title&#x3E;VLER Direct POST Sample&#x3C;/title&#x3E;
    &#x3C;script src=&#x22;https://cdnjs.cloudflare.com/ajax/libs/jquery/2.2.2/jquery.js&#x22;&#x3E;&#x3C;/script&#x3E;
    &#x3C;script src=&#x22;https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.11.4/i18n/jquery-ui-i18n.js&#x22;&#x3E;&#x3C;/script&#x3E;
    &#x3C;script src=&#x22;https://crypto-js.googlecode.com/svn/tags/3.0.2/build/rollups/hmac-sha256.js&#x22;&#x3E;&#x3C;/script&#x3E;
    &#x3C;script src=&#x22;https://crypto-js.googlecode.com/svn/tags/3.0.2/build/components/enc-base64-min.js&#x22;&#x3E;&#x3C;/script&#x3E;
    &#x3C;script src=&#x22;https://cdnjs.cloudflare.com/ajax/libs/jquery.form/3.51/jquery.form.min.js&#x22;&#x3E;&#x3C;/script&#x3E;
    &lt;script src=&quot;//oss.maxcdn.com/jquery.form/3.50/jquery.form.min.js&quot;&gt;&lt;/script&gt;

        &#x3C;style&#x3E;
        #success{
            display:none;
        }
        #error{
            display:none;
        }
    &#x3C;/style&#x3E;
    &#x3C;script type=&#x22;text/javascript&#x22;&#x3E;
			var PUBLIC_API_KEY = &quot;YOUR_PUBLIC_API_KEY&quot;;
			var PRIVATE_API_KEY = &quot;YOUR_PRIVATE_API_KEY&quot;;
            var messagesSent = 0;

            var attachments = 0;

            var attempts = 0;

            var keyStr = &quot;ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=&quot;;

            var start = new Date().getTime();
            var end = new Date().getTime();

            function encode64(input) {
               if (!String(input).length) return false;
               var output = &quot;&quot;;
               var chr1, chr2, chr3;
               var enc1, enc2, enc3, enc4;
               var i = 0;

               do {
                  chr1 = input.charCodeAt(i++);
                  chr2 = input.charCodeAt(i++);
                  chr3 = input.charCodeAt(i++);

                  enc1 = chr1 &gt;&gt; 2;
                  enc2 = ((chr1 &amp; 3) &lt;&lt; 4) | (chr2 &gt;&gt; 4);
                  enc3 = ((chr2 &amp; 15) &lt;&lt; 2) | (chr3 &gt;&gt; 6);
                  enc4 = chr3 &amp; 63;

                  if (isNaN(chr2)) {
                     enc3 = enc4 = 64;
                  } else if (isNaN(chr3)) {
                     enc4 = 64;
                  }

                  output = output + keyStr.charAt(enc1) + keyStr.charAt(enc2) + 
                     keyStr.charAt(enc3) + keyStr.charAt(enc4);
               } while (i &lt; input.length);
               
               return output;
            }

            function addRow() {
                attachments++;
                var refnode = $(\'#attach_div\');
                var attach = $(\'&lt;div class=&quot;add_attach&quot;&gt;&lt;label&gt;File:&lt;/label&gt; &lt;input class=&quot;attachmentItem&quot; type=&quot;file&quot; class=&quot;attachment&quot; name=&quot;attachment\'+attachments+\'&quot; id=&quot;attachment\'+attachments+\'&quot;/&gt;&lt;a href=&quot;#&quot; onClick=&quot;$(this).parent().remove();&quot;&gt;Remove&lt;/a&gt;&lt;/div&gt;\');
                attach.insertBefore(refnode);
            };
            
            $(function() {
                $(&quot;.json&quot;).click(function() {
                    $(&quot;#sender&quot;).css(&quot;background-color&quot;,&quot;#fff&quot;);
                    $(&quot;#to&quot;).css(&quot;background-color&quot;,&quot;#fff&quot;);
                    $(&quot;#messageForm&quot;).ajaxSubmit({  
                      type: &quot;POST&quot;,  
                      url: &quot;https://'.API_DOMAIN .'/direct/send/format/json&quot;,
                      beforeSend: function(request){
                        start = new Date().getTime();
                        //use this block if you want to send UTC stamp
                        var d = Date.now();
                        var currentDate = Math.round(d / 1000);
                        //use this block if you want to send normal timestamp with timezone
                        /*var d = new Date();
                        var currentDate = d.format(&quot;mm/dd/yyyy HH:MM:ss Z&quot;);*/
                    
                        var hashString = CryptoJS.HmacSHA256(&quot;POST\n&quot;+currentDate+&quot;\nmultipart/form-data\n/direct/send/format/json&quot;,PRIVATE_API_KEY);
                        var base64 = encode64(&quot;&quot;+hashString);
                        var authorization = &quot;DAAS &quot;+PUBLIC_API_KEY+&quot;:&quot;+base64;
                        request.setRequestHeader(&quot;Authorization&quot;, authorization);
                        request.setRequestHeader(&quot;X-Daas-Date&quot;, currentDate);
                        attempts++;
                        var appendStr = &quot;&lt;div class=\&quot;innerPost break-word\&quot; id=\&quot;post&quot;+attempts+&quot;\&quot;&gt;&quot;+
                                                &quot;&lt;div class=\&quot;inner\&quot;&gt;&lt;label&gt;&quot;+attempts+&quot;.&lt;/label&gt;&lt;/div&gt;&quot;+
                                                &quot;&lt;div class=\&quot;inner\&quot;&gt;&lt;label&gt;Custom Request Headers&lt;/label&gt;&lt;/div&gt;&quot;+
                                                &quot;&lt;div class=\&quot;inner indent\&quot;&gt;&lt;label&gt;Authentication: &lt;/label&gt;&quot;+authorization+&quot;&lt;/div&gt;&quot;+
                                                &quot;&lt;div class=\&quot;inner indent\&quot;&gt;&lt;label&gt;DaasDate: &lt;/label&gt;&quot;+currentDate+&quot;&lt;/div&gt;&quot;+
                                                &quot;&lt;div class=\&quot;inner\&quot;&gt;&lt;label&gt;Content&lt;/label&gt;&lt;/div&gt;&quot;+
                                                &quot;&lt;div class=\&quot;inner indent\&quot;&gt;&lt;label&gt;Mailtype: &lt;/label&gt;&quot;+$(\'#mailtype\').val()+&quot;&lt;/div&gt;&quot;+
                                                &quot;&lt;div class=\&quot;inner indent\&quot;&gt;&lt;label&gt;Priority: &lt;/label&gt;&quot;+$(\'#priority\').val()+&quot;&lt;/div&gt;&quot;+
                                                &quot;&lt;div class=\&quot;inner indent\&quot;&gt;&lt;label&gt;To: &lt;/label&gt;&quot;+$(\'#to\').val()+&quot;&lt;/div&gt;&quot;+
                                                &quot;&lt;div class=\&quot;inner indent\&quot;&gt;&lt;label&gt;Sender: &lt;/label&gt;&quot;+$(\'#sender\').val()+&quot;&lt;/div&gt;&quot;+
                                                &quot;&lt;div class=\&quot;inner indent\&quot;&gt;&lt;label&gt;Subject: &lt;/label&gt;&quot;+$(\'#subject\').val()+&quot;&lt;/div&gt;&quot;+
                                                &quot;&lt;div class=\&quot;inner indent\&quot;&gt;&lt;label&gt;Body: &lt;/label&gt;&quot;+$(\'#body\').val()+&quot;&lt;/div&gt;&quot;+
                                                &quot;&lt;div class=\&quot;inner\&quot;&gt;&lt;label&gt;Files&lt;/label&gt;&lt;/div&gt;&quot;;
                        $(\'.attachmentItem\').each(function(){
                            if ($(this).val()){
                                appendStr += &quot;&lt;div class=\&quot;inner indent\&quot;&gt;&lt;label&gt;&quot;+$(this).attr(\'name\')+&quot;: &lt;/label&gt;&quot;+$(this).val().mb_split(\'\\\\\').pop()+&quot;&lt;/div&gt;&quot;;
                            }
                        });
                        appendStr += &quot;&lt;/div&gt;&quot;;
                        $(\'#postWrapper\').append(appendStr);
                      },
                      success: function(data, status, jqXHR) { 
                        $(\'#success\').html(data[\'message\']).slideDown(500).delay(10000).slideUp(500);
                        end = new Date().getTime();
                        $(\'#responseWrapper\').append(&quot;&lt;div class=\&quot;inner break-word\&quot;&gt;&lt;label&gt;&quot;+attempts+&quot;. &quot;+status+&quot; - &lt;/label&gt;&quot;+jqXHR.responseText + &quot;, Execution time: &quot;+(end - start)+&quot; ms&lt;/div&gt;&quot;);
                        $(\'#post\'+attempts).css(&quot;background&quot;, &quot;#E0FFD6&quot;);
                        $(\'#post\'+attempts).css(&quot;border&quot;, &quot;1px solid #008A1A&quot;);
                        $(\'.add_attach\').remove();
                        $(\'#messageForm\')[0].reset();
                        attachments = 0;
                        messagesSent++;
                      },
                      error: function (jqXHR, textStatus, errorThrown) {
                        end = new Date().getTime();
                        $(\'#error\').html(\'&lt;div class=&quot;imageText&quot;&gt;\' + $.parseJSON(jqXHR.responseText)[\'message\'] + \'&lt;/div&gt;\').slideDown(500).delay(10000).slideUp(500);
                        $(\'#responseWrapper\').append(&quot;&lt;div class=\&quot;inner\&quot;&gt;&lt;label&gt;&quot;+attempts+&quot;. &quot;+textStatus+&quot; - &lt;/label&gt;&quot;+jqXHR.responseText+&quot;, Execution time: &quot;+(end - start)+&quot; ms&lt;/div&gt;&quot;);
                        $(\'#post\'+attempts).css(&quot;background&quot;, &quot;#fef1ec&quot;);
                        $(\'#post\'+attempts).css(&quot;border&quot;, &quot;1px solid #990000&quot;);
                        for (var i = 0; i &lt; $.parseJSON(jqXHR.responseText)[\'fields\'].length; i++){
                            $(\'#\'+$.parseJSON(jqXHR.responseText)[\'fields\'][i]).css(&quot;background-color&quot;, &quot;#fef1ec&quot;);
                        }
                      }
                    });
                });
            });
        &lt;/script&gt;
    &lt;/head&gt;
    &lt;body&gt;
        &lt;div class=&quot;container&quot;&gt;
            &lt;h1&gt;Direct Mail&lt;/h1&gt;
            &lt;div id=&quot;success&quot;&gt;Message sent!&lt;/div&gt;
            &lt;div id=&quot;error&quot;&gt;Message failed!&lt;/div&gt;
            &lt;div class=&quot;wrapper&quot;&gt;
                &lt;form enctype=&quot;multipart/form-data&quot; id=&quot;messageForm&quot; action=&quot;https://'.API_DOMAIN .'/direct/send&quot; method=&quot;POST&quot;&gt;
                    &lt;label&gt;Mailtype:&lt;/label&gt; &lt;select name=&quot;mailtype&quot; id=&quot;mailtype&quot;&gt;
                                                &lt;option value=&quot;HTML&quot;&gt;HTML&lt;/option&gt;
                                                &lt;option value=&quot;TEXT&quot;&gt;Text&lt;/option&gt;
                                             &lt;/select&gt; 
                    &lt;label class=&quot;left-spacing&quot;&gt;Priority:&lt;/label&gt; &lt;select name=&quot;priority&quot; id=&quot;priority&quot;&gt;
                                                    &lt;option value=&quot;5&quot;&gt;Low&lt;/option&gt;
                                                    &lt;option value=&quot;3&quot; SELECTED&gt;Medium&lt;/option&gt;
                                                    &lt;option value=&quot;1&quot;&gt;High&lt;/option&gt;
                                                       &lt;/select&gt;&lt;br/&gt;
                    &lt;label&gt;Sender:&lt;/label&gt; &lt;input type=&quot;text&quot; name=&quot;sender&quot; id=&quot;sender&quot;&gt; &lt;label class=&quot;left-spacing&quot;&gt;To:&lt;/label&gt; &lt;input type=&quot;text&quot; name=&quot;to&quot; id=&quot;to&quot;&gt;&lt;br/&gt;
                    &lt;label&gt;Subject:&lt;/label&gt; &lt;input type=&quot;text&quot; class=&quot;full&quot; name=&quot;subject&quot; id=&quot;subject&quot;&gt;&lt;br/&gt;
                    &lt;label&gt;Body:&lt;/label&gt; &lt;textarea name=&quot;body&quot; id=&quot;body&quot;&gt;&lt;/textarea&gt;&lt;br/&gt;
                    &lt;div class=&quot;attachment&quot;&gt;&lt;label&gt;File:&lt;/label&gt; &lt;input class=&quot;attachmentItem&quot; type=&quot;file&quot; name=&quot;attachment0&quot; id=&quot;attachment0&quot;/&gt;&lt;/div&gt;
                    &lt;div id=&quot;attach_div&quot;&gt;&lt;label&gt;&amp;nbsp;&lt;/label&gt;&lt;a href=&quot;#&quot; onclick=&quot;javascript:addRow();&quot;&gt;Add additional file&lt;/a&gt;&lt;/div&gt;
                &lt;/form&gt;
            &lt;/div&gt;
            &lt;div class=&quot;button-container&quot;&gt;&lt;input type=&quot;button&quot; class=&quot;button json&quot; value=&quot;Send&quot;&gt;&lt;/div&gt;
        &lt;/div&gt;
        &lt;br/&gt;&lt;br/&gt;
        &lt;div id=&quot;post&quot; class=&quot;message-container&quot;&gt;
            &lt;h1&gt;Post Request&lt;/h1&gt;
            &lt;div id=&quot;postWrapper&quot; class=&quot;wrapper&quot;&gt;
            
            &lt;/div&gt;
        &lt;/div&gt;
        &lt;br/&gt;&lt;br/&gt;
        &lt;div id=&quot;response&quot; class=&quot;message-container&quot;&gt;
            &lt;h1&gt;Response Messages&lt;/h1&gt;
            &lt;div id=&quot;responseWrapper&quot; class=&quot;wrapper&quot;&gt;
            
            &lt;/div&gt;
        &lt;/div&gt;
    &lt;/body&gt;'), false);
					?>
				</p>
			</div>
			<?PHP $this->load->view('api/footer'); ?>
		</div>
	</body>
</html>