<?php
/**
* @package direct-as-a-service
* @subpackage views
 * @filesource
*/ /** */

?>
<p>Below is a list of the available web services and links to their documentation.</p>
<table class="table table-bordered table-hover">
	<caption class="sr-only">API Service Documentation</caption>
	<tr>
		<th class="col-md-3">Name</th>
		<th class="col-md-3">Endpoint</th>
		<th class="col-md-6">Description</th>
	</tr>
	<tr>
		<td><a href="/onboarding/documentation/disclosure/">Accounting of Disclosure</a></td>
		<td>/disclosure</td>
		<td>The Disclosure web service allows authorized applications to retrieve Accounting of Disclosure information and can be accessed by sending a GET request to /disclosure.</td>
	</tr>
	<tr>
		<td><a href="/onboarding/documentation/log_disclosure/">Log Disclosure</a></td>
		<td>/direct/disclosure/log</td>
		<td>The Disclosure Log web service allows authorized applications to send required disclosure information and can be accessed by sending a POST request to /direct/disclosure/log.</td>
	</tr>
	<tr>
		<td><a href="/onboarding/documentation/folders/">Retrieve Folders</a></td>
		<td>/direct/folders</td>
		<td>The Folders web service allows authorized applications to return all custom folders using the Direct standards and can be accessed by sending a GET request to /direct/folders. An example of the Headers and Arguments for the Folders GET request can be seen below.</td>
	</tr>
	<tr>
		<td><a href="/onboarding/documentation/archive_folder/">Archive Folder</a></td>
		<td>/direct/folders/archive</td>
		<td>The Archive Folder web service allows authorized applications to delete a folder and all messages within it will be moved to the archive folder and can be accessed by sending a POST request to /direct/folders/archive.</td>
	</tr>
	<tr>
		<td><a href="/onboarding/documentation/create_folder/">Create Folder</a></td>
		<td>/direct/folders/create</td>
		<td>The Create Folder web service allows authorized applications to create a new folder for a mailbox (user or group) and can be accessed by sending a POST request to /direct/folders/create.</td>
	</tr>
	<tr>
		<td><a href="/onboarding/documentation/rename_folder/">Rename Folder</a></td>
		<td>/direct/folders/rename</td>
		<td>The Rename Folder web service allows authorized applications to rename an existing folder and can be accessed by sending a POST request to /direct/folders/rename.</td>
	</tr>
	<tr>
		<td><a href="/onboarding/documentation/messages/">Retrieve Messages</a></td>
		<td>/direct/messages</td>
		<td>The message web service allows authorized applications to retrieve and search messages and can be accessed by sending a GET request to /direct/messages.</td>
	</tr>
	<tr>
		<td><a href="/onboarding/documentation/archive_message/">Archive Message</a></td>
		<td>/direct/messages/archive</td>
		<td>The Archive Message web service allows authorized applications to archive messages and can be accessed by sending a POST request to /direct/messages/archive.</td>
	</tr>
	<tr>
		<td><a href="/onboarding/documentation/count_message/">Message Count</a></td>
		<td>/direct/messages/count</td>
		<td>The Count web service allows authorized applications to find the counts of messages that would be retrieved if pulling the messages using the same criteria and can be accessed by sending a GET request to /direct/messages/count. This service is useful for determining how many messages a potential retrieve call will return.</td>
	</tr>
	<tr>
		<td><a href="/onboarding/documentation/move_message/">Move Message</a></td>
		<td>/direct/messages/move</td>
		<td>The Move Message web service allows authorized applications to move messages from one folder to another and can be accessed by sending a POST request to /direct/messages/move.</td>
	</tr>
	<tr>
		<td><a href="/onboarding/documentation/restore_message/">Restore Message</a></td>
		<td>/direct/messages/restore</td>
		<td>The Restore Message web service allows authorized applications to restore message to a folder if that folder still exists and can be accessed by sending a POST request to /direct/messages/restore.</td>
	</tr>
	<tr>
		<td><a href="/onboarding/documentation/save_message/">Save Message</a></td>
		<td>/direct/messages/save</td>
		<td>The Save Message web service allows authorized applications to save messages as drafts and can be accessed by sending a POST request to /direct/messages/save.</td>
	</tr>
	<tr>
		<td><a href="/onboarding/documentation/send/">Send Message</a></td>
		<td>/direct/send</td>
		<td>The send web service allows authorized applications to send messages using the Direct standards and can be accessed by sending a POST request to /direct/send.</td>
	</tr>
	<tr>
		<td><a href="/onboarding/documentation/send_draft/">Send Draft Message</a></td>
		<td>/direct/send/draft</td>
		<td>The Send Draft web service allows authorized applications to send messages using the Direct standards that have been stored as drafts in the past and can be accessed by sending a POST request to /direct/send/draft.</td>
	</tr>
	<tr>
		<td><a href="/onboarding/documentation/validate/">Validate Trust</a></td>
		<td>/direct/validate</td>
		<td>The validate web service allows authorized applications to check if a Direct address is a trusted recipient and can be accessed by sending a GET request to /direct/validate.</td>
	</tr>
	<tr>
		<td>
			<a href="/onboarding/documentation/directory_search">Directory Search</a>
		</td>
		<td>/direct/addresses</td>
		<td>The directory search web service allows authorized applications to retrieve directory information and can be accessed by sending a GET request to /direct/addresses.
		</td>
	</tr>
	<tr>
		<td><a href="/onboarding/documentation/automatic_reply_retrieve">Retrieve Automatic Reply</a></td>
		<td>/direct/automatic_reply/find</td>
		<td>The Automatic Reply service allows authorized applications to retrieve an “Out of Office” message for a mailbox and can accessed by sending a GET request to direct/automatic_reply/find</td>
	</tr>
	<tr>
		<td><a href="/onboarding/documentation/automatic_reply_create">Create Automatic Reply</a></td>
		<td>/direct/automatic_reply/create</td>
		<td>The Automatic Reply service allows authorized applications to create an “Out of Office” message for a mailbox and can accessed by sending a GET request to direct/automatic_reply/create
		</td>
	</tr>
	<tr>
		<td><a href="/onboarding/documentation/automatic_reply_update">Update Automatic Reply</a></td>
		<td>/direct/automatic_reply/update</td>
		<td>The Automatic Reply service allows authorized applications to update an “Out of Office” message for a mailbox and can accessed by sending a GET request to direct/automatic_reply/update
		</td>
	</tr>
	<tr>
		<td><a href="/onboarding/documentation/automatic_reply_delete">Delete Automatic Reply</a></td>
		<td>/direct/automatic_reply/delete</td>
		<td>The Automatic Reply service allows authorized applications to delete an “Out of Office” message for a mailbox and can accessed by sending a GET request to direct/automatic_reply/delete
		</td>
	</tr>
	<tr>
		<td><a href="/onboarding/documentation/mailboxes">Retrieve Mailboxes</a></td>
		<td>/direct/mailboxes</td>
		<td>The Mailboxes service allows authorized applications to return all mailboxes the specified user has access to and can be accessed by sending a GET request to direct/mailboxes.</td>
	</tr>
</table>