<?PHP 
/**
* @package direct-as-a-service
* @subpackage views
*/ 

$CI = get_instance();

//we need mailbox, user, and application to be passed
if(!isset($application) || !Application::is_an_entity($application)) $this->error->should_be_a_user_entity($application);
if(!isset($mailbox) || !Mailbox::is_an_entity($mailbox)) $this->error->should_be_a_mailbox_entity($mailbox);
if(!isset($user) || !User::is_an_entity($user)) $this->error->should_be_a_user_entity($user);

$user_feedback_message = '<p>The '.mailto($application->poc_email, $application->name).'</strong> application is requesting authorization to Direct Services '.
						 'in order to access the '.mailto($mailbox->email_address()).' mailbox on your behalf.  However, you cannot grant this '.
						 'permission because the account that you are logged in as ('.mailto($user->email_address()).') does not have access to this mailbox.</p>'.
						 '<p>If you believe this message to be in error, please contact the administrator for assistance.</p>';



$hidden_inputs = array(
		'id' =>  $application->id,
		'mailbox_name' => $mailbox->name,
		'is_group' => $mailbox->is_group,
		'redirect_url' => $redirect_url,
	);

?><!doctype html>
<html lang="en">
	<head>
		<meta charset="utf-8">
		<meta http-equiv="x-ua-compatible" content="ie=edge">
		<title>Direct Service Authorization</title>
		<meta name="description" content="An application for secure health messaging.">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<link rel="stylesheet" href="/css/bootstrap.min.css">
		<link rel="stylesheet" href="/css/template.css">
		<style>
			body { margin: 10px; }
			table { font-size: 0.9em; }
			label { font-weight: normal; }
			.btn ~ .cancel { margin-left: 1em; }
			.btn-sm ~ .cancel { font-size: 0.9em; }
			.checkbox-container { width: 3em; text-align: center; }			
		</style>
	</head>
	<body>
<?php if(!empty($service_error_message)): ?>
			<div>
            	<p><strong>Service Permission Error</strong></p>
				<p><?PHP echo $service_error_message ?></p>
			</div>
<?php else: ?>	
		<?php echo form_open(implode_nonempty('?', array(current_url(), $_SERVER['QUERY_STRING']))); ?>
			<p><strong><?php echo $application->name ?></strong> is requesting authorization from the <?php echo PRODUCT_NAME ?> to perform the following services on behalf of <strong><?php echo $mailbox->name  ?></strong>.  We recommend that you allow all services in order to use all features of the application.</p>
			<?php if(!empty($success_message)) echo dismissable_alert($success_message, 'success'); ?>
			<?php echo form_hidden($hidden_inputs,TRUE); ?>
			<table class="table table-bordered table-hover table-condensed">
				<tr>
					<th class="checkbox-container">
						<label for="select_all" class="sr-only">Select All Permissions</label>
						<?php echo form_checkbox('select_all', 1, (array_sum(array_unique(collect('authorized', $service_permissions))) == 1), 'id="select_all" class="select-all"') ?>
					</th>
					<th>Service</th>
					<th>Description</th>
				</tr>	
				<?php foreach($service_permissions as $permission): ?>
				<tr>
					<td class="checkbox-container">
						<?php echo form_checkbox('service_permissions['.$permission->name.']', 1, (bool)$permission->authorized, 'id="'.$permission->name.'"') ?>
					</td>
					<td><label for="<?php echo $permission->name ?>"><?php echo ucfirst($permission->name) ?></label></td>
					<td><?php echo $permission->description ?></td>
				</tr>
				<?php endforeach ?>
			</table>
			<div class="text-right">
				<button type="submit" id="save" name="save" class="btn btn-default btn-sm">Save</button>
				<?php if(!empty($redirect_url)) echo link_to($redirect_url, 'Cancel', 'class="cancel"'); ?>
			</div>
			<?php echo form_close(); ?> 
		<?PHP endif ?>
		<script src="https://code.jquery.com/jquery-2.2.3.min.js"></script>
		<script>window.jQuery || document.write('<script src="js/jquery.min.js"><\/script>')</script>
		<script src="/js/bootstrap.min.js"></script>
		<script type="text/javascript">
			$().ready(function() {
				$("input:checkbox.select-all").change(function() {
					$(this).closest('form').find('input:checkbox').prop('checked', $(this).prop("checked"));
				});
				$("input:checkbox.select-all").closest('form').find('input:checkbox:not(.select-all)').change(function(){
					var allSelected = true;
					$("input:checkbox.select-all").closest('form').find('input:checkbox:not(.select-all)').each(function(){
						allSelected = allSelected && $(this).prop('checked');
					});
					$('input:checkbox.select-all').prop('checked', allSelected);
				});
			});
		</script>
	</body>
</html>