<?php
/**
* @package direct-as-a-service
* @subpackage views
* @filesource
*/ /** */

//expects to be passed $status -> 'active' or 'disabled'
//expects to be passed an array of Groups

?>
								<p>This table lists the <?php echo $status ?> groups.</p>
								<br/>
								<table id="<?php echo $status ?>_group_table" class="display">
									<caption class="hidden_context"><?php echo ucfirst($status) ?> Groups</caption>
									<thead>
										<tr class="gridheader">
											<th scope="col">Group Name</th>
											<th scope="col">Display name</th>											
											<th scope="col">Domain</th>
											<th scope="col">Access</th>
											<th scope="col" width="10%" class="displaylast">Actions</th>
										</tr>
									</thead>
									<tbody>
										<?php foreach($groups as $group): ?>
											<tr>
												<td class="center break-word"><a href="/administration/manage/groups/edit/<?php echo $group->name ?>"><?php echo $group->name ?></a></td>
												<td class="center break-word"><?php echo $group->display_name; ?></td>
												<td class="center break-word"><?php echo $group->domain; ?></td>
												<td class="center break-word"><?php foreach($group->application_names as $application_name) { echo $application_name . '<br/>'; } ?></td>
												<td class="center">
													<?php echo get_instance()->load->view('api/administration/manage_groups/_group_actions', compact('group', 'status'), TRUE); ?>
												</td>
											</tr>
										<?php endforeach ?>
									</tbody>
								</table>