<?php
/**
* @package direct-as-a-service
* @subpackage views
 * @filesource
*/ /** */

//expects $status -> 'active' or 'disabled'

$action = ($status == 'active') ? 'disable' : 'enable';
$class = ($status == 'active') ? 'active' : 'inactive';


$ldap_info = array( 'cn' => 'Name',
					'title' => 'Title',
					'departmentnumber' => 'Department',
					'o' => 'Organization',
					'physicaldeliveryofficename' => 'Location',
					'telephonenumber' => 'Telephone',
					'mobile' => 'Mobile',
					'user_ext_mail' => 'Email');
	  
?>
<p>This table lists the <?php echo $status ?> accounts on the system.</p>
	<br/>
	<table id="<?php echo $status ?>_account_table" class="display">
	<caption class="hidden_context"><?php echo ucfirst($status) ?> Accounts</caption>
	<thead>
		<tr class="gridheader">
			<th scope="col">User Name</th>
			<th scope="col">ID</th>
			<th scope="col">Details</th>
			<th scope="col">Access</th>
			<th class="displaylast">Actions</th>
		</tr>
	</thead>
	<tbody>
		<?PHP foreach($users as $user): ?>
			<tr>
				<td class="center"><a href="/administration/manage/accounts/edit/<?PHP echo $user->user_id; ?>"><?PHP echo $user->username; ?></a></td>
				<td class="center"><?PHP echo $user->user_org_id; ?></td>
				<td class="center">
					<?php echo $this->load->view('api/administration/manage_accounts/_account_details', compact('user', 'status'), TRUE); ?>
				</td>
				<td><?PHP foreach($user->applications as $application) { echo $application . '<br/>'; } ?></td>
				<td class="center">
					<?php echo $this->load->view('api/administration/manage_accounts/_account_actions', compact('user', 'status', 'action_permission', 'account_permission'), TRUE); ?>
				</td>
			</tr>
		<?PHP endforeach ?>
	</tbody>
	</table>