<?php
/**
* @package direct-as-a-service
* @subpackage views
* @filesource
*/ /** */

	if(!$admin_show['account_requests']) { show_error('Forbidden',403); }
	$this->load->view('api/header'); 
	$this->load->view('api/nav');
	$count = 0;
?>			 
				<div class="breadcrumb-header-block">
					<h1>Administration</h1><span class="seperator">&#9658;</span><h2>Account Requests</h2>
				</div>
				<script type="text/javascript" src="/js/adminmenu.js"></script>
				<div class="column">
					<?PHP if(isset($message)) { echo '<div id="message_info" class="message_info">'.$message.'</div>'; } ?>
					<?PHP if(isset($success_message)) { echo '<div id="message_success" class="message_success">'.$success_message.'</div>'; } ?>
					<?PHP if(isset($error_message)) { echo '<div id="message_error" class="message_error">'.$error_message.'</div>'; } ?>
					<script>
						$(function() {
							$("#tabs").tabs();
							$("#pending_link").removeAttr("tabindex");
							$("#approved_link").removeAttr("tabindex");
							$("#denied_link").removeAttr("tabindex");
							$("[id^=dialog-form]").dialog({
								autoOpen: false,
								width: 600,
								height: 300,
								modal: true,
								buttons: {
									Submit: function(){
										var id = $(this).attr('id').replace('dialog-form','');
										$('#denyAccountForm'+id).submit();
									},
									Cancel: function(){
										$(this).dialog("close");
									}
								}
							});
							$("[id^=deny-account]").click(function(e) {
								var id = 0;
								if($(e.target).attr('id')){
									id = $(e.target).attr('id').replace('deny-account',''); 
								}
								else{
									id = $(e.target).parent().attr('id').replace('deny-account',''); //get parent id since click is on image
								}
								$("#dialog-form"+id).dialog("open");
							});
						});
					</script>
					<div id="tabs" class="column">
						<ul>
							<a class="hidden_context hidden_link" id="skip_nav" href="#nav_tab_holder" style="font-weight: normal;">Skip Navigation</a>
							<li><a id="pending_link" href="#pending" onclick="javascript:clearMessage('message_info');clearMessage('message_error');clearMessage('message_success');">Pending Approval</a></li>
							<li><a id="approved_link" href="#approved" onclick="javascript:clearMessage('message_info');clearMessage('message_error');clearMessage('message_success');">Approved</a></li>
							<li><a id="denied_link" href="#denied" onclick="javascript:clearMessage('message_info');clearMessage('message_error');clearMessage('message_success');">Denied</a></li>
							<div name="nav_tab_holder" id="nav_tab_holder" class="hidden_context hidden_link" > </div>
						</ul>
						<?PHP 
							$request_lists = array('pending'=>$pending_list,'approved'=>$approved_list,'denied'=>$denied_list);
							foreach($request_lists as $id => $cur_request_list) {
						?>
						<div id="<?PHP echo $id; ?>">
							<?PHP if($id === 'pending') { ?>
								<p>This table lists account requests that are awaiting approval for access to the API services.</p>
							<?PHP } ?>
							<?PHP if($id === 'approved') { ?>
								<p>This table lists the account requests that have been approved for access to the API services.</p>
							<?PHP } ?>
							<?PHP if($id === 'denied') { ?>
								<p>This table lists the account requests that have been denied access to the API services.</p>
							<?PHP } ?>
							<br/>
							<table id="<?php echo $id;?>_table" class="display">
								<caption class="hidden_context"><?php echo ucfirst($id); ?> Acount Requests</caption>
								<thead>
									<tr class="gridheader">
										<th scope="col">User</th>
										<th scope="col">Contact</th>											
										<th scope="col">Requested Date</th>
										<?PHP if($id === 'pending') { ?><th class="displaylast">Actions</th> <?PHP } ?>
										<?PHP if($id === 'approved') { ?><th class="displaylast">Approved Date</th> <?PHP } ?>
										<?PHP if($id === 'denied') { ?><th class="displaylast">Justification</th> <?PHP } ?>
									</tr>
								</thead>
								<?php foreach($cur_request_list as $request) { ?>
									<tr id="<?php echo $request->id; ?>row">
										<td>
											<?php 
												if($request->middle_name) { echo $request->first_name.' '.$request->middle_name.' '.$request->last_name; }
												else { echo $request->first_name.' '.$request->last_name; }
												if($request->title) { echo '<br />'.$request->title; }
												if($request->department) { echo '<br />'. $request->department; }
												if($request->organization) { echo '<br />'. $request->organization; }
												if($request->user_org_id) { echo '<br />ID: '. $request->user_org_id; }
											?>
										</td>
										<td>
											<?php 
												if($request->ext_mail) { echo '<a href="mailto:"'.$request->ext_mail.'>'.$request->ext_mail.'</a>'; } 
												if($request->telephone) { echo '<br />Phone: '.$request->telephone; }
												if($request->mobile) { echo '<br />Mobile: '.$request->mobile; }
												if($request->location) { echo '<br />'. $request->location; }
											?>
										</td>
										<td><?php echo date("M d Y H:i:s",$request->request_date); ?>&nbsp;</td>
										<td>
											<?PHP if($id === 'pending') { ?>
											<?PHP
												echo form_open('/administration/approve_account_request',array('id'=>'approveAccountForm'.$request->id,'class'=>'approveAccountForm'));
												$hidden_inputs = array(
													'request_id' => $request->id,
													'pending_page_select_from_approve_button' => $pending_cur_page,
													'pending_items_per_page_from_approve_button' => $pending_items_per_page ?: ITEMS_PER_PAGE_DEFAULT,
													'approved_page_select_from_approve_button' => $approved_cur_page,
													'approved_items_per_page_from_approve_button' => $approved_items_per_page ?: ITEMS_PER_PAGE_DEFAULT,
													'denied_page_select_from_approve_button' => $denied_cur_page,
													'denied_items_per_page_from_approve_button' => $denied_items_per_page ?: ITEMS_PER_PAGE_DEFAULT,
												);
												echo form_hidden($hidden_inputs,TRUE);
												echo form_close(); 
											?>
											
											<div id="dialog-form<?php echo $request->id; ?>" title="Reason for Denial">
											<?PHP
												echo form_open('/administration/deny_account_request',array('id'=>'denyAccountForm'.$request->id,'class'=>'denyAccountForm'));
												$hidden_inputs = array(
													'request_id' => $request->id,
													'pending_page_select_from_deny_button' => $pending_cur_page,
													'pending_items_per_page_from_deny_button' => $pending_items_per_page ?: ITEMS_PER_PAGE_DEFAULT,
													'approved_page_select_from_deny_button' => $approved_cur_page,
													'approved_items_per_page_from_deny_button' => $approved_items_per_page ?: ITEMS_PER_PAGE_DEFAULT,
													'denied_page_select_from_deny_button' => $denied_cur_page,
													'denied_items_per_page_from_deny_button' => $denied_items_per_page ?: ITEMS_PER_PAGE_DEFAULT,
												);
												echo form_hidden($hidden_inputs,TRUE);
												echo form_label('Reason for Denial:','denial_reason'.$request->id);
												echo form_textarea('reason','','id="denial_reason'.$request->id.'" class="modal"');
												echo form_close();
											?>

											</div>
											<div class="center">
												<a href="#" onclick="if ( confirm('Are you sure you want to approve the account for <?php echo $request->last_name.", ".$request->first_name; ?>?')){ this.parentNode.getElementsByTagName('a')[1].outerHTML = this.parentNode.getElementsByTagName('a')[1].innerHTML; this.outerHTML = this.innerHTML; $('#approveAccountForm<?php echo $request->id ?>').submit();}" title="Approve Request: <?php echo $request->first_name .' '.$request->last_name; ?>"><img src="/images/icons/accept.png" alt="Approve Request:  <?php echo $request->first_name .' '.$request->last_name; ?>" /></a>
												<a href="#" id="deny-account<?php echo $request->id; ?>" title="Deny Request: <?php echo $request->first_name .' '.$request->last_name; ?>"><img src="/images/icons/cancel.png" alt="Deny Request: <?php echo $request->first_name .' '.$request->last_name; ?>" /></a>
											</div>
											<?PHP } ?>
											<?PHP if($id === 'approved') {  echo date("M d Y H:i:s",$request->approved_date); } ?>
											<?PHP if($id === 'denied') { echo $request->justification; } ?>
										</td>
									</tr>
								<?php $count++; } ?>
							</table>
						</div>
						<?PHP } ?>
					</div>
				</div>
			</div>
			<?PHP $this->load->view('api/footer'); ?>
		</div>
	</body>
</html>

<script type='text/javascript'>
	goToSubTab(<?PHP if(isset($anchor)){echo get_instance()->json->encode($anchor);} ?>);
	assignPaginationFormValues(<?PHP echo get_instance()->json->encode($form_values); ?>);

	$(document).ready(function() {
		$('#approved_table').dataTable( {
			"fnDrawCallback": function(oSettings) {
				if (oSettings._iDisplayLength + 1> oSettings.fnRecordsDisplay()) {
					$(oSettings.nTableWrapper).find('.paginate_button').hide();
					$(oSettings.nTableWrapper).find('.paginate_button').hide();
				}
			},
			"sDom" : '<"top_info"i><"top_paginate"p><"top_length"l><"H"fr>t<"bottom_info"i><"bottom_paginate"p><"bottom_length"l>',
			"bSort" : false,
	    	"bProcessing": true,
	        "bServerSide": true,
	        "bStateSave": true,
	         
          	"aoColumnDefs": [{ 'bSortable': false, 'aTargets': [0,1,2,3]},
        		             { 'bSearchable': false, 'aTargets': [3]},
        		             { "sClass": "center break-word", 'aTargets': [0,1,2,3]}],
	        "sAjaxSource": '/administration/approved_account_request_search/?active=true&'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val(), 
	        "oLanguage": {
	        	"sSearch": "Find Account: ",
	        	"sEmptyTable": "No accounts were found",
	        	"sZeroRecords": "No accounts were found"
	        	},  
	    } );
	} ); 

	$(document).ready(function() {
		$('#pending_table').dataTable({
			"fnDrawCallback": function(oSettings) {
				if (oSettings._iDisplayLength > oSettings.fnRecordsDisplay()) {
					$(oSettings.nTableWrapper).find('.paginate_button').hide();
					$(oSettings.nTableWrapper).find('.paginate_button').hide();
				}
			},
			"sDom" : '<"top_info"i><"top_paginate"p><"top_length"l><"H"fr>t<"bottom_info"i><"bottom_paginate"p><"bottom_length"l>',
			"bSort" : false,
			"aoColumnDefs": [{ 'bSortable': false, 'aTargets': [0,1,2,3]},
			                 { "sClass": "center", 'aTargets': [0,1,2,3]}],
			"oLanguage": {
				 "sSearch": "Find Account: ",
				 "sEmptyTable":    "No accounts were found",
				 "sZeroRecords":   "No accounts were found",
			}
		});
	});
	
	$(document).ready(function() {
		$('#denied_table').dataTable({
			"fnDrawCallback": function(oSettings) {
				if (oSettings._iDisplayLength > oSettings.fnRecordsDisplay()) {
					$(oSettings.nTableWrapper).find('.paginate_button').hide();
					$(oSettings.nTableWrapper).find('.paginate_button').hide();
				}
			},
			"sDom" : '<"top_info"i><"top_paginate"p><"top_length"l><"H"fr>t<"bottom_info"i><"bottom_paginate"p><"bottom_length"l>',
			"bSort" : false,
			"aoColumnDefs": [{ 'bSortable': false, 'aTargets': [0,1,2,3]},
			                 { "sClass": "center", 'aTargets': [0,1,2,3]}],
			//set search box text
			"oLanguage": {
				"sSearch": "Find Account: ",
				"sEmptyTable":    "No accounts were found",
				"sZeroRecords":   "No accounts were found",
			}
		});
	});
</script>