 <?PHP if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage models
*/

/**
* @package direct-as-a-service
* @subpackage models
*/
class UserActivitySummaryModel extends CI_Model {

	public function count($conditions = array()){
		$this->_set_up_activity_summary_join();
		if(!empty($conditions)) $this->db->where($conditions);
		return count($this->db->select('COUNT(*) count')->get()->result());
	}  
	
	public function get($conditions = array()){
		$this->_set_up_select();
		$this->_set_up_activity_summary_join();
		if(!empty($conditions)) $this->db->where($conditions);	
		return $this->db->get();
	} 

	//get response when no filters for first page
	function get_first_user_activities($size){
		$this->db->limit($size)->order_by('F.name','DESC');
		return $this->get();
	}

	/*
     * get the list of facilities and different orders
     */
	//get response with filters
	function get_request_filter_facility_order($sql,$order,$start,$size){
		if ($order == 'facilityName DESC,id DESC' || $order == 'facilityName DESC,id DESC'){
			$order = 'DESC';
		}
		else{
			$order = 'ASC';
		}
		$sql= str_replace("(id","(F.id",$sql);//needed because both tables have the same column name

		$this->db->limit($size,$start)->order_by($order);
		return $this->get();
	}
	
	/*
     * get the list of facilities
     */
	function get_request_filter_user_activities($sql,$sql_date_filter_excluded,$order,$start,$size){
		
		$this->order_by($order);
		$responses_list = $this->get($sql)->result();
		
		$this->order_by($order);
		$responses_list_date_filter_excluded = $this->get($sql_date_filter_excluded)->result();
				
		//include the users who had no acitivty in the time period specified
		$new_response_list = [];
		foreach($responses_list as $summary) {
			$new_response_list[$summary->Username] = $summary;
		}
		$complete_responses_list = [];
		foreach($responses_list_date_filter_excluded as $summary) {
			if(key_exists($summary->Username, $new_response_list)) {
				$complete_responses_list[$summary->Username] = $new_response_list[$summary->Username];
			}
			else {
				$summary->Number_of_sent = 0;
				$summary->Number_of_seen = 0;
				$summary->Total_messages = 0;
				$complete_responses_list[$summary->Username] = $summary;
			}
		}
		return $complete_responses_list;		
	}

	function get_ldap_request($userName)//get response when no filters for first page
	{
		$ldap_conn = $this->prepare_ldap_conn();
		$ldap_bind = ldap_bind($ldap_conn, LDAP_ANON_SEARCH_USERNAME, LDAP_ANON_SEARCH_PASSWORD);
		if($ldap_bind) {
			$base_dn = LDAP_ACCOUNT_GROUP;
			$fields = array('uid','givenname','sn','mail','uidnumber','homedirectory');
			$search = @ldap_search($ldap_conn, $base_dn, '(&(uid='.$userName.'))', $fields);
			
			if($search){ $entries = ldap_get_entries($ldap_conn, $search); }
			else{ $entries = array('count' => 0); }
	
			return $entries;
		}
	}
 	
	/* -----------------------------*
	 *  PROTECTED FUNCTIONS           *
	 * -----------------------------*/
	 
	protected function _set_up_activity_summary_join(){
		$this->db->from("mail.dbo.mailboxes M");
		$this->db->join('api.dbo.facility F', 'F.id = M.facility_id', 'left outer');
		$this->db->join('mail.dbo.messages MS', 'MS.mailbox_id = M.id', 'left');
		$this->db->join('api.dbo.users U', 'U.username = M.name', 'left');
		$this->db->where('M.is_group != 1');
		$this->db->where('(MS.draft = 0 OR MS.draft IS NULL)');
		$this->db->group_by(array('M.name', 'F.name', 'F.id', 'M.is_active', 'U.user_ext_mail'));	
	}	 
	
	protected function _set_up_select(){
		$this->db->select('F.id, F.Name, M.name as Username, U.user_ext_mail, M.is_active');
		$this->db->select("ISNULL(COUNT(DISTINCT M.id), CONVERT(bigint,'0')) AS Number_of_users");
		$this->db->select("ISNULL(sum(MS.sent), CONVERT(bigint,'0') ) AS Number_of_sent");
		$this->db->select("ISNULL(sum(MS.seen), CONVERT(bigint,'0')) AS Number_of_seen");
		$this->db->select('COUNT(MS.id) as Total_messages');		
	}	

	protected function order_by($order){
		
		if(empty($order)) return;
		
		//Name
		if ($order == 'facilityName DESC,id DESC'  || $order == 'facilityName DESC,id DESC' ){
			$order = '(ORDER BY F.name DESC';
		}
		if ($order == 'facilityName ASC,id ASC'  || $order == 'facilityName ASC,id ASC' ){
			$order = '(ORDER BY F.name ASC';
		}
		//Seen
		if ($order == 'userNumber_of_seen DESC,id DESC' ){
			$order = '(ORDER BY sum(MS.seen) DESC';
		}
		if ($order == 'userNumber_of_seen ASC,id ASC' ){
			$order = '(ORDER BY sum(MS.seen) ASC';
		}
		//emailaddress
		if ($order == 'user_ext_mail DESC,id DESC' ){
			$order = '(ORDER BY U.user_ext_mail DESC';
		}
		if ($order == 'user_ext_mail ASC,id ASC' ){
			$order = '(ORDER BY U.user_ext_mail ASC';
		}
		//Sent
		if ($order == 'userNumber_of_sent DESC,id DESC' ){
			$order = '(ORDER BY sum(MS.sent) DESC';
		}
		if ($order == 'userNumber_of_sent ASC,id ASC' ){
			$order = '(ORDER BY sum(MS.sent) ASC';
		}
		//Total
		if ($order == 'userTotal_of_messages DESC,id DESC' ){
			$order = '(ORDER BY sum(MS.id) DESC';
		}
		if ($order == 'userTotal_of_messages ASC,id ASC' ){
			$order = '(ORDER BY sum(MS.id) ASC';
		}
		//LDAP Ordering
		
		if ($order == 'userSN DESC,id DESC' OR $order == 'userSN ASC,id ASC' ){
			$order = '(ORDER BY F.name ASC';
		}
		
		if ($order == 'userGivenname DESC,id DESC' OR $order == 'userGivenname ASC,id ASC' ){
			$order = '(ORDER BY F.name ASC';
		}
		
		if ($order == 'username DESC,id DESC' OR $order == 'username ASC,id ASC' ){
			$order = '(ORDER BY F.name ASC';
		}
		
		if ($order == 'userMail DESC,id DESC' OR $order == 'userMail ASC,id ASC' ){
			$order = '(ORDER BY F.name ASC';
		}
		
		if ($order == 'userStatus DESC,id DESC' OR $order == 'userStatus ASC,id ASC' ){
			$order = '(ORDER BY F.name ASC';
		}
		if ($order == 'emailaddress DESC,id DESC' OR $order == 'emailaddress ASC,id ASC' ){
			$order = '(ORDER BY F.name ASC';
		}
		$order= str_replace("(ORDER BY","",$order);//needed because both tables have the same column nam
		
		$this->db->order_by($order);	
	}			
	 
	/* This function prepares a connection to LDAP using the configured constants for the facility
	  * and the LDAP options required for the connection. Returns FALSE on failure, LDAP connection resource
	  * on success.
	  */
	 protected function prepare_ldap_conn() {
		$ldap_conn = ldap_connect(LDAP_HOSTNAME, LDAP_PORT);
		if(!ldap_set_option($ldap_conn, LDAP_OPT_PROTOCOL_VERSION, 3)) { return FALSE; } 
		if(!ldap_set_option($ldap_conn, LDAP_OPT_REFERRALS, 0)) { return FALSE; }
		return $ldap_conn;
	}
}
