<?php 
/**
 * This file is for any functions that will be used only by the hook system.
 * 
 * @see http://codeigniter.com/user_guide/general/hooks.html
 * @author M. Gibbs <gibbs_margaret@bah.com>
 * @package direct-as-a-service
 * @subpackage hooks
 */

/**
* Runs any system-wide code based on the constants file.
* For example, the timezone needs to be set to the default timezone for this instance of Direct.
*/
function set_system_defaults(){
	date_default_timezone_set(ENVIRONMENT_TIMEZONE); //this instance of Direct will be configured with a default timezone, we want it set as early as possible
}



/**
* Actions which should take place after the instantiation of *all* the controllers.
*/
function post_controller_constructor(){
	get_instance()->load->library('Validator', array(), 'is');	
}


/* End of file hook_functions.php */
/* Location: ./application/hooks/hook_functions.php */
