<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage helpers
*//** */

/**
* Converts a Bootstrap grid column class to the equivalent offset column class
* For example, col-xs-3 becomes col-xs-offset-3.
* @param string
* @return string
*/
function grid_offset_for_width($width_class){
	if(!is_string($width_class) || empty($width_class)) return should_be('nonempty_string', $width_class);
	$classes = explode(' ', $width_class); //might have more than one class for diferent responsive poitns.
	foreach($classes as $key => $class){
		$last_dash = strrpos($class, '-');
		$classes[$key] = substr($class, 0, $last_dash).'-offset'.substr($class, $last_dash);
	}
	return implode(' ', $classes);
}

function link_to_as_button($path, $link_text, $attributes = array()){
	$attributes = merge_attributes(array('class' => 'btn btn-default btn-sm'), $attributes);
	return link_to($path, $link_text, $attributes);
}

?>