<?php defined('BASEPATH') OR exit('No direct script access allowed');
/**
* @package direct-as-a-service
* @subpackage controllers
*//** */
 
require_once APPPATH.'libraries/DaaS_REST_Controller.php';

/**
* @package direct-as-a-service
* @subpackage controllers
*/
class Mailbox_controller extends DaaS_REST_Controller{	

	var $mailbox;
	
	/**
	* Everything that applies to all actions should go here.
	*/
	function __construct(){
		parent::__construct();		
				
		$http_verb = $this->_detect_method();
		
		//SET UP THE MAILBOX	
		//determine the mailbox - setting this as a class variable will make it available throughout the application, which is going to help the models
		$methods_that_find_mailbox_by_sender = array( 'save_post', 'send_draft_post', 'send_post'  ); //save draft will go here as well
		if(in_array($this->router_method, $methods_that_find_mailbox_by_sender)){
			$mailbox_identifier = 'sender';
			if(array_key_exists( $mailbox_identifier, $this->$http_verb()))			
				$mailbox = Mailbox::find_by_email_address($this->$http_verb($mailbox_identifier));
		}	
		else{
			$mailbox_identifier = 'mailbox';
			$name = $this->$http_verb($mailbox_identifier);
			if(!empty($name) && is_string($name))
				$mailbox = Mailbox::find_one(compact('name'));
		}
		
		//verify that a valid mailbox was provided & set $this->mailbox
		if(!array_key_exists($mailbox_identifier, $this->$http_verb()))
			$this->missing_required_fields[] = $mailbox_identifier;
		elseif(!isset($mailbox) || !Mailbox::is_an_entity($mailbox))
			$this->invalid_fields[] = $mailbox_identifier;
		else{
			$this->mailbox = $mailbox;
			$this->response_message['mailbox'] = $this->mailbox->name;			
		}
		
		$this->respond_with_error_if_fields_are_missing();

		//most of the time, these services require that the user be active and have access to the specified mailbox, but we have a few exceptions
		if(!in_array($this->router_method, array('update_account_post', 'account_get', 'accounts_in_facility_get', 'update_group_post'))){
			$this->respond_with_error_if_mailbox_is_inactive();
			$this->respond_with_error_if_user_does_not_have_access_to_this_mailbox();
		}
	}
	
	//this is a perfectly normal length for a method name, I don't know what you're talking about
	protected function respond_with_error_if_user_does_not_have_access_to_this_mailbox(){
		
		//if the mailbox is a personal mailbox, we just need to make sure that the owning user is active
		if(!$this->mailbox->is_group){
			if(!$this->mailbox->user->is_active()) 
				return $this->response('The user account for this mailbox is not active.', 403);
			return true;
		}
		
		$http_verb = $this->_detect_method();
		
		//if this is a group mailbox AND the parameters specified a user, make sure that user has access to the account
		//note that this is a potential flaw - we may want to consider making the user parameter required		
		$username = $this->$http_verb('orginal_sender');  //old message code uses original_sender to denote the actual logged-in user
		if(empty($username)) 
			$username = $this->$http_verb('user');
		
		if(!empty($username)){
			$user = User::find_one(array('username' => $username));
			if(User::is_an_entity($user) && $user->has_access_to_mailbox($this->mailbox))
				return $this->response('The specified user does not have access to this mailbox.', 403);
		}
	}
	

	protected function valid_locations(){
		return array('inbox', 'draft', 'archived', 'sent','all');
	}

}
?>
