<?php defined('BASEPATH') OR exit('No direct script access allowed');
/**
* @package direct-as-a-service
* @subpackage controllers
*//** */
 
require_once APPPATH.'controllers/services/mailbox_controller.php';

/**
* @author M. Gibbs <gibbs_margaret@bah.com>
*
* @package direct-as-a-service
* @subpackage controllers
*/
class File_transfer_controller extends Mailbox_controller{	
	
	/**
	* Everything that applies to all actions should go here.
	*/
	function __construct(){
		parent::__construct();
		$this->respond_with_error_if_fields_are_missing();  //make sure that we get an error right away if the mailbox is missing
		$this->respond_with_error_if_fields_are_invalid();
		
		
		require_model('file_transfer');
	}		
		
	public function create_post(){
		ini_set('memory_limit', '1024M'); 
		ini_set('max_execution_time', '1200');
		
//todo - should we be using 'user' instead of 'created_by'?  Kind of don't want to do that until 'user' corresponds to id instead of username	
		
		$required_fields = array('name', 'type', 'message_id', 'created_by');
		foreach($required_fields as $required_field){
			if(array_key_exists($required_field, $_POST))
				$$required_field = $this->post($required_field);
			else
				$this->missing_required_fields[] = $required_field;
		}
		
		$this->respond_with_error_if_fields_are_missing();
		$this->respond_with_error_if_user_is_unauthorized('send');
		$this->respond_with_error_if_mailbox_is_inactive();
		
		$file = &$_FILES[array_first_key($_FILES)];
		if(empty($_FILES) || $file['name'] !== $name)
			$this->response('No file content found for '.$name, 422);
			
//		log_message('error', sprp_for_log(array_keys($file), 'data sent for '.$file['name']));
		
		
		$file_transfer = new File_transfer(array('message_id' => $this->input->post('message_id')));
		foreach($required_fields as $field){
	
			if($file_transfer->property_has_validation($field) && !$file_transfer->value_is_valid_for_property($field, $$field)){
				$this->invalid_fields[] = $field;
				continue;
			}
			
			//validation check above only validates fields that have a rule assigned - misses any more complicated validation taking place in the setter
			$file_transfer->$field = $_POST[$field];
			if($file_transfer->$field != $_POST[$field]){
				$this->invalid_fields[] = $field;
				continue;
			}
		}
		
		$user = User::find_one($created_by);
		if(!User::is_an_entity($user) || !$user->is_active() || !$user->has_access_to_mailbox($this->mailbox))
			$this->invalid_fields[] = 'created_by';
		
		$message = Message::find_one($message_id);
		if(!Message::is_an_entity($message) || !$message->belongs_to_mailbox($this->mailbox)) 
			$this->invalid_fields[] = 'message_id';
		
//todo - allow recipient to be null, populate when we're sending the message
		if($message->has_recipients())
			$file_transfer->recipient = first_element($this->json->decode($message->recipients));		
				

		$this->respond_with_error_if_fields_are_invalid();	
		
		//todo - check size
		
	
		//determine the binary data for this file
		if(array_key_exists('binary', $file)){
			$this->load->library('session');
			$file_transfer->content_filepath = $this->session->add_file_to_cache('mailbox_'.$this->mailbox->name.'_'.now().'/'.$file['name'], $file['binary']);
			session_write_close();
		}elseif(!$file['error'] && file_exists($this->session->cache_root('files/'.basename($file['tmp_name'])))){
			$file_transfer->content_filepath = $file['tmp_name'];
		}
		
		if(!$file_transfer->save())
			$this->response('An unknown error occurred and the file transfer could not be created.', 400);
		
		//201 responses are supposed to include a URI for the new resource, which doesn't quite work for us (we can give a URI, but not an api-friendly one).  Stick to 200 for now.
		$this->response(array('id' => $file_transfer->id, 'file_transfer' => $file_transfer->values(array('id', 'name', 'type', 'size', 'hash', 'message_id', 'recipient', 'expires_at'))), 200);
	}
	
	public function delete_delete(){
		$required_fields = array('id', 'user');
		foreach($required_fields as $required_field){
			if(array_key_exists($required_field, $this->delete()))
				$$required_field = $this->delete($required_field, TRUE);
			else
				$this->missing_required_fields[] = $required_field;
		}
		
		$this->respond_with_error_if_fields_are_missing();
		$this->respond_with_error_if_user_is_unauthorized('send');
		$this->respond_with_error_if_mailbox_is_inactive();
		
		//check to make sure that the file transfer exists, belongs to this mailbox, and has not already been sent
		$file_transfer = File_transfer::find_one($id);
		if(!File_transfer::is_an_entity($file_transfer))
			$this->invalid_fields[] = 'id';
		else{
			$message = $file_transfer->message;
			if($message->mailbox->id != $this->mailbox->id){
				$this->invalid_fields[] = 'id';
			}
		}
		
		$this->respond_with_error_if_fields_are_invalid();	
			
		if(!$message->draft) 
			$this->response('File transfer #'.$id.' could not be deleted because it has already been sent to the recipient. '.$message->describe().' Message is draft? '.$this->error->describe($message->draft), 422);
			
		if($file_transfer->has_expired())
			$this->response('File transfer #'.$id.' could not be deleted because it expired on '.unix_to_human($file_transfer->expires_at), 422);
		
		if(File_transfer::delete($file_transfer->id))
			$this->response('File transfer #'.$id.' has been deleted', 200);
			
		$this->response('An unexpected error occurred and file transfer #'.$id.' could not be deleted.', 400);
	}

		
}
?>