<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * @package direct-as-a-service
 * @subpackage controllers
 *//** */

require_once APPPATH.'controllers/admin/Reports.php';

class Request_report_controller extends Reports{

    public function index($adhoc_report_id = null){

        //print indicator from adhoc report page print link
        $adhoc_print_page = $this->input->post('adhoc_print_page', TRUE);
        $data = array(
            'title' => 'Direct API: Reports',
            'active_tab' => array('reports' => true),
            'timezone_abbr' => $this->locale->timezone_abbr_from_name(date_default_timezone_get()),
            'tabs' => $this->create_tabs('requests_report'),
            'report_name' => 'requests',
            'show' => $this->show,
            'time' => date('m/d/Y h:i:s A', time()),
            'user' => $this->session->userdata('user_info')['first_name'] . ' ' . $this->session->userdata('user_info')['last_name'],
        );
        //get user id from session to get permissions
        $permissions = $this->account_permissions;
        $selected = null;
        $responses_list = $response_export_list = array();
        //show forbidden if the user does not have permission to be here
        if (!$data['show']['reports']) {
            show_error('Forbidden', 403);
        }
        //gets selected application
        $app_select = $this->input->post('whichapp', TRUE);
        $export_file_name = $this->input->post('export_file_name', TRUE);
        //if $adhoc_report_id is not empty, do adhoc report
        if ($adhoc_report_id != '') {
            //Security Check
            $result_security = $this->adhoc_report_security_check($adhoc_report_id);
            if ($result_security == FALSE) {
                //Load Error Page
                show_404();
                return;
            }
            $adhoc_report = $this->adhocreportsmodel->get_adhoc_report_by_id($adhoc_report_id, "requests")->result();
            //Diff time period
            if (!isset($adhoc_report[0])) {
                show_404();
            }
            $diff_time_period = $this->input->post('time_period', TRUE);
            $time_period_field = $adhoc_report[0]->report_time_field;

            $selected_filter_array = $this->adhocreportsmodel->get_selected_filter_array_from_db($adhoc_report[0]->report_selector);
            $time_start_check = $selected_filter_array['start_date'];
            $time_end_check = $selected_filter_array['end_date'];

            //Display Information
            $form_data['report_created_time'] = $adhoc_report[0]->report_created_time;
            $form_data['report_name'] = $adhoc_report[0]->report_name;
            $form_data['report_description'] = $adhoc_report[0]->report_description;
            $form_data['report_created_by'] = $adhoc_report[0]->username;
            $form_data['adhoc_report_id'] = $adhoc_report_id;

            if ($diff_time_period != '') {
                //Calculate_new_dates
                $diff_period_start = $this->return_different_start_date($diff_time_period);
                $diff_period_end = $this->return_different_end_date($diff_time_period);
                $sql_query_generator = $adhoc_report[0]->report_query_generator;

                //Create new Query based on the different time selected
                $sql = $this->create_different_time_period_query($sql_query_generator, $time_start_check, $time_end_check, $time_period_field, $diff_period_start, $diff_period_end);

                //Date information
                $start_date = date('m/d/Y h:i:s A', $diff_period_start);
                $end_date = date('m/d/Y h:i:s A', $diff_period_end);
            } else {
                //calls helper to get data
                $sql = $adhoc_report[0]->report_query_generator;

                //Date information
                $end_date = $selected_filter_array['end_date'];
                $start_date = $selected_filter_array['start_date'];
            }
            //Selector
            $selector = array(
                'application_id' => ($selected_filter_array['whichapp']),
            );
            $items = array(
                'id' => $this->search_type($selected_filter_array['request_id'], $selected_filter_array['request_id_type']),
                'call' => $this->search_type($selected_filter_array['request_call'], $selected_filter_array['request_call_type']),
                'response_code' => $this->search_type($selected_filter_array['request_code'], $selected_filter_array['request_code_type']),
                'response' => $this->search_type($selected_filter_array['request_response'], $selected_filter_array['request_response_type']),
            );
            //Date Format
            //$date_array = array($end_date, $start_date);
            $date_warning_message = $this->get_paired_dates_filter_validation_message($start_date, $end_date);

            //Setting exports
            $export = $this->input->post('export', TRUE);
            $export_pdf = $this->input->post('export_pdf', TRUE);
            $print_page = $this->input->post('print_page', TRUE);
            $is_export = FALSE;
            /* if($export || $export_pdf || $print_page == 1) {
                $is_export = true;
            } */
            if ($export) {
                $is_export = 'excel';
            } else if ($export_pdf) {
                $is_export = 'pdf';
            } else if ($print_page == 1) {
                $is_export = 'print';
            }
            $data['is_export'] = $is_export;

            $between = array(
                'call_date' => $this->check_paired_dates($start_date, $end_date),
            );


            //get direction (desc/asc)and if it is being exported
            $order = $adhoc_report[0]->report_order_by;
            $dir = $adhoc_report[0]->report_order_by_direction;

            //getting size number
            $size = Request::count_for_reports($sql);
            $this->destination_page = $selected_filter_array['adhoc_report_destination_page'];
            $this->items_per_page = $selected_filter_array['adhoc_report_items_per_page'];
            $this->pages->items_per_page = $this->items_per_page;
            $start = (($this->destination_page - 1) * $this->items_per_page) + 1;
            if (string_contains('id', $order)) {
                $order = preg_replace('/[^a-zA-Z0-9_\.]id[^a-zA-Z0-9_-]/', 'request.id', str_replace('application_id', 'application.name', $order));
            }
            Request::db()->order_by($order)->limit($this->items_per_page, $start - 1);
            $responses_list = Request::find_for_reports($sql);


            //Adhoc_Report
            $response_adhoc_sql = $this->reports_helper_adhoc('request', $items, $between, $selector, array(), $order, $dir, $this->destination_page, $export, $this->items_per_page);

            //ExportPDF-PRINT
            if ($is_export) {
                $response_export = $this->reports_helper('request', $items, $between, $selector, array(), $order, $dir, $this->destination_page, $export, $this->items_per_page);
                $response_export_list = $response_export['response'];
                $data['filters'] = $this->export_info($items, $between, $selected, null);
            }
            //set form data
            $form_data['end_date'] = $this->reports_correct_out_of_bound_date($end_date);
            $form_data['start_date'] = $this->reports_correct_out_of_bound_date($start_date);
            $form_data['whichapp'] = $selected_filter_array['whichapp'];
            $form_data['request_id'] = $selected_filter_array['request_id'];
            $form_data['request_id_type'] = $selected_filter_array['request_id_type'];
            $form_data['request_call'] = $selected_filter_array['request_call'];
            $form_data['request_call_type'] = $selected_filter_array['request_call_type'];
            $form_data['request_response'] = $selected_filter_array['request_response'];
            $form_data['request_response_type'] = $selected_filter_array['request_response_type'];
            $form_data['request_code'] = $selected_filter_array['request_code'];
            $form_data['request_code_type'] = $selected_filter_array['request_code_type'];
            $form_data['direction'] = $dir;
            $form_data['order'] = $order;
            $form_data['cur_page'] = $this->destination_page;
            $form_data['date_warning_message'] = $date_warning_message;

            //gets image for asc or desc
            if ($form_data['direction'] == 'DESC') {
                $data['image'] = '<img src="/images/arrow_down.png" style="border : 0;  width:15px;" alt="Descending"/>';
            } else {
                $data['image'] = "<img src='/images/arrow_up.png' style='border : 0;  width:15px;' alt='Ascending'/>";
            }
            $data['form_data'] = $form_data;
        } //checks to see if there is an application selected.  This shows whether or not this is the first time the page has loaded.
        else if ($app_select) {
            //adds each component type into its own json
            $selector = array(
                'application_id' => ($app_select),
            );

            $items = array(
                'id' => $this->search_type($this->input->post('request_id', TRUE), $this->input->post('request_id_type', TRUE)),
                'call' => $this->search_type($this->input->post('request_call', TRUE), $this->input->post('request_call_type', TRUE)),
                'response_code' => $this->search_type($this->input->post('request_code', TRUE), $this->input->post('request_code_type', TRUE)),
                'response' => $this->search_type($this->input->post('request_response', TRUE), $this->input->post('request_response_type', TRUE)),
            );

            $end_date = $this->input->post('end_date', TRUE);
            $start_date = $this->input->post('start_date', TRUE);
            //$date_array = array($end_date, $start_date);
            $date_warning_message = $this->get_paired_dates_filter_validation_message($start_date, $end_date);

            $between = array(
                'call_date' => $this->check_paired_dates($start_date, $end_date),
            );

            //get direction (desc/asc)and if it is being exported
            $order = ($this->input->post('order', TRUE)) ? $this->input->post('order', TRUE) : 'name';
            $dir = $this->direction_check($order, $this->input->post('lastorder', TRUE), $this->input->post('direction', TRUE), $this->input->post('change', TRUE));
            $export = $this->input->post('export', TRUE);
            $export_pdf = $this->input->post('export_pdf', TRUE);
            $print_page = $this->input->post('print_page', TRUE);
            $is_export = FALSE;
            $is_export = FALSE;
            if ($export) {
                $is_export = 'excel';
            } else if ($export_pdf) {
                $is_export = 'pdf';
            } else if ($print_page == 1) {
                $is_export = 'print';
            }
            $data['is_export'] = $is_export;
						//append database table name to ambiguous column name
						if($this->input->post('order', TRUE) == 'id') {
							$column_order = 'request.id';
						} else {
							$column_order = $this->input->post('order', TRUE);
						}
						
            //calls helper to get data
            $response = $this->reports_helper('request', $items, $between, $selector, array(), $column_order, $dir, $this->destination_page, $is_export, $this->items_per_page);
            $responses_list = $response['response'];
            //Adhoc_Report
            $response_adhoc_sql = $this->reports_helper_adhoc('request', $items, $between, $selector, array(), $order, $dir, $this->destination_page, $export, $this->items_per_page);

            //set form data
            $form_data = $this->input->post(NULL, TRUE);

            $form_data['end_date'] = $this->reports_correct_out_of_bound_date($end_date);
            $form_data['start_date'] = $this->reports_correct_out_of_bound_date($start_date);

            $form_data['direction'] = $dir;
            $form_data['cur_page'] = $this->destination_page;
            $form_data['date_warning_message'] = $date_warning_message;

            $size = $response['size'];
            if (mb_strtolower($selector['application_id']) != '(all)') $selected = 'Application: ' . $this->applicationmodel->get_application_name_by_id($selector['application_id'])->result()[0]->name;

            if ($is_export == TRUE) {
                //ExportPDF-PRINT
                $response_export = $this->reports_helper('request', $items, $between, $selector, array(), $this->input->post('order', TRUE), $dir, $this->destination_page, $is_export, $size);
                $response_export_list = $response_export['response'];
                $data['filters'] = $this->export_info($items, $between, $selected, null);
            }


        } //if this is the first time you have loaded the page
        else {
            Request::db()->limit($this->items_per_page);
            $responses_list = Request::find_for_reports();

            //set defaults
            $form_data = array(
                'direction' => 'DESC',
                'order' => 'call_date',
                'cur_page' => '1',
            );
            //get number of items in log
            $size = Request::count_for_reports();
            $export = false;
            $export_pdf = FALSE;
            $print_page = FALSE;
            //Adhoc Report
            $between = array("call_date" => Array("start" => "", "end" => ""));
            $response_adhoc_sql = " id like '%' ";
            $dir = "DESC";
            $order = "call_date";
            //initiate form data for adhoc report
            $form_data['whichapp'] = '(ALL)';
            $form_data['request_id'] = '';
            $form_data['request_id_type'] = '';
            $form_data['request_call'] = '';
            $form_data['request_call_type'] = '';
            $form_data['request_response'] = '';
            $form_data['request_response_type'] = '';
            $form_data['request_code'] = '';
            $form_data['request_code_type'] = '';
            $form_data['start_date'] = '';
            $form_data['end_date'] = '';
            $data['filters'] = ' ';
            $data['is_export'] = FALSE;
        }
        //set options for comparing
        $data['compare'] = array(
            'equals' => 'Equals',
            'contains' => 'Contains',
            'starts' => 'Starts With',
            'ends' => 'Ends With'
        );

        //pagination setup
        $this->pages->items_total = $size;
        $this->pages->current_page = $this->destination_page;
        $this->pages->paginate();
        $form_data['pagination_bar'] = $this->pages->display_pages();
        $form_data['items_per_page_dropdown'] = $this->pages->display_items_per_page();

        //gets image for asc or desc
        if ($form_data['direction'] == 'DESC') {
            $data['image'] = '<img src="/images/arrow_down.png" style="border : 0;  width:15px;" alt="Descending"/>';
        } else {
            $data['image'] = '<img src="/images/arrow_up.png" style="border : 0; width:15px;" alt="Ascending"/>';
        }

        $form_data['num_pages'] = ceil($size / $this->items_per_page); //num of log pages
        $form_data['items_per_page'] = $this->items_per_page;
        $form_data['pages'] = $this->pages;
        $data['form_data'] = $form_data;
        $data['apps'] = $this->applicationmodel->get_applications()->result(); //gets all applications available
        $data['request_list'] = $responses_list;

        if ($export || $export_pdf) {
            $lists = array($responses_list, $response_export_list);
            foreach ($lists as &$list) {
                if (!empty($list)) {
                    foreach ($list as &$result) {
                        $result = $this->array_to_object($result->values_for_report());
                    }
                }
            }
        }
        //Adhoc Report
        $data['adhoc_report_between'] = $between;
        $data['adhoc_report_order'] = $dir;
        $data['adhoc_report_direction'] = $order;
        $data['adhoc_report_response'] = $response_adhoc_sql;
        $data['adhoc_report_type'] = "Requests";
        $data['adhoc_report_destination_page'] = $this->destination_page;
        $data['adhoc_report_items_per_page'] = $this->items_per_page;

        //print boolean set in adhoc report page print link
        if (isset($adhoc_print_page) && $adhoc_print_page == 'true') {
            $data['adhoc_print_page'] = true;
        }

        //if exported
        if ($export) {
            if (!empty($response_export)) {
                $responses_list = $response_export_list;
            } else {
                $responses_list = $responses_list;
            }
            //Remove Row value from export
            foreach ($responses_list as $key) {
                unset($key->row);
            }
            $this->export(array('ID', 'Application', 'Call', 'Date (' . $data['timezone_abbr'] . ')', 'Response Code', 'Response'), $responses_list, $export_file_name, $items, $between, $selected, null);
        } else if ($export_pdf) {
            if (!empty($response_export)) {
                $data['export_request_list'] = $response_export_list;
            } else {
                $data['request_list'] = $responses_list;
            }
            $html = $this->load->view('api/reports/result_tables/result_requests', $data, true);
            $this->export_pdf($export_file_name . '.pdf', $html, null, $size);
        } else if ($print_page == 1) {
            if (!empty($response_export)) {
                $data['export_request_list'] = $response_export_list;
            }
            $this->clear_cache();
            $data['print_page'] = true;
            $form_data['page_select'] = $this->destination_page;
            $this->load->view('api/reports/requests', $data);
        } //display on page
        else {
            $this->load->view('api/reports/requests', $data);
        }
    }
}