<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage controllers
*//** */

require_once APPPATH.'controllers/admin/Reports.php';

/**
* @package direct-as-a-service
* @subpackage controllers
*/
class Facility_report_controller extends Reports{

    public function index($adhoc_report_id = null){
		
        //page set up
        $all_report = FALSE;
        if($this->has_access("facility_report_all")){
            $all_report = TRUE;
            $facility_id = null;
        }else{
            $mailbox = Mailbox::find_one(array("name"=>$this->user->username));
            $facility_id = $mailbox->facility_id;
        }
        $data['all_report'] = $all_report;
        $data['facility_id'] = $facility_id;
        $selected = null;
        //print indicator from adhoc report page print link
        $adhoc_print_page = $this->input->post('adhoc_print_page',TRUE);

        $data['title'] = 'Direct API: Reports';
        $data['active_tab'] = array('reports'=>true);
        $data['timezone_abbr'] = $this->locale->timezone_abbr_from_name(date_default_timezone_get());
        $data['tabs'] = $this->create_tabs("facility_report");
        $data['time'] = date('m/d/Y h:i:s A', time());
        $data['user'] = $this->session->userdata('user_info')['first_name']. ' ' .$this->session->userdata('user_info')['last_name'];
        //get user id from session to get permissions
        $id = User::organization_id_from_session();
        $permissions = $this->account_permissions;
        $data['show'] = $this->show;

        if(!$data['show']['reports']) {
            show_error('Forbidden',403);
        }

        $is_active = null;
        //gets selected facility
        $facility_selected = $this->input->post('whichfacility',TRUE);
        if(!$all_report){
            $facility_selected = $facility_id;
        }
        $export_file_name = $this->input->post('export_file_name',TRUE);

        if($adhoc_report_id != ''){
            //Security Check
            $result_security = $this->adhoc_report_security_check($adhoc_report_id);
            if($result_security==FALSE){
                //Load Error Page
                show_404();
                return;
            }
            /*Adhoc Report Starts Here*/
            $adhoc_report = $this->adhocreportsmodel->get_adhoc_report_by_id($adhoc_report_id, "facility")->result();
            //Filters and Data from db
            if(!isset($adhoc_report[0])){
                show_404();
            }
            $report_selector = $adhoc_report[0]->report_selector;
            $filters_used = $this->adhocreportsmodel->get_selected_filter_array_from_db($report_selector);

            //Display Information
            $form_data['report_created_time']= $adhoc_report[0]->report_created_time;
            $form_data['report_name'] = $adhoc_report[0]->report_name;
            $form_data['report_description'] = $adhoc_report[0]->report_description;
            $form_data['report_created_by'] = $adhoc_report[0]->username;
            $form_data['adhoc_report_id'] = $adhoc_report_id;

            //Diff time period
            $diff_time_period =  $this->input->post('time_period',TRUE);
            $time_period_field = $adhoc_report[0]->report_time_field;

            $time_start_check = $filters_used['start_date'];
            $time_end_check = $filters_used['end_date'];

            if($diff_time_period != ''){
                //Calculate_new_dates
                $diff_period_start = $this->return_different_start_date($diff_time_period);
                $diff_period_end = $this->return_different_end_date($diff_time_period);
                $sql_query_generator_array = $adhoc_report[0]->report_query_generator;

                //Create new Query based on the different time selected
                $sql = $this->create_different_time_period_query($sql_query_generator_array,$time_start_check,$time_end_check,$time_period_field,$diff_period_start,$diff_period_end);

                //Date information
                $items = array();
                $start_date = date('m/d/Y h:i:s A',$diff_period_start);
                $end_date = date('m/d/Y h:i:s A',$diff_period_end);
            } else {
                //calls helper to get data
                $sql = $adhoc_report[0]->report_query_generator;

                //Date information
                $items = array();
                $end_date = $filters_used['end_date'];
                $start_date = $filters_used['start_date'];

            }
            //Selector
            $selector = array(
                'facility.id' => ($filters_used['facility_id']),
            );

            //Date Format
            //$date_array = array($end_date, $start_date);
            $date_warning_message = $this->get_paired_dates_filter_validation_message($start_date, $end_date);

            //Setting exports
            $export = $this->input->post('export',TRUE);
            $export_pdf = $this->input->post('export_pdf',TRUE);
            $print_page = $this->input->post('print_page',TRUE);
            $is_export = FALSE;
            if($export) {
                $is_export = 'excel';
            }
            else if($export_pdf) {
                $is_export = 'pdf';
            }
            else if($print_page == 1) {
                $is_export = 'print';
            }
            $data['is_export'] = $is_export;

            $between = array(
                'messages.timestamp' => $this->check_paired_dates($start_date,$end_date),
            );
            //get direction (desc/asc)and if it is being exported
            $order = $adhoc_report[0]->report_order_by;
            $dir = $adhoc_report[0]->report_order_by_direction;

            //getting size number
            $size = $this->facilitymodel->get_facility_list_size_reports_sql($sql)->result();
            $size = $size[0]->count;
            $page = 1;
            $items = array();
            $this->destination_page = $page;
            $this->items_per_page = 100;
            $facility_list= $this->facilitymodel->get_request_filter_facility_order($sql,$order,$this->db->escape($page),$this->db->escape($this->items_per_page))->result();
            //Adhoc_Report
            if(($filters_used['facility_id'] == '' || mb_strtoupper($filters_used['facility_id']) == '(ALL)') && empty($start_date) && empty($end_date)) {
                $response_adhoc = "(facility.id like '%' OR facility.id IS NULL)";
            }
            else {
                $response_adhoc = $this->reports_helper_adhoc('facility',$items,$between,$selector,array(),$order,$dir,$this->destination_page,$export,$this->items_per_page);
            }
            //ExportPDF-PRINT
            if($is_export) {
                $response_export = $this->reports_helper('facility',$items,$between,$selector,array(),$order,$dir,$this->destination_page,$export,$this->items_per_page);
                $response_export_list = $response_export['response'];
                $data['filters'] = $this->export_info($items,$between,$selected,null);
                //ExportPDF-PRINT
                $response_export_list = $facility_list;
            }
            //Getting_totals
            $facility_list_totals = $facility_list;
            //set form data
            $form_data['end_date'] = $end_date;
            $form_data['start_date'] = $start_date;
            $form_data['whichfacility'] = $filters_used['facility_id'];
            $form_data['direction'] = $dir;
            $form_data['order'] = $order;
            $form_data['cur_page'] = $this->destination_page;
            $form_data['date_warning_message'] = $date_warning_message;

            //gets image for asc or desc
            if($form_data['direction'] == 'DESC'){
                $data['image'] = '<img src="/images/arrow_down.png" style="border : 0;  width:15px;" alt="Descending"/>';
            }
            else{
                $data['image'] = "<img src='/images/arrow_up.png' style='border : 0;  width:15px;' alt='Ascending'/>";
            }

            //set form data and send form_data
            $form_data['items_per_page'] = $this->items_per_page;
            $data['facilities'] = $this->facilitymodel->get_facilities($is_active)->result();//gets all facilities available
            $form_data['num_pages'] = ceil($size/$this->items_per_page);//num of log pages
            $form_data['pages'] = $this->pages;
            $data['form_data'] = $form_data;
            $data['facility_list'] = $facility_list;

            //pagination setup
            $this->pages->items_total = $size;
            $this->pages->current_page = $this->destination_page;
            $this->pages->paginate();
            if(!$all_report){
                if($facility_id){
                    foreach($data['facilities'] as $facility){
                        if($facility->id === $facility_id){
                            $data['facility'] = $facility->name;
                        }
                    }
                }else{
                    $data['facility'] = "No facility set";
                }
            }
        }
        //checks to see if there is an facility selected.  This shows whether or not this is the first time the page has loaded.
        else if($facility_selected || !$all_report && $adhoc_report_id == ''){
            $selector = array(
                'facility.id' => ($facility_selected),
            );

            //POST information
            $items = array();
            $end_date = $this->input->post('end_date',TRUE);
            $start_date = $this->input->post('start_date',TRUE);
            //$date_array = array($end_date, $start_date);
            $date_warning_message = $this->get_paired_dates_filter_validation_message($start_date, $end_date);

            //Setting exports
            $export = $this->input->post('export',TRUE);
            $export_pdf = $this->input->post('export_pdf',TRUE);
            $print_page = $this->input->post('print_page',TRUE);
            $is_export = FALSE;
            if($export) {
                $is_export = 'excel';
            }
            else if($export_pdf) {
                $is_export = 'pdf';
            }
            else if($print_page == 1) {
                $is_export = 'print';
            }
            $data['is_export'] = $is_export;

            $between = array(
                'messages.timestamp' => $this->check_paired_dates($start_date,$end_date),
            );

            //get direction (desc/asc)and if it is being exported
            $order = ($this->input->post('order',TRUE))?$this->input->post('order',TRUE):'name';
            $dir = $this->direction_check($order,$this->input->post('lastorder',TRUE),$this->input->post('direction',TRUE),$this->input->post('change',TRUE));

            //calls helper to get data
            $response = $this->reports_helper('facility',$items,$between,$selector,array(),$order,$dir,$this->destination_page,$export,$this->items_per_page);
            $facility_list = $response['response'];

            //Adhoc_Report
            $response_adhoc = $this->reports_helper_adhoc('facility',$items,$between,$selector,array(),$order,$dir,$this->destination_page,$export,$this->items_per_page);

            //set form data
            $form_data = $this->input->post(NULL,TRUE);
            $form_data['start_date'] = $this->reports_correct_out_of_bound_date($start_date);
            $form_data['end_date'] = $this->reports_correct_out_of_bound_date($end_date);

            $form_data['direction'] = $dir;
            $form_data['order'] = $order;
            $form_data['cur_page'] = $this->destination_page;
            $form_data['date_warning_message'] = $date_warning_message;
            $size = $response['size'];

            //gets image for asc or desc
            if($form_data['direction'] == 'DESC'){
                $data['image'] = '<img src="/images/arrow_down.png" style="border : 0;  width:15px;" alt="Descending"/>';
            }
            else{
                $data['image'] = "<img src='/images/arrow_up.png' style='border : 0;  width:15px;' alt='Ascending'/>";
            }

            //set form data and send form_data
            $form_data['items_per_page'] = $this->items_per_page;
            $data['facilities'] = $this->facilitymodel->get_facilities($is_active)->result();//gets all facilities available
            $form_data['num_pages'] = ceil($size/$this->items_per_page);//num of log pages
            $form_data['pages'] = $this->pages;
            $data['form_data'] = $form_data;
            $data['facility_list'] = $facility_list;

            //pagination setup
            $this->pages->items_total = $size;
            $this->pages->current_page = $this->destination_page;
            $this->pages->paginate();
            if(!$all_report){
                if($facility_id){
                    foreach($data['facilities'] as $facility){
                        if($facility->id === $facility_id){
                            $data['facility'] = $facility->name;
                        }
                    }
                }else{
                    $data['facility'] = "No facility set";
                }
            }
            if(mb_strtoupper($selector['facility.id']) != '(ALL)') $selected = 'Facility: ' . $this->facilitymodel->get_facility($selector['facility.id'])->result()[0]->name;
            //Export PDF or Print
            if($is_export == 'pdf' || $is_export == 'print') {
                $response_export = $this->reports_helper('facility',$items,$between,$selector,array(),$order,$dir,$this->destination_page,$export,$size);
                $response_export_list = $response_export['response'];
                $data['filters'] = $this->export_info($items,$between,$selected,null);
            }
            //Getting_totals
            $size_all = $this->facilitymodel->get_facility_list_size_reports()->result();
            $response_total = $this->reports_helper('facility',$items,$between,$selector,array(),$order,$dir,$this->destination_page,$export,$size_all[0]->count);
            $facility_list_totals = $response_total['response'];
        }
        else {
            $data['facilities'] = $this->facilitymodel->get_facilities($is_active)->result();//gets all facilities available
            $facility_list = $this->facilitymodel->get_first_facilities($this->items_per_page)->result();
            $size = $this->facilitymodel->get_facility_list_size_reports()->result();
            $size = $size[0]->count;
            $export = FALSE;
            $form_data = array(
                'direction' => 'ASC',
                'order' => 'name',
                'cur_page' => '1',
            );
            $data['image'] = '<img src="/images/arrow_down.png" style="border : 0;  width:15px;" alt="Descending"/>';
            //pagination setup
            $this->pages->items_total = $size;
            $this->pages->current_page = $this->destination_page;
            $this->pages->paginate();
            $form_data['pagination_bar'] = $this->pages->display_pages();
            $form_data['items_per_page_dropdown'] = $this->pages->display_items_per_page();
            $form_data['num_pages'] = ceil($size/$this->items_per_page);//num of log pages
            $form_data['items_per_page'] = $this->items_per_page;
            $form_data['pages'] = $this->pages;
            $data['form_data'] = $form_data;
            $data['facility_list'] = $facility_list;
            $data['filters'] = ' ';
            $data['is_export'] = FALSE;
            //Settings Exports
            $export = FALSE;
            $export_pdf = FALSE;
            $print_page = FALSE;
            //Getting app Totals
            $facility_list_totals = $this->facilitymodel->get_first_facilities($size)->result();
            //Adhoc Report
            $between = array ("messages.timestamp" => Array("start"=>"", "end" =>""));
            $response_adhoc = "(facility.id like '%' OR facility.id IS NULL)";
            $dir = "ASC";
            $order = "name";
        }
        //Adhoc Report
        $data['adhoc_report_between'] = $between;
        $data['adhoc_report_order'] = $dir;
        $data['adhoc_report_direction'] = $order;
        $data['adhoc_report_response']= $response_adhoc;
        $data['adhoc_report_type'] = "Facility";

        //print boolean set in adhoc report page print link
        if(isset($adhoc_print_page) && $adhoc_print_page == 'true') {
            $data['adhoc_print_page'] = true;
        }

        $va_totals = new StdClass;
        $va_totals->totalUsers = 0;
        $va_totals->totalGroup = 0;
        $va_totals->totalSent = 0;
        $va_totals->totalMessages = 0;
        $va_totals->totalReceived = 0;

        foreach( $facility_list_totals as $requests ) {
            $va_totals->totalUsers      += $requests->Number_of_users;
            $va_totals->totalGroup      += $requests->Number_in_group;
            $va_totals->totalSent       += $requests->Number_of_sent;
            $va_totals->totalMessages   += $requests->Total_messages - $requests->Number_of_drafts;
        }
        $va_totals->totalReceived   = $va_totals->totalMessages - $va_totals->totalSent;

        $data['va_totals'] = $va_totals ;

        //Set view or export view
        if($export){
            //Setting Totals for Excel Export
            $totalCount = count((array)$facility_list);
            //Unset Row Number for Export $totalCount = count((array)$facility_list);
            for ($i = 0; $i < $totalCount; $i++) {
                unset($facility_list[$i]->row);
                unset($facility_list[$i]->id);
            }

            // prepare data so that the numbers are calculated the same way in HTML view, print view, and PDF export
            $facility_list = $this->reports_facility_excel_data_alt($facility_list);

            $this->export(array('VA Facility','Number of Users','Number of Groups', 'Total Messages Sent','Total Messages Received','Total Messages'),$facility_list,$export_file_name,$items,$between,$selected,null);
        }
        else if($export_pdf) {
            if (!empty($response_export)){
                $data['export_facility_list'] = $response_export_list;
            } /* else {
                $data['facility_list'] = $responses_list;
            } */
            $html = $this->load->view('api/reports/result_tables/result_facility', $data, true);
            $this->export_pdf($export_file_name.'.pdf', $html, null, $size);
        }
        else if($print_page == 1) {
            $this->clear_cache();
            if (!empty($response_export)){
                $data['export_facility_list'] = $response_export_list;
            } /* else {
                $data['facility_list'] = $responses_list;
            } */
            $data['print_page'] = true;
            $form_data['page_select'] = $this->destination_page;
            $data['facility_list_totals'] = $facility_list_totals;

            $this->load->view('api/reports/facility', $data);
        }
        else {
            $data['facility_list_totals'] = $facility_list_totals;
            $this->load->view('api/reports/facility', $data);
        }
    }
}