<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage controllers
*//** */
 

// This can be removed if you use Modular Extensions
require_once APPPATH.'libraries/REST_Controller.php';
require_once APPPATH.'third_party/Paginator.php';
require_once VLERPATH.'third_party/WkHtmlToPdf.php';
require_once APPPATH.'controllers/admin/admin_controller.php';

/**
* @package direct-as-a-service
* @subpackage controllers
*/
class Reports extends Admin_controller{
	
	var $report_tabs = array("requests"=>"Requests", "events"=>"Events","logins"=>"Logins","mail"=>"Mail","user_activity_summary"=>"User Summary","group_activity_summary"=>"Group Summary","facility"=>"Facility","hisp"=>"HISP","points_of_origin"=>"Points of Origin", "adhoc_reports"=>"Ad-hoc Reports");
	protected $pages, $bar_page, $jump_page, $items_per_page, $destination_page;

	public function __construct(){
		parent::__construct();

		$this->load->library(array('eventlog'));
		$this->load->model( array('applicationmodel','pointsoforiginmodel','hispmodel','useractivitysummarymodel','adhocreportsmodel'));
		
		require_model('mail_log_entry');
		
		$this->pages = new Paginator('');
		$this->pages->page_setup($this->bar_page, $this->jump_page, $this->items_per_page, $this->destination_page);
	}
    
    public function index() {
        //get user id from session to get permissions
        $permissions = $this->account_permissions;
        $show = $this->show;		
		
        foreach ($this->report_tabs as $key=>$value){		
            if($this->has_access('reports')){
				redirect('reports/'.$key);
            }
        }
		
        redirect('onboarding');
    }

    //converts the id into the name based on what type it is
    protected function id_to_name($type,$id){
        $this->load->model('accountrequestmodel');
        $data=array();
        switch ($type){
            case 3://a user
                //suppress warning in case user id isn't provided
                $name = @$this->usersmodel->get_username_from_id($id);
                if($name){
                    $data['id'] = $name;
                }
                else{
                    $data['id'] = "N/A";
                }
                $data['type']="User";
                break;
            case 2://an application
                $name = $this->applicationmodel->get_application($id)->result();
                if($name){
                    $data['id'] = $name[0]->name;
                }
                else{
                    $data['id'] = "N/A";
                }
                $data['type'] = "Application";
                break;
            case 1://an application request
                $data['type'] = "App Request";
				$request = Application_request::find_one($id);
                if(Application_request::is_an_entity($request)) {
                    if(!$request->property_is_empty('name')){ $data['id'] = $request->name; }
                }
                if(!isset($data['id'])) { $data['id'] = 'N/A'; }
                break;
            case 4://user request
                $data['type'] = "User Request";
                $request = $this->accountrequestmodel->get_request($id);
                if($request) {
                    $name = $request->result();
                    if($name){ $data['id'] = $name[0]->user_org_id; }
                }
                if(!isset($data['id'])) { $data['id'] = 'N/A'; }
                break;
            case 5://category
                $data['type'] = "Category";
				$data['id'] = 'N/A';
                $category = Ticket_category::find_one($id);
				if(Ticket_category::is_an_entity($category))
					$data['id'] = $category->$category;
            case 6://group
                $data['type'] = "Group";
                if(!isset($data['id'])) { $data['id'] = 'N/A'; }
                break;
            case 7://facility
                $request = $this->facilitymodel->get_facility($id);
                $data['type'] = "Facility";
                if($request) {
                    $name = $request->result();
                    if($name){ $data['id'] = $name[0]->name; }
                }
                if(!isset($data['id'])) { $data['id'] = 'N/A'; }
                break;
            case 8://Message
                $data['type'] = "Search";
                if($id){
                    $data['id'] = $id;
                }
                else { $data['id'] = 'N/A'; }
                break;
	    case 9: //Incoming message
			$data['type'] = "Incoming Message";
				$data['id'] = $id;
                break;
        }
        return $data;
    }
    
    protected function get_type($id) {
        switch ($id){
            case 3:
                return "User";
            case 2://an application
                return "Application";
            case 1://an application request
                return "Application Request";
            case 4://user request
                return "User Request";
            case 5://category
                return "Category";
            case 6://group
                return "Group";
            case 7://facility
                return "Facility";
            case 8://Message
                return "Search";
			case 9://
				return 'Incoming Message';
        }
    }
    
    //chooses which (asc or desc) the table should be
    protected function direction_check($order,$lastorder,$direction,$change){
        //reloaded by filter and not clicking to change direction.  also make sure that it was not changed by user
        if ($change == 'false' && ($direction == "DESC" || $direction == "ASC")){
            return $direction;
        }
        //colum selected is same as last
        if($order == $lastorder){
            if($direction == 'DESC'){
                return 'ASC';
            }
            else{
                return "DESC";
            }
        }
        //clicked on new colum
        else{ 
            return "DESC";
        }
    }
    /* This function returns the values of sum */
    function sum_by_object_name(array $arr, $property) {
        $sum = 0;  
        foreach($arr as $object) {
            $sum += isset($object->{$property}) ? $object->{$property} : 0;
        }
        return $sum;
    }     

    /**
    * Ensures that a date is not a future date, i.e. a date later than the current time.
    * Future dates will be replaced with the current date in the given format.
    *
    * We're currently not prepared to deal with dates prior to 1901, which is well before the start of the Direct
    * project and shouldn't come up in the reports anyway.  To be safe, we'll make sure that a date is not earlier than 01/01/2000 12:00:00 am Eastern Time.
    * Dates will be replaced with 01/01/2000 12:00:00 am Easter Time if they're earlier than that.
    *
    * Created for issue VAD-749, VAD-807, and VAD-812.
    * @author Harry Guo <guo_haoyu@ne.bah.com>
    */
    protected function reports_correct_out_of_bound_date($date_string) {
        
        $date = $this->parse_date($date_string);
        
        if ( $date ) {
            if ( new DateTime() < $date ) {
                $date_string = date('m/d/Y h:i a T');
            } 
            else if ( $date < new DateTime('01/01/2000 12:00 AM EST') ) {
                $date_string = '01/01/2000 12:00 AM EST';
            }   
        }
        
        return $date_string;
    }
    /**
    * Check whether a pair of dates (a start date and an end date) are valid.
    * Return null value for any date that's either invalid or of unacceptable format. 
    * Alter dates that are out of pre-defined boundaries.
    * Return UNIX timestamp for any accepted and/or altered date.
    * 
    * A date here is referring to a date/time string.
    *
    * A date in considered valid here only if it can be parsed by parse_date() method.
    *
    * Accepted format string pattern is defined in get_date_pattern() method, such as 
    * M/D/YYYY, M/D/YYYY hh:mm:ss, with optional am/pm, and/or an optional time zone abbreviation code.
    * Such format restriction was the results of requiring a 4 digits year, instead of allowing 2 digits.
    *
    * If a date is earlier than 01/01/2000 12:00:00 AM EST, it will be altered to this date.
    *
    * If a date is later than Tue, 19 Jan 2038 03:14:07 UTC, it will be altered to this date.
    * 
    * If a date is a future date, it will be altered to the current time.
    *
    * Modstly of such restrictions are set due to the limitated date range of PHP:
    *    Fri, 13 Dec 1901 20:45:54 UTC to Tue, 19 Jan 2038 03:14:07 UTC.
    *    (http://php.net/manual/en/function.strtotime.php)
    * 
    * Created for issue VAD-749, VAD-807, and VAD-812.
    * @author Harry Guo <guo_haoyu@ne.bah.com>
    */    
    protected function check_paired_dates($start, $end) {

        // Criteria consistent with function get_paired_dates_filter_validation_message.

        $timestamps = array();

        foreach(array('start' => trim($start), 'end' => trim($end)) as $description => $date_string){
            $date = $this->parse_date($date_string);
            
            $timestamp = null;

            if ( $date && $this->is_a_report_filter_date($date_string) ) {
                // date valid and in acceptable format

                $date_high_bound = new DateTime('01/19/2038 03:14:07 UTC');
                $now = new DateTime();

                // A future date is changed to current time
                if ( $date > $now ) {
                    $date = $now;
                }
                // A current time later than 1/19/2038 03:14:07 UTC
                // is changed to 1/19/2038 03:14:07 UTC
                if ( $date > $date_high_bound ) {
                    $date = $date_high_bound;
                }
                // Old date before 01/01/2000 12:00 AM EST is changed to 
                // 01/01/2000 12:00 AM EST
                $date_low_bound  = new DateTime('01/01/2000 12:00 AM EST');
                if ( $date < $date_low_bound ) {
                    $date = $date_low_bound;
                }
                $timestamp = $date->getTimestamp();
            }
            $timestamps[$description] = $timestamp;
        }
        return $timestamps;
    }



    //sets value of search based on what type of comparison
    protected function search_type($value,$type){
        
        if($value == ''){//if no value ignore type
            return "%";
        }
        
        switch ($type){
            case 'equals':
                return $value;
                break;
            case 'contains':
                return "%".$value."%";
                break;
            case 'starts':
                return $value."%";
                break;
            case 'ends':
                return "%".$value;
                break;
            default:
                return $value;
                break;
        }
    }
    
    //sets value of search based on what type of comparison
    protected function search_type_for_array($value,$type){
        
        if($value == ''){//if no value ignore type
            return "%";
        }
        
        switch ($type){
            case 'equals':
                return "/^".$value."$/i";
                break;
            case 'contains':
                return "/".$value."/i";
                break;
            case 'starts':
                return "/^".$value."/i";
                break;
            case 'ends':
                return "/".$value."$/i";
                break;
            default:
                return "/^".$value."$/i";
                break;
        }
    }
    //gets the ids from each of the tabels to add  them to the query
    protected function names_to_ids($idsql,$typesql,$name,$type){
        $type = mb_strtoupper($type);
        $this->load->model('accountrequestmodel');
        $sql = "";
        if($type == "3" || $type == "(ALL)"){//if it is a user
            if($typesql){
                $sql .= "(".$typesql." = 3 AND (";
            }
            else{
                $sql .= "((";
            }
			
            $add = "(2=1)";
            if($name=='%'){//if blank dont even search
                $add .= " OR (1 = 1)";
            }
            else{
                $results=$this->usersmodel->get_ids_from_username($name)->result();//search for ids like name
                foreach($results as $result){//add each username to     
                    $add .= " OR (".$idsql." = ". $result->user_id.")";
                }
            }
			
            $sql .=$add."))";
        }
        if($type == "2" || $type == "(ALL)"){//if application
            if($sql != ""){
                $sql .= " OR ";
            }
            if($typesql){
                $sql .= "(".$typesql." = 2 AND (";
            }
            else{
                $sql .= "((";
            }
            $add = "(2=1)";
            if($name=='%'){
                $add .= " OR (1 = 1)";
            }
            else{
                $results=$this->applicationmodel->get_ids($name)->result();
                foreach($results as $result){    
                    $add .= " OR (".$idsql." = ". $result->id.")";
                }
            }
            $sql .=$add."))";
        }
        if($type == "1" || $type == "(ALL)"){//if application request
            if($sql != ""){
                $sql .= " OR ";
            }
            if($typesql){
                $sql .= "(".$typesql." = 1 AND (";
            }
            else{
                $sql .= "((";
            }
            $add = "(2=1)";
            if($name=='%'){
                $add .= " OR (1 = 1)";
            }
            else{
				Application_request::db()->select('id');
				Application_request::db()->like('name', $name);
				$application_request_ids = array_keys(Application_request::find());
				
                foreach($application_request_ids as $application_request_id){
                    $add .= " OR (".$idsql." = ". $application_request_id.")";
                }
            }
            $sql .=$add."))";
            
        }
        if($type == "4" || $type == "(ALL)"){//if user request
            if($sql != ""){
                $sql .= " OR ";
            }
            if($typesql){
                $sql .= "(".$typesql." = 4 AND (";
            }
            else{
                $sql .= "((";
            }
            $add = "(2=1)";
            if($name=='%'){
                $add .= " OR (1 = 1)";
            }
            else{
                $results=$this->accountrequestmodel->get_ids($name)->result();
                foreach($results as $result){
                    $add .= " OR (".$idsql." = ". $result->id.")";
                }
            }
            $sql .=$add."))";
            
        }
        if($type == "6" || $type == "(ALL)"){//groups
            if($sql != ""){
                $sql .= " OR ";
            }
            if($typesql){
                if($name == '%'){
                    $sql .= "(".$typesql." = 6)";
                }
                else{
                    $sql .= "(".$typesql." = 6 AND ".$idsql." like ".$this->db->escape($name).")";
                }
            }
                
        }
        if($type == "8" || $type == "(ALL)"){//messages
            if($sql != ""){
                $sql .= " OR ";
            }
            if($typesql){
                if($name == '%'){
                    $sql .= "(".$typesql." = 8)";
                }
                else{
                    $sql .= "(".$typesql." = 8 AND ".$idsql." like ".$this->db->escape($name).")";
                }
            }
        
        }
        if($type == "5"){//preserving this in case it's used anywhere except the login report, but this is otherwise deprecated in favor of login_report_username
			if($name=='%')	return $sql." [logins].[org_id] LIKE N'%'";
			
			$conditions = array();
			foreach($this->usersmodel->get_orgs_from_username($name)->result()as $result){    
				$conditions[] = $idsql." = ". $result->user_org_id;
			}
			
			if(empty($conditions)){
				return $sql." org_id = -1"; //if results don't exist, use nonexistant org_id
			} 
			
			return $sql.' ('.implode(' OR ', $conditions).')';	
		}
		
		if(mb_strtolower($type) == 'login_report_username'){ //the login report is always joined with the users table, so we don't need to do the roundabout lookup used for type 5
			
			//gah.  fancy footwork to try to make the escaping work for $name.  this could all go away if we came up with a less spaghetti-monster-of-doom way of applying conditions.
			if(string_begins_with('%', $name) && string_ends_with('%', $name))
				return $sql." users.username LIKE '%".$this->db->escape_like_str(strip_from_beginning('%', strip_from_end('%', $name)))."%'";
			if(string_begins_with('%', $name))
				return $sql." users.username LIKE '%".$this->db->escape_like_str(strip_from_beginning('%', $name))."'";
			elseif(string_ends_with('%', $name))
				return $sql." users.username LIKE '".$this->db->escape_like_str(strip_from_end('%', $name))."%'";
						
			return $sql." users.username = ".$this->db->escape($name);
		}		
		
        return $sql;
    }
    
    //generates and returns respose for filtered query
    protected function reports_helper($table,$items,$between,$selector,$typesearch,$order,$dir,$page,$export,$items_per_page) {
        //$sql = '0=0';//always true statment to start query //NO.  Alternatives: https://collab.boozallenet.com/confluence/display/DPII/Refactoring+Models -- MG 2015-05-11
		
		$conditions = array();
		
        //add each item to query
        foreach ($items as $key => $value){//this if for search field
            if($value!="%"){
                $conditions[] = $key ." like ". $this->db->escape($value);
            }
        }
        foreach ($between as $key => $value){//this if for anything that has an upper and lower boundary (ie date)
            if($value['end']){
               $conditions[] = $key ." <= ".$this->db->escape($value['end']);
            }
            if($value['start']){
               $conditions[] = $key ." >= ".$this->db->escape($value['start']);
            }
        }
        foreach ($selector as $key => $value){//this if for ones with a drop down menu
            if(mb_strtoupper($value) == "(ALL)"){
                $conditions[] = "(". $key ." like '%' OR ".$key." IS NULL)";
            }
            else{
                $conditions[] = $key ." like ". $this->db->escape($value);
            }
        }
                
        foreach($typesearch as $key => $value){//this if for inputs that have different types and their ids refer to different entries on different tables
            if(!(mb_strtoupper($value['type'])=="(ALL)" && $value['name']=="%")){
                $conditions[] = $this->names_to_ids($key,$value['typesql'],$value['name'],$value['type']);
            }
        }
		
		$sql = implode_nonempty(' AND ', array_map('trim', $conditions));
		
        if($order != 'id' && $table != 'request') {
        	if ((string_contains('DESC',$order))||(string_contains('ASC',$order))){
        		$order .= ",id ". $dir ;//what to order values into
        	}
        	else{
        		$order = str_replace("'","",$order). " ". $dir. ",id ". $dir ;//what to order values into
        	}
        }
    
        //get starting point based on page number
        if(!$page){
            $page = 1;
        }
        $page = (($page-1)*$items_per_page)+1;
		
		if($export)
			$this->output->enable_profiler(FALSE);
		
        switch($table){//choose what reports you are looking at
            case 'request':
                //get size;
	            $size = Request::count_for_reports($sql);
				
				if(string_contains('id', $order)){
					$order = preg_replace('/([^a-zA-Z0-9_\.])id([^a-zA-Z0-9_-])/', '${1}request.id$2', str_replace('application_id', 'application.name', $order));
				}
				Request::db()->order_by($order, $dir);
				
				if($export){
					Request::db()->limit(200);
				}else{
                    if(!$this->is->nonzero_unsigned_integer($page) || $size < $page) $page = 1;//if you are on a page larger then what the size will be go back to first page
					Request::db()->limit($items_per_page, $page-1);
                }
				
				$responses_list = Request::find_for_reports($sql);
				
                break;
            case 'event':
				Event::db()->where($sql, NULL, FALSE); //TODO - refactor this so that we don't need to escape the SQL
				$size = Event::count();
				Event::db()->where($sql, NULL, FALSE)->order_by($order); 
				
                if(!$export){
                    if(!$this->is->nonzero_unsigned_integer($page) || $size < $page) $page = 1;//if you are on a page larger then what the size will be go back to first page
		    		Event::db()->limit($items_per_page, $page-1);
				   
                }
				$responses_list = Event::find();
                break;
            case 'login':
            	$size = Authentication_log_entry::count_for_reports($sql);

				if(!$export && $size < $page){//if you are on a page larger then what the size will be go back to first page
					$page = 1;
				}
				if(string_begins_with('id', $order))$order = 'id '.$dir;
				Authentication_log_entry::db()->order_by($order);
				
				if(!$export)
					Authentication_log_entry::db()->limit($items_per_page,$page-1);
					
				$responses_list = Authentication_log_entry::find_for_reports($sql);
                
                break;
            case 'mail':
            	Mail_log_entry::db()->where($sql);
            	$size = Mail_log_entry::count();
                if($export){ //export get all pages
                	Mail_log_entry::db()->where($sql)->order_by($order);
                	$responses_list = Mail_log_entry::find();
                }
                else{
                    if($size<$page){//if you are on a page larger then what the size will be go back to first page
                        $page = 1;
                    }
                    if(string_begins_with('id',$order))$order = 'id '.$dir;
                    Mail_log_entry::db()->where($sql)->order_by($order)->limit($items_per_page,$page-1);
                    $responses_list = Mail_log_entry::find();
                }
                break;    
            case 'tickets':
				Ticket::db()->where($sql, NULL, $escape_columns=false);
				$size = Ticket::count();
			
				if(string_contains('user_id', $order)){
					$order = ($order == 'user_id DESC') ? 'DESC' : 'ASC';
					Ticket::db()->order_by('username', $order);
				}elseif(string_contains('category_id', $order)){
					$order = ($order == 'category_id DESC') ? 'DESC' : 'ASC';
					Ticket::db()->order_by('category_name', $order);					
				}elseif(!empty($order)){
					Ticket::db()->order_by($order);
				}else{
					Ticket::db()->order_by('tickets.id asc');
				}				
				
				if(!$export){
					if(!$this->is->nonzero_unsigned_integer($page) || $size < $page) $page = 1;//if you are on a page larger then what the size will be go back to first page
                   	Ticket::db()->limit($items_per_page, $page-1);
				}			
							
				Ticket::db()->where($sql, NULL, $escape_columns=false);								
                $responses_list = Ticket::find_for_reports();
                break;
            case 'facility':
                //getting size number
                $size = $this->facilitymodel->get_facility_list_size_reports_sql($sql)->result();
                $size = $size[0]->count;
                if($export){//if export get all pages
                    $responses_list= $this->facilitymodel->get_request_filter_facility_order_export($sql,$order,$this->db->escape($page),$items_per_page)->result();
                } else { //if you are on a page larger then what the size will be go back to first page
                    if($size<$page){
                        $page = 1;
                    }
                    if(string_contains('name', $order)){//if sorting by name
                        $responses_list= $this->facilitymodel->get_request_filter_facility_order($sql,$order,$this->db->escape($page),$items_per_page)->result();
                    }
                    else{
                        $responses_list= $this->facilitymodel->get_request_filter_facility($sql,$order,$this->db->escape($page),$items_per_page)->result();
                    }
                }
                break;
            case 'user_activity_summary':
                //sql query that excludes the date filter to include users who had no acitivity during the time period specified
                $sql_date_filter_excluded = preg_replace('/ms.timestamp \<\= [0-9]{10} AND/' , '' , $sql);
                $sql_date_filter_excluded = preg_replace('/ms.timestamp \>\= [0-9]{10} AND/' , '' , $sql_date_filter_excluded);
                    
                //getting size number
                
                $size = $this->useractivitysummarymodel->count($sql_date_filter_excluded);
                                
				 //if you are on a page larger then what the size will be go back to first page
				if(!$export && $size < $page){
					$page = 1;
				}
				$responses_list = $this->useractivitysummarymodel->get_request_filter_user_activities($sql,$sql_date_filter_excluded,$order,$this->db->escape($page),$items_per_page);
			
                break;    
            case 'group_activity_summary':
                //sql query that excludes the date filter to include groups who had no acitivity during the time period specified
                $sql_date_filter_excluded = preg_replace('/ms.timestamp \<\= [0-9]{10} AND/' , '' , $sql);
                $sql_date_filter_excluded = preg_replace('/ms.timestamp \>\= [0-9]{10} AND/' , '' , $sql_date_filter_excluded);
                
                //getting size number
                $size = $this->groupsmodel->activity_summary_count($sql_date_filter_excluded);
				
                //if you are on a page larger then what the size will be go back to first page
				if(!$export && $size<$page){
					$page = 1;
				}
				$responses_list= $this->groupsmodel->get_request_filter_group_activities($sql,$sql_date_filter_excluded,$order,$this->db->escape($page),$items_per_page);
                break;
            default: //tries to call a bad reports table
	    		$this->error->should_be_a_known_report($table);
                break;
        }
        $response=array(
            'size'=>$size,
            'response'=>$responses_list
        );
        return $response;
        
    }
    
    /*
     * export is used for exporting the results to excel 
     */
#TODO - this is too many parameters for a function - if you need this many, it's a sign that this should be a configurable class/library. (Keep in mind when refactoring).     
	protected function export($header,$results,$name,$items,$between,$selected,$ldap,$report_id = null,$result_set_size = null, $save_to_file = null){		
		if($report_id != null) {
			$token_name = 'fileDownloadToken' . $report_id;
		}
		else {
			$token_name = 'fileDownloadToken';
		}
		
		
		//set fileDownloadToken, so the system is able to detect when the file downloading window for pdf export returns
		setcookie($token_name, true, time() + 3600, '/reports/', false, false);
		setcookie('resultSetSize' . $report_id, $result_set_size, time() + 3600, '/reports/', false, false);
		
		if($save_to_file) {
			$path_to_temp_file = sys_get_temp_dir() . '\\' . time() . $report_id . '.csv';
			$fp = fopen($path_to_temp_file, 'w');
		}
		else {
			header('Content-Type: application/download');
			header('Content-Transfer-Encoding: binary');
			header('Content-Disposition: attachment; filename="'.$name.'.csv"');
			$fp = fopen('php://output', 'w');
		}
		
		
		$date = date('m/d/Y h:i:s A', time());
		$date = ' ' . (string)$date;
		fputcsv($fp,  array('FOR OFFICIAL USE ONLY', '', '', 'Report generated by '.$this->session->userdata('user_info')['first_name']. ' ' .$this->session->userdata('user_info')['last_name'], '', '', '', $date, '', ''));
		$activeFilters = array($this->export_info($items,$between,$selected,$ldap), '', '', '');
		fputcsv($fp, $activeFilters);
		fputcsv ($fp, $header);
		foreach($results as $result) {
			if(Entity::is_an_entity($result)){
				if(method_exists($result, 'values_for_report'))
					fputcsv($fp, $result->values_for_report());
				else
					fputcsv($fp, $result->values());
			}else{
				$row=array();
				foreach($result as $part) {
					array_push($row,$part);
				}
				fputcsv ($fp, $row);
			}
		}
		fclose($fp);
		
		if($save_to_file) {
			$export_array['report_id'] = $report_id;
			$export_array['report_name'] = $name;
			$export_array['path_to_temp_file'] = $path_to_temp_file;
			
			return $export_array;
		}
	}

    protected function reports_facility_excel_data_alt( $facility_list ) { 

        $max = count($facility_list);
        $facility_list_alt = array();
        for($i = 0; $i < $max; $i++) {
            $facility = new StdClass;
            
            // 4: drafts, 6: total, 3: sent
            $number_of_total = $facility_list[$i]->Total_messages - $facility_list[$i]->Number_of_drafts;
            $number_of_sent  = $facility_list[$i]->Number_of_sent;
            $facility->name             = $facility_list[$i]->name;
            $facility->Number_of_users  = $facility_list[$i]->Number_of_users;
            $facility->Number_in_group  = $facility_list[$i]->Number_in_group;
            $facility->Number_of_sent   = $number_of_sent;
            $facility->Number_received  = $number_of_total - $number_of_sent;
            $facility->Total_messages   = $number_of_total;

            $facility_list_alt[] = $facility;
        }

        $facility_list_alt['totalCount'] = new StdClass;
        $facility_list_alt['totalCount']->name = 'VA Total:';
        $facility_list_alt['totalCount']->Number_of_users = $this->sum_by_object_name((array)$facility_list_alt, 'Number_of_users');
        $facility_list_alt['totalCount']->Number_in_group = $this->sum_by_object_name((array)$facility_list_alt, 'Number_in_group');
        $facility_list_alt['totalCount']->Number_of_sent  = $this->sum_by_object_name((array)$facility_list_alt, 'Number_of_sent');
        //have to do this because for some reason the export function is processing where to put the data based on the order these classes are added to the facility_list parent class
        #TODO: Fix export function to do this in a more sane way
        $Total_Messages = $this->sum_by_object_name((array)$facility_list_alt, 'Total_messages');
        $facility_list_alt['totalCount']->Number_received = $Total_Messages - $facility_list_alt['totalCount']->Number_of_sent;
        $facility_list_alt['totalCount']->Total_messages  = $Total_Messages;

        return $facility_list_alt;
    }
    //Prep SQL for Adhoc Reports
    protected function reports_helper_adhoc($table,$items,$between,$selector,$typesearch,$order,$dir,$page,$export,$items_per_page) {
        $conditions = array();
        //add each item to query
        foreach ($items as $key => $value){//this if for search field
            if($value!="%"){
               $conditions[] = $key ." LIKE ". $this->db->escape($value);
            }
        }
		
        foreach ($between as $key => $value){//this if for anything that has an upper and lower boundary (ie date)
            if($value['end']){
                $conditions[] = $key ." <= ".$this->db->escape($value['end']);
            }
            if($value['start']){
                $conditions[] = $key ." >= ".$this->db->escape($value['start']);
            }
        }
        
        foreach ($selector as $key => $value){//this if for ones with a drop down menu
            if(strtoupper($value) == "(ALL)"){
                $conditions[] = '('. $key ." LIKE '%' OR ".$key.' IS NULL)';
            }
            else{
                $conditions[] = $key ." LIKE ". $value;
            }
        }
                
        foreach($typesearch as $key => $value){//this if for inputs that have different types and their ids refer to different entries on different tables
            if(!(strtoupper($value['type'])=="(ALL)"&&$value['name']=="%")){
                $conditions[] = '('. $this->names_to_ids($key,$value['typesql'],$value['name'],strtoupper($value['type'])) .')';
            }
        }
        
        return implode(' AND ', $conditions);
    }
    
	protected function export_pdf($file_name, $html, $report_id = null, $result_set_size = null) {
		if($report_id != null) {
			$token_name = 'fileDownloadToken' . $report_id;
		}
		else {
			$token_name = 'fileDownloadToken';
		}		
		$pdf = new WkHtmlToPdf(array('binPath' => WKHTMLTOPDF_EXE_PATH));

		// Add a HTML string
		$pdf->addPage($html);
		//set fileDownloadToken, so the system is able to detect when the file downloading window for pdf export returns
		setcookie($token_name, true, time() + 3600, '/reports/', false, false);
		setcookie('resultSetSize' . $report_id, $result_set_size, time() + 3600, '/reports/', false, false);
        
		if(!$pdf->send($file_name))
			throw new Exception('Could not create PDF: '.$pdf->getError());
	}
    
    protected function export_info($items,$between,$selected,$ldap) {
        
        $filters = '';
        if ($items != null) {
            foreach ($items as $key => $value){
                if($value!="%" && $value != '(ALL)'){
                    if ($value[0]=='%' && mb_substr($value, -1)=='%') $value = 'contains: ' . trim($value, '%');
                    elseif ($value[0]=='%') $value = 'ends with: ' . trim($value, '%');
                    elseif (mb_substr($value,-1)=='%') $value = 'starts with: ' . trim($value, '%');
                    else {
                        $value = 'equals: ' . $value;
                    }
		    if($key=='id') $pair = 'ID ' . $value;
                    if($key=='tickets.id') $pair = 'ID ' . $value;
                    if($key=='session_id') $pair = 'Session ID ' . $value;
                    if($key=='name') $pair = 'Name ' . $value;
                    if($key=='message') $pair = 'Message ' . $value;
                    if($key=='org_id') $pair = 'Org ID ' . $value;
                    if($key=='call') $pair = 'Call ' . $value;
                    if($key=='response') $pair = 'Response ' . $value;
                    if($key=='response_code') $pair = 'Response Code ' . $value;
                    if($key=='parent_id') $pair = 'Parent ID ' . $value;
                    if($key=='action') $pair = 'Action ' . $value;
                    if($key=='ip_address') $pair = 'IP Address ' . $value;
                    if($key=='error_msg') $pair = 'Error Message ' . $value;
                    if($key=='size') $pair = 'Size ' . $value;
                    if($key=='attachment_types') $pair = 'Attachment Types ' . $value;
                    if($key=='sender') $pair = 'Sender ' . $value;
                    if($key=='recipient') $pair = 'Recipient ' . $value;
                    if($key=='U.username') $pair = 'Username ' . $value;
                    if($key=='M.name' || $key=='group_name') $pair = 'Group Name ' . $value;
                    if($key=='user_ext_mail') $pair = 'VA Email Address ' . $value;
                    if($key=='actor') $pair = 'Actor ' . $value;
                    if($key=='target') $pair = 'Target ' . $value;
                    if($key=='user_id') $pair = 'User ' . $value;
                    if($key=='is_active') {
                        if ($value == 'equals: 1') $pair = 'User Status: Active';
                        else $pair = 'User Status: Inactive';
                    }
                    $filters = $filters . ' ' . $pair . ', ';
                }
            }
        }
        if ($ldap!=null) {
            foreach ($ldap as $filter) {
                $filters = $filters . ' ' . $filter . ', ';
            }
        }
        foreach ($between as $key => $value){
            if($value['start']){
                $pair = 'Start date: ' . date('m/d/Y h:i:s A', $value['start']);
                $filters = $filters . ' ' . $pair . ', ';
            }
            if($value['end']){
                $pair = 'End date: ' . date('m/d/Y h:i:s A', $value['end']);
                $filters = $filters . ' ' . $pair . ', ';
            }
        }
        if($selected!=null){
            if (is_array($selected) && count($selected)>0) {
                foreach ($selected as $choice) {
                    if ($choice != null) {
                        $filters = $filters . ' ' . $choice . ', ';
                    }
                }
            }
            else {
                $filters = $filters . ' ' . $selected;
            }
        }
        if (mb_substr($filters, -2) ==", ") {
            $filters = mb_substr($filters, 0, -2);
        }
        
        if ($filters != ''){
            $filters_result = 'Active Filters: '.$filters;
            return $filters_result;
        } else {
            return $filters;
        }

        if (mb_strlen($filters) === 16){
            $filters = $filters.'None';
        }
        return $filters;

    }
    
    /**
    * Generate warning messages to be presented to users, based on the results of date validation.
    * 
    * Messsages fall into the following categories:
    *
    * 1. Either input date string is not considered valid by PHP function strtotime(). 
    * 2. Either input date string is not formatted as desired.
    * 3. Either input date string is valid and formatted well, but is either later than the current date/time, 
    *    or earlier than 01/01/2000 12:00:00 am EST.
    *
    * HTML list tags are added to warning messages.
    * 
    * Created for issue VAD-749, VAD-807 and VAD-812.
    * @author Harry Guo <guo_haoyu@ne.bah.com>
    */
    protected function get_paired_dates_filter_validation_message($start, $end) {
        $start = trim($start);
        $end = trim($end);
        $feedback_messages = array();
        
        if(empty($start) and empty($end)) return ''; //user isn't filtering by date; no validation message needed.
        
        foreach(array('start' => $start, 'end' => $end) as $field => $date_string) {
            //use the label for this field as the description
            $description = ucfirst($field).' Date'; 

            if(empty($date_string)){ 
                // Blank date provided. Report will be generated  without such date criteria.
                continue;
            }
            
            // Date not blank
            $date = $this->parse_date($date_string);

            if ( !$date || !$this->is_a_report_filter_date($date_string) ) {
                // Not blank but invalid or of unacceptable format
                // This includes the case that a year doesn't have 4 digits.
                $feedback_messages[] = 
                    'The value for the ' . $description .' field (' .$date_string . ') is invalid and will be ignored.  '     . 
                    'Dates should be formatted as MM/DD/YYYY or MM/DD/YYYY hh:mm:ss am/pm.  An optional U.S. '  .
                    'timezone abbreviation may be included (for example, EST).';
            }
            else {
                // Not blank and valid
                if ( $date < new DateTime('01/01/2000 12:00 AM EST') ) {
                    // Date before 01/01/2000 12:00 AM EST are changed to 
                    // 01/01/2000 12:00 AM EST
                    $feedback_messages[] = 
                        'The date provided for the '.$description.' field predates the Direct project.  01/01/2000 will be used instead.';                        
                }
                else if ( $date > new DateTime() ) {
			//If a future date is given for the start date, report will be generated with current date instead.  
			//Since we're actually changing the value in the form fields now, we'll display this message for end dates as well as start dates to prevent confusion.
			$feedback_messages[] = 'A future date was provided for the ' . $description . ' field. The current date will be used instead.';	
		}
            }
        }
   
	if(empty($feedback_messages)) return '';
        return ul_if_multiple($feedback_messages);        
    }
    
    //Setting Object to Array
    protected function object_to_array($object)
     {
      if (is_object($object))
      {
       // Gets the properties of the given object with get_object_vars function
       $object = get_object_vars($object);
      }
     
       return (is_array($object)) ? array_map(array($this,__FUNCTION__), $object) : $object;
     }
    //Setting Array to Object
    protected function array_to_object($array)
     {
      return (is_array($array)) ? (object) array_map(array($this,__FUNCTION__), $array) : $array;
     }

    protected function array_multi_search_filter( $array, $index, $pattern, $invert = FALSE ){
        $output = array();
        foreach ( $array as $i => $arr ){
            // The index must exist and match the pattern
            if ( isset( $arr[ $index ] ) && ( bool ) $invert !== ( bool ) preg_match( $pattern, $arr[ $index ] ) ){
                $output[ $i ] = $arr;
            }
        }
        return $output;
    }
    
#TODO - this should be a partial instead of a controller method	
    protected function create_tabs($selected){
    	$this->verify_access('reports');
        $html = '<a class="hidden_context hidden_link" id="skipReportMenu" href="#reportFilter" style="font-weight: normal;">Skip Report Menu</a>';
        $html .= '<ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">';
        foreach ($this->report_tabs as $key => $value){
            if($this->has_access('reports')){
                if(($key."_report") === $selected){
                    $html.= '<li class="reports-tab ui-state-default ui-corner-top ui-tabs-selected ui-state-active"><a href="/reports/'.$key.'">'.$value.'</a></li>';
                }else{
                    $html .= '<li class="reports-tab ui-state-default ui-corner-top"><a href="/reports/'.$key.'">'.$value.'</a></li>';
                }
                
            }
        }    
        $html .= '</ul>';
        $html .= '<a name="reportFilter" id="reportFilter" class="hidden_context hidden_link" style="font-weight: normal;">Report Filter</a>';
        $html .= '<a class="hidden_context hidden_link" id="skipReportFilter" href="#reportContent" style="font-weight: normal;">Skip Report Filter</a>';
        return $html;
    }
    
    protected function clear_cache() {
        header("Expires: ".gmdate("D, d M Y H:i:s", time())." GMT");
        header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
        header("Cache-Control: no-cache, must-revalidate");
        header("Pragma: no-cache");
    }
    
    /**
     * Save Adhoc Report
     */
    public function save_adhoc_report(){
    
        //Selecting Post Data
        $report_name = $this->input->post('report_name',TRUE);
        $report_description = $this->input->post('report_description',TRUE);
        $report_access = $this->input->post('report_access',TRUE);
        $adhoc_report_between = $this->input->post('adhoc_report_between',TRUE);
        $adhoc_report_selector = str_replace('###', '%', $this->input->post('adhoc_report_selector',TRUE));
        //$adhoc_report_selector = $this->json->decode($adhoc_report_selector);
        $adhoc_report_order = $this->input->post('adhoc_report_order',TRUE);
        $adhoc_report_direction = $this->input->post('adhoc_report_direction',TRUE);
        $adhoc_report_type = $this->input->post('adhoc_report_type',TRUE);
        $adhoc_report_start_date = $this->input->post('adhoc_report_start_date',TRUE);
        $adhoc_report_end_date = $this->input->post('adhoc_report_end_date',TRUE);
        $adhoc_report_selector_option = $this->input->post('adhoc_report_selector_option',TRUE);            
        $adhoc_report_time_field = $this->input->post('adhoc_report_time_field',TRUE);    
        $adhoc_report_id = $this->input->post('adhoc_report_id',TRUE);    
        //Setting view name to lower cases
        $view_result = mb_strtolower ($adhoc_report_type);
        
        //Getting username data
        $id = User::organization_id_from_session();
        $report_creator_id = $this->usersmodel->get_user_id_from_org_id($id); 
        $report_status = 0;
        if($this->is->nonzero_unsigned_integer($adhoc_report_id) && $this->adhoc_report_security_check($adhoc_report_id) !== FALSE){//if copied from another report
            $add_report = $this->adhocreportsmodel->copy_adhoc_report($adhoc_report_id ,$report_name, $report_description, $report_access, $report_creator_id, $report_status);
        }
        else{
            $add_report = $this->adhocreportsmodel->create_adhoc_report($report_name,$report_description,$report_access,$adhoc_report_between,$adhoc_report_selector,$adhoc_report_order,$adhoc_report_direction,$adhoc_report_type, $report_creator_id, $report_status, $adhoc_report_start_date, $adhoc_report_end_date, $adhoc_report_selector_option, $adhoc_report_time_field);
        }
        if($report_access == 'shared') {
            $report_id = $this->adhocreportsmodel->get_latest_report_id();
            $selected_group_names = $this->input->post('selected_group_names',TRUE);
            $selected_user_ids = $this->input->post('selected_user_ids',TRUE);
            
            $group_name_array = array();
            if($selected_group_names != null && $selected_group_names != '') {
                $group_name_array = explode(',', $selected_group_names);
            }
            $user_id_array = array();
            if($selected_user_ids != null && $selected_user_ids != '') {
                $user_id_array = explode(',', $selected_user_ids);
            }
            
            //add members in the groups in $user_id_array
            foreach($group_name_array as $group_name) {
                $members = $this->groupsmodel->get_members($group_name);
                foreach($members as $member) {
                    $member_id = $this->usersmodel->get_user_id_from_user_name($member);
                    array_push($user_id_array, $this->usersmodel->get_user_id_from_user_name($member));
                }
            }
            $has_report_been_shared_with_creator = false;
            $user_id_array = array_unique($user_id_array);
            foreach($user_id_array as $user_id) {
                $this->adhocreportsmodel->share_report($report_id, $user_id);
                if($report_creator_id == $user_id) {
                    $has_report_been_shared_with_creator = true;
                }
            }
            if(!$has_report_been_shared_with_creator) {
                $this->adhocreportsmodel->share_report($report_id, $report_creator_id);
            }
        }
        if($add_report == '1'){ 
            redirect('/reports/adhoc_reports/'.$report_access);
        }
        
    }

    
    public function get_adhoc_export_size($report_id = null, $is_ajax = null){
        if(empty($report_id)) {
            $report_id = $this->input->get('report_id',TRUE);
        }
        if(empty($is_ajax)) {
            $is_ajax = $this->input->get('is_ajax',TRUE);
        }
        $result_security = $this->adhoc_report_security_check($report_id);
        if($result_security === FALSE){
            show_404();
            return;
        }
        if(isset($_SERVER['HTTP_REFERER']) && strpos($_SERVER['HTTP_REFERER'], 'onboarding/banner') !== false) {
            redirect('reports/adhoc_reports');
        }
        //Select Report Information
        $adhoc_report = $this->adhocreportsmodel->get_adhoc_report_by_id($report_id)->result();
        //Report type
        if(!isset($adhoc_report[0])){
            show_404();
        }
        $report_type =  $adhoc_report[0]->report_type;
        $report_name =  $adhoc_report[0]->report_name;
        $timezone = $this->locale->timezone_abbr_from_name(date_default_timezone_get());
        //Filters
        $selected_filter_array = $this->adhocreportsmodel->get_selected_filter_array_from_db($adhoc_report[0]->report_selector);
        //Diff time period
        $diff_time_period =  $this->input->post('time_period',TRUE);
        $time_period_field = $adhoc_report[0]->report_time_field;
        $time_start_check =  $selected_filter_array['start_date'];
        $time_end_check =  $selected_filter_array['end_date'];
    
        if($diff_time_period != ''){
            //Calculate_new_dates
            $diff_period_start = $this->return_different_start_date($diff_time_period);
            $diff_period_end = $this->return_different_end_date($diff_time_period);
            $sql_query_generator_array = $adhoc_report[0]->report_query_generator;
    
            //Create new Query based on the different time selected
            $sql = $this->create_different_time_period_query($sql_query_generator_array,$time_start_check,$time_end_check,$time_period_field,$diff_period_start,$diff_period_end);
    
            //Date information
            $items = array();
            $start_date = date('m/d/Y h:i:s A',$diff_period_start);
            $end_date = date('m/d/Y h:i:s A',$diff_period_end);
            //$date_array = array($end_date, $start_date);
            $date_warning_message = $this->get_paired_dates_filter_validation_message($start_date, $end_date);
        } else {
            //calls helper to get data
            $sql = $adhoc_report[0]->report_query_generator;
    
            //Data information
            $items = array();
            $end_date =  $selected_filter_array['end_date'];
            $start_date =  $selected_filter_array['start_date'];
            //$date_array = array($end_date, $start_date);
            $date_warning_message = $this->get_paired_dates_filter_validation_message($start_date, $end_date);
        }
            
        //get direction (desc/asc)and if it is being exported
        $order = $adhoc_report[0]->report_order_by;
        $dir = $adhoc_report[0]->report_order_by_direction;
    
        //set options for comparing
        $data['compare'] = array(
                'equals' => 'Equals',
                'contains' => 'Contains',
                'starts' => 'Starts With',
                'ends' => 'Ends With'
        );
        //Set Export Data
        $data['timezone_abbr'] = $this->locale->timezone_abbr_from_name(date_default_timezone_get());
        $data['time'] = date('m/d/Y h:i:s A', time());
        $data['user'] = $this->session->userdata('user_info')['first_name']. ' ' .$this->session->userdata('user_info')['last_name'];
        $data['is_export'] = true;
        //Report Display type
        $size = 0;
	if(empty($sql) && in_array($report_type, array('logins', 'mail'))) $sql = array();
        switch ($report_type) {
            case 'requests':
            	$size = Request::count_for_reports($sql);
                break;
            case 'events':
				Event::db()->where($sql, NULL, FALSE); //TODO - refactor this so that we don't need to escape the SQL
                $size = Event::count();
                break;
            case 'logins':
            	$size = Authentication_log_entry::count_for_reports($sql);
                break;
            case 'mail':
            	$size = Mail_log_entry::count($sql);
                break;
            case 'user_activity_summary':
                //sql query that excludes the date filter to include users who had no acitivity during the time period specified
                $sql_date_filter_excluded = preg_replace('/AND \(ms.timestamp \<\= [0-9]{10}\)/' , '' , $sql);
                $sql_date_filter_excluded = preg_replace('/AND \(ms.timestamp \>\= [0-9]{10}\)/' , '' , $sql_date_filter_excluded);
                    
                $size = $this->useractivitysummarymodel->count($sql_date_filter_excluded);
                break;
            case 'group_activity_summary':
                //sql query that excludes the date filter to include users who had no acitivity during the time period specified
                $sql_date_filter_excluded = preg_replace('/AND \(ms.timestamp \<\= [0-9]{10}\)/' , '' , $sql);
                $sql_date_filter_excluded = preg_replace('/AND \(ms.timestamp \>\= [0-9]{10}\)/' , '' , $sql_date_filter_excluded);
                    
                $size = $this->groupsmodel->activity_summary_count($sql_date_filter_excluded);
                break;
            case 'facility':
                //getting size number
                $size = $this->facilitymodel->get_facility_list_size_reports_sql($sql)->result()[0]->count;
                break;
            case 'hisp':
                $between = array(
                'time' => $this->check_paired_dates($start_date,$end_date)
                );
                $items = array();
                $selected_domain = $selected_filter_array['selected_domain'];
                if (mb_strtolower($selected_domain) != "(ALL)"){
                    $selected = 'Domain: ' . $selected_domain;
                }else {
                            $selected =null;
                }
                $destination_page = $selected_filter_array['adhoc_report_destination_page'];
                $items_per_page = $selected_filter_array['adhoc_report_items_per_page'];
                $is_export = true;
    
                $message_counts = $this->hispmodel->get_message_counts_grouped_by_domain($selected_filter_array['selected_domain'], $between, $order, $dir, $destination_page, $items_per_page, $is_export);
                $size = count($message_counts);
                break;
            case 'points_of_origin':
                $between = array('call_date' => $this->check_paired_dates($start_date,$end_date));
                $application_id = $selected_filter_array['application_id'];
                $destination_page = $selected_filter_array['adhoc_report_destination_page'];
                $items_per_page = $selected_filter_array['adhoc_report_items_per_page'];
                $order = $adhoc_report[0]->report_order_by;
                $dir = $adhoc_report[0]->report_order_by_direction;
                $is_export = true;

                if ($application_id != "(all)"){
                    $selected = 'Application: ' . $this->applicationmodel->get_application_name_by_id($application_id)->result()[0]->name;
                }else {
                    $selected =null;
                    $application_id ="";
                }
                $message_counts = $this->pointsoforiginmodel->message_counts_by_application($application_id, $between, $order, $dir, $destination_page, $items_per_page, $is_export);
                $size = count($message_counts['list']);
                break;
            }
        $size_array = array('size'=>$size, 'report_name'=>$report_name);
        if($is_ajax == 'true' || $is_ajax == true) {
            echo $this->json->encode($size_array);
        }
        else {
            return $size_array;
        }
    }
        
    /**
     * Export Adhoc Report to PDF, Excel, and print
     */
    public function adhoc_export($report_id, $export_type){
    	$result_security = $this->adhoc_report_security_check($report_id);
    	if($result_security === FALSE){
    		show_404();
    		return;
    	}
    	if(isset($_SERVER['HTTP_REFERER']) && strpos($_SERVER['HTTP_REFERER'], 'onboarding/banner') !== false) {
    		redirect('reports/adhoc_reports');
    	}
    	//Select Report Information
    	$adhoc_report = $this->adhocreportsmodel->get_adhoc_report_by_id($report_id)->result();
    	//Report type
    	if(!isset($adhoc_report[0])){
    		show_404();
    	}
    	$report_type =  $adhoc_report[0]->report_type;
    	$report_name =  $adhoc_report[0]->report_name;
    	$timezone = $this->locale->timezone_abbr_from_name(date_default_timezone_get());
    	//Filters
    	$selected_filter_array = $this->adhocreportsmodel->get_selected_filter_array_from_db($adhoc_report[0]->report_selector);
    	//Diff time period
    	$diff_time_period =  $this->input->post('time_period',TRUE);
    	$time_period_field = $adhoc_report[0]->report_time_field;
    	$time_start_check =  $selected_filter_array['start_date'];
    	$time_end_check =  $selected_filter_array['end_date'];
    
    	if($diff_time_period != ''){
    		//Calculate_new_dates
    		$diff_period_start = $this->return_different_start_date($diff_time_period);
    		$diff_period_end = $this->return_different_end_date($diff_time_period);
    		$sql_query_generator_array = $adhoc_report[0]->report_query_generator;
    
    		//Create new Query based on the different time selected
    		$sql = $this->create_different_time_period_query($sql_query_generator_array,$time_start_check,$time_end_check,$time_period_field,$diff_period_start,$diff_period_end);
    
    		//Date information
    		$items = array();
    		$start_date = date('m/d/Y h:i:s A',$diff_period_start);
    		$end_date = date('m/d/Y h:i:s A',$diff_period_end);
    		//$date_array = array($end_date, $start_date);
    		$date_warning_message = $this->get_paired_dates_filter_validation_message($start_date, $end_date);
    	} else {
    		//calls helper to get data
    		$sql = $adhoc_report[0]->report_query_generator;
    
    		//Data information
    		$items = array();
    		$end_date =  $selected_filter_array['end_date'];
    		$start_date =  $selected_filter_array['start_date'];
    		//$date_array = array($end_date, $start_date);
    		$date_warning_message = $this->get_paired_dates_filter_validation_message($start_date, $end_date);
    	}
    		
    	//get direction (desc/asc)and if it is being exported
    	$order = $adhoc_report[0]->report_order_by;
    	$dir = $adhoc_report[0]->report_order_by_direction;
    
    	//set options for comparing
    	$data['compare'] = array(
    			'equals' => 'Equals',
    			'contains' => 'Contains',
    			'starts' => 'Starts With',
    			'ends' => 'Ends With'
    	);
    	//Set Export Data
    	$data['timezone_abbr'] = $this->locale->timezone_abbr_from_name(date_default_timezone_get());
    	$data['time'] = date('m/d/Y h:i:s A', time());
    	$data['user'] = $this->session->userdata('user_info')['first_name']. ' ' .$this->session->userdata('user_info')['last_name'];
    	$data['is_export'] = true;
    
		if(empty($sql) && in_array($report_type, array('logins', 'mail'))) $sql = array();
	
    	//Report Display type
    	switch ($report_type) {
    		case 'requests':
    			$selector = array(
    			'application_id' => $selected_filter_array['whichapp'],
    			);
    			$items = array(
    					'id' => $this->search_type($selected_filter_array['request_id'],$selected_filter_array['request_id_type']),
    					'call' => $this->search_type($selected_filter_array['request_call'],$selected_filter_array['request_call_type']),
    					'response_code' => $this->search_type($selected_filter_array['request_code'],$selected_filter_array['request_code_type']),
    					'response' => $this->search_type($selected_filter_array['request_response'],$selected_filter_array['request_response_type']),
    			);
    			$between = array(
    					'call_date' => $this->check_paired_dates($start_date,$end_date),
    			);
    			$selected = '';
    			if(strtoupper($selector['application_id']) != '(ALL)' && $selector['application_id'] != ''){
    				$selected = 'Application: ' . $this->applicationmodel->get_application_name_by_id($selected_filter_array['whichapp'])->result()[0]->name;
    			}
    
    			$data['filters'] = $this->export_info($items,$between,$selected,null);
    
				$size = Request::count_for_reports($sql);
    				
				if(string_contains('id', $order)){
					$order = preg_replace('/[^a-zA-Z0-9_\.]id[^a-zA-Z0-9_-]/', 'request.id', str_replace('application_id', 'application.name', $order));
				}
				Request::db()->order_by($order, $dir);
				$responses_list = Request::find_for_reports($sql);

    			$data['export_request_list'] = $responses_list;
    			break;
    		case 'events':
    			$selector = array(
    			'success' =>  $selected_filter_array['successful'],
    			);
    				
    			$items = array(
    					'id' => $this->search_type($selected_filter_array['event_id'],$selected_filter_array['event_id_type']),
    					'action' => $this->search_type($selected_filter_array['action'],$selected_filter_array['action_type']),
    			);
    			$extra_items = array(
    					'id' => $this->search_type($selected_filter_array['event_id'],$selected_filter_array['event_id_type']),
    					'action' => $this->search_type($selected_filter_array['action'],$selected_filter_array['action_type']),
    					'actor' => $this->search_type($selected_filter_array['acting_user'],$selected_filter_array['acting_user_type']),
    					'target' => $this->search_type($selected_filter_array['target_user'],$selected_filter_array['target_user_type']),
    			);
    			//$date_array = array($end_date, $start_date);
    			$date_warning_message = $this->get_paired_dates_filter_validation_message($start_date, $end_date);
    				
    			$between = array(
    					'event_date' => $this->check_paired_dates($start_date,$end_date),
    			);
    				
    			$typesearch = array (
    					'actor_id'	=> array (
    							'typesql' => 'actor_type',
    							'name' => $this->search_type($selected_filter_array['acting_user'],$selected_filter_array['acting_user_type']),
    							'type' => $selected_filter_array['acting_type'],
    					),
    					'target_id' => array(
    							'typesql' => 'target_type',
    							'name' => $this->search_type($selected_filter_array['target_user'],$selected_filter_array['target_user_type']),
    							'type' => $selected_filter_array['target_type'],
    					),
    			);
    			$destination_page = $selected_filter_array['adhoc_report_destination_page'];
    			$items_per_page = $selected_filter_array['adhoc_report_items_per_page'];
    				
    			$order = $adhoc_report[0]->report_order_by;
    			$dir = $adhoc_report[0]->report_order_by_direction;
    			$selected = array();
    			if($selector['success'] == 1) { array_push($selected, 'Success: True'); }
    			else if(strtoupper($selector['success']) == '(ALL)') { array_push($selected, null); }
    			else { array_push($selected, 'Success: False'); }
    			if(isset($typesearch['actor_id']['type']) && strtoupper($typesearch['actor_id']['type']) == '(ALL)') array_push($selected, null);
    			else { array_push($selected, 'Actor Type: '. $this->get_type($typesearch['actor_id']['type'])); }
    			if(isset($typesearch['target_id']['type']) && strtoupper($typesearch['target_id']['type']) == '(ALL)') { array_push($selected, null); }
    			else { array_push($selected, 'Target Type: '. $this->get_type($typesearch['target_id']['type'])); }
    				
    			$data['filters'] = $this->export_info($extra_items, $between, $selected, null);
    			$data['is_export'] = true;
			Event::db()->where($adhoc_report[0]->report_query_generator, NULL, FALSE); //TODO - refactor this so that we don't need to escape the SQL
			$size = Event::count();
    				
    			$response_export = $this->reports_helper('event',$items,$between,$selector,$typesearch,$order,$dir,$destination_page,true,$size);
    			$response_export_list = $response_export['response'];
    			foreach($response_export_list as $event) {
    				//converts actor and target ids into their display names
    				$value = $this->id_to_name($event->actor_type,$event->actor_id);
    				$event->actor_type=$value['type'];
    				$event->actor_id=$value['id'];
    				$value = $this->id_to_name($event->target_type,$event->target_id);
    				$event->target_type=$value['type'];
    				$event->target_id=$value['id'];
    				//changes success integer into true, false or unauth
    				if($event->success === 1) { $event->success = 'TRUE'; }
    				else if($event->success === 2){ $event->success = 'UNAUTH'; }
    				else{ $event->success = 'FALSE'; }
    				//change date into readable
    				$event->event_date = date('m/d/Y h:i:s A',$event->event_date);
    			}
    			$data['export_event_list'] = $response_export_list;
    			break;
    		case 'logins':
    			//adds each component type into its own json
    			$selector = array(
    			'success' =>  $selected_filter_array['successful'],
    			);
    				
    			$items = array(
    					'id' => $this->search_type($selected_filter_array['id'],$selected_filter_array['id_type']),
    					'session_id'=>$this->search_type($selected_filter_array['session_id'],$selected_filter_array['session_id_type']),
    					'ip_address'=>$this->search_type($selected_filter_array['ip_address'],['ip_address_type']),
    					'error_msg'=>$this->search_type($selected_filter_array['message'],$selected_filter_array['message_type']),
    					'org_id'=>$this->search_type($selected_filter_array['org_id'],$selected_filter_array['org_id_type']),
    			);
    				
    			//Date Date
    			$between = array(
    					'login_time' => $this->check_paired_dates($start_date,$end_date)
    			);
    				
    			//$date_array = array($end_date, $start_date);
    			$date_warning_message = $this->get_paired_dates_filter_validation_message($start_date, $end_date);
    			$size = Authentication_log_entry::count_for_reports($sql);
    			//get direction and orders
    			$dir = $adhoc_report[0]->report_order_by_direction;
    			$order = $adhoc_report[0]->report_order_by;
    			//get export data
    			if(string_begins_with('id', $order)) $order = 'id '.$dir;
    			Authentication_log_entry::db()->order_by($order);
    			$responses_list = Authentication_log_entry::find_for_reports($sql);
    			//Export Variables
    			$data['timezone_abbr'] = $this->locale->timezone_abbr_from_name(date_default_timezone_get());
    			$data['time'] = date('m/d/Y h:i:s A', time());
    			$data['user'] = $this->session->userdata('user_info')['first_name']. ' ' .$this->session->userdata('user_info')['last_name'];
    			$data['is_export'] =  TRUE;
    
    			if(strtoupper($selected_filter_array['successful'])=='(ALL)') {
    				$selected = '';
    			}
    			else if($selected_filter_array['successful']==1) {
    				$selected='Success: True';
    			}
    			else {
    				$selected='Success: False';
    			}
    			$data['filters'] = $this->export_info($items,$between,$selected,null);
    			#TODO - why do we even put this in the $data array if we don't use it except for this next loop?
    			$data['export_login_list'] = $responses_list;

    			foreach($data['export_login_list'] as $login) {
    				//get binary true/false into text
    				if($login->success === 1) { $login->success = 'TRUE'; }
    				else { $login->success = 'FALSE'; }
    			}

    			$report_content = $this->input->post('report_content',TRUE);
    			break;
			case 'mail':
    			$selector = array(
    					'success' =>  $selected_filter_array['successful'],
    					'mdn' =>  $selected_filter_array['mdn'],
    					'inbound_outbound' => $selected_filter_array['bound'],
    					'protected_data' => $selected_filter_array['protected_data']
    					);
			
				$items = array(
    					'id' => $this->search_type($selected_filter_array['id'],$selected_filter_array['id_type']),
    					'size'=>$this->search_type($selected_filter_array['file_size'],$selected_filter_array['file_size_type']),
    					'attachment_types'=>$this->search_type($selected_filter_array['attachment_type'],$selected_filter_array['attachment_type_type']),
    					'sender'=>$this->search_type($selected_filter_array['sender'],$selected_filter_array['sender_type']),
    					'recipient'=>$this->search_type($selected_filter_array['recipient'],$selected_filter_array['recipient_type']),
    					);
    						
				//$date_array = array($end_date, $start_date);
    					$date_warning_message = $this->get_paired_dates_filter_validation_message($start_date, $end_date);
    						
    					$between = array(
    					'time' => $this->check_paired_dates($start_date,$end_date)
    					);
    					$typesearch = array (
    					);
    					$items_per_page = $selected_filter_array['items_per_page'];
    					$export_pdf = $this->input->post('export_pdf',TRUE);
    					$print_page = $this->input->post('print_page',TRUE);
				$is_export = TRUE;
    						
    					$data['is_export'] = $is_export;
    								
    					$dir = $adhoc_report[0]->report_order_by_direction;
    					$order = $adhoc_report[0]->report_order_by;
    					$page=1;
    					Mail_log_entry::db()->where($sql)->order_by($order)->limit($items_per_page,$page);
    					$responses_list = Mail_log_entry::find();
    					$mail_list = $responses_list;
    					$form_data['direction'] = $dir;
    					$form_data['date_warning_message'] = $date_warning_message;
    					$size = Mail_log_entry::count($sql);
    					$destination_page = 1;
    					$response_export = $this->reports_helper('mail',$items,$between,$selector,$typesearch,$adhoc_report[0]->report_order_by,$dir,$destination_page,$is_export,$size);
    					$response_export_list = $response_export['response'];
    					$selected ="";
    					$data['filters'] = $this->export_info($items,$between,$selected,null);
    					$response_adhoc = $responses_list;
    					$form_data['order'] = $order;
    					//converts application's numbers into their names
    					$lists = array($mail_list, $response_export_list);
    					foreach($lists as $list) {
    						if(isset($list)) {
    							foreach($list as $event) {
    								//get the recipients and convert to array
    								$event->recipient=$this->json->decode($event->recipient);
    								$recip = '';
    								if(isset($event->recipient)){
    									foreach($event->recipient as $key =>$value){
    										//for all items after the first
    										if($key > 0) {
    											//if export make them comma separated
    											if($is_export) { $recip .= ', '; }
    											//else when in view make each email on a line
    											else { $recip.= '<br/>'; }
    										}
    										$recip .= $value; //add email
    									}
    								}
    								$event->recipient = $recip;
    
    								//binary true/false into text
    								if($event->success) { $event->success = 'TRUE'; }
    								else { $event->success = 'FALSE'; }
    
    								//binary mdn into text
    								if($event->mdn) { $event->mdn = 'TRUE'; }
    								else { $event->mdn = 'FALSE'; }
    
    								//binary inbound/outbound into text
    								if($event->inbound_outbound){ $event->inbound_outbound = 'Inbound'; }
    								else { $event->inbound_outbound = 'Outbound'; }
    								$event->time = date("m/d/Y h:i:s A",$event->time);
    									
    								//binary 7332 into text
    								if($event->protected_data) { $event->protected_data = 'TRUE'; }
    								else if($event->protected_data === 0) { $event->protected_data = 'FALSE'; }
    								else{ $event->protected_data = 'N/A'; }
    							}
    						}
    					}
    					//Export Variables
    					$data['timezone_abbr'] = $this->locale->timezone_abbr_from_name(date_default_timezone_get());
    					$data['time'] = date('m/d/Y h:i:s A', time());
    					$data['user'] = $this->session->userdata('user_info')['first_name']. ' ' .$this->session->userdata('user_info')['last_name'];
    					$data['form_data'] = $form_data;
    					$data['event_list'] = $event_list = $response_export_list;
    					$data['export_mail_list'] = $event_list;
    					$report_content = $this->input->post('report_content',FALSE);
    					break;
    			case 'user_activity_summary':
    				//sql query that excludes the date filter to include users who had no acitivity during the time period specified
    				$sql_date_filter_excluded = preg_replace('/AND \(ms.timestamp \<\= [0-9]{10}\)/' , '' , $sql);
    				$sql_date_filter_excluded = preg_replace('/AND \(ms.timestamp \>\= [0-9]{10}\)/' , '' , $sql_date_filter_excluded);
    				//Set Variables
    				$page = 1;
    				$items_per_page =  $selected_filter_array['items_per_page'];
    				$order_search = $adhoc_report[0]->report_order_by ." " .$adhoc_report[0]->report_order_by_direction.",id ".$adhoc_report[0]->report_order_by_direction;
    				$order = $adhoc_report[0]->report_order_by;
    				$dir = $adhoc_report[0]->report_order_by_direction;
    				//Get Data
    				$size = $this->useractivitysummarymodel->count($sql_date_filter_excluded);
    				$users_facility_list = $this->useractivitysummarymodel->get_request_filter_user_activities($sql,$sql_date_filter_excluded,$order_search,$this->db->escape($page),$items_per_page);
    				//Get LDAP Information
    				$counter = 0;
    				$SummaryListing = array();
    				//merge arrays
    				foreach ($users_facility_list as $userInfo){
    					//print_r($userInfo);
    					$userUsername = $userInfo->Username;
    					$userID = $userInfo->id;
    					$userFacilityName = $userInfo->Name;
    					$userNumber_of_sent = $userInfo->Number_of_sent;
    					$userNumber_of_seen = $userInfo->Number_of_seen;
    					$userTotal_of_messages = $userInfo->Total_messages;
    					$user_ext_mail = $userInfo->user_ext_mail;
    					$userIsActive = $userInfo->is_active;
    					//Get LDAP Information
    					$resultArray = $this->useractivitysummarymodel->get_ldap_request($userInfo->Username);
    
    					//checking that LDAP Results are not null
    					if (isset ($resultArray[0]['givenname'][0])){
    						$userGivenname = $resultArray[0]['givenname'][0];
    					}else{
    						$userGivenname = "not found";
    					}
    
    					if (isset ($resultArray[0]['sn'][0])){
    						$userSN = $resultArray[0]['sn'][0];
    					}else{
    						$userSN = "not found";
    					}
    
    					if (isset ($resultArray[0]['mail'][0])){
    						$userMail = $resultArray[0]['mail'][0];
    					}else{
    						$userMail = "not found";
    					}
    
    					if($userIsActive == 1){
    						$userActiveText = 'Active';
    					} else {
    						$userActiveText = 'Inactive';
    					}
    					$SummaryListingObjects = new stdClass;
    					$SummaryListingObjects->userSN = $userSN;
    					$SummaryListingObjects->userGivenname = $userGivenname;
    					$SummaryListingObjects->username = $userUsername;
    					$SummaryListingObjects->userMail = $userMail;
    					$SummaryListingObjects->facilityName = $userFacilityName;
    					$SummaryListingObjects->userStatus = $userActiveText;
    					$SummaryListingObjects->user_ext_mail = $user_ext_mail;
    					$SummaryListingObjects->userNumber_of_sent = $userNumber_of_sent;
    					$SummaryListingObjects->userNumber_of_seen = $userNumber_of_seen;
    					$SummaryListingObjects->userTotal_of_messages = $userTotal_of_messages;
    					array_push($SummaryListing, $SummaryListingObjects);
    				}
    				//Sorting results
    				$ldapfilters = array();
    				//Converting to array for sorting
    				$new_array = $this->object_to_array($SummaryListing);
    				//filter_sn
    				$sn_filter =  $selected_filter_array['txtsn'];
    				if($sn_filter != ""){
    					$sn_filter_type =  $selected_filter_array['last_name_type'];
    					array_push($ldapfilters, 'Last Name ' . mb_strtolower($data['compare'][$sn_filter_type]). ': ' . $sn_filter);
    					//setting filter type
    					$search_sn = $this->search_type_for_array($sn_filter,$sn_filter_type);
    					//Search on array for true values
    					$new_array = $this->array_multi_search_filter($new_array, 'userSN', $search_sn);
    				}
    				//filter_given_name
    				$givenname_filter =  $selected_filter_array['txtgivenname'];
    				if($givenname_filter != ""){
    					$givenname_filter_type =  $selected_filter_array['first_name_type'];
    					array_push($ldapfilters, 'First Name ' . mb_strtolower($data['compare'][$givenname_filter_type]). ': ' . $givenname_filter);
    					//setting filter type
    					$search_givenname = $this->search_type_for_array($givenname_filter,$givenname_filter_type);
    					//Search on array for true values
    					$new_array = $this->array_multi_search_filter($new_array, 'userGivenname', $search_givenname);
    				}
    				//filter_va_address
    				$direct_address_filter =  $selected_filter_array['txtdirectaddress'];
    				if($direct_address_filter != ""){
    					$direct_address_filter_Type =  $selected_filter_array['direct_address_type'];
    					array_push($ldapfilters, 'Direct Address ' . mb_strtolower($data['compare'][$direct_address_filter_Type]). ': ' . $direct_address_filter);
    					//setting filter type
    					$search_direct_address = $this->search_type_for_array($direct_address_filter,$direct_address_filter_Type);
    					//Search on array for true values
    					$new_array = $this->array_multi_search_filter($new_array, 'userMail', $search_direct_address);
    				}
    
    				$destination_page = 1;
    				unset($SummaryListing);
    				$SummaryListing = $this->array_to_object(array_slice($new_array, ($destination_page-1)*ITEMS_PER_PAGE_DEFAULT, $size));
    
    				//Export Variables
    				$data['timezone_abbr'] = $this->locale->timezone_abbr_from_name(date_default_timezone_get());
    				$data['time'] = date('m/d/Y h:i:s A', time());
    				$data['user'] = $this->session->userdata('user_info')['first_name']. ' ' .$this->session->userdata('user_info')['last_name'];
    				$between = array(
    						'ms.timestamp' => $this->check_paired_dates($start_date,$end_date),
    				);
    				//$summary_listing_totals = $SummaryListing;
    				$selected = "";
    				if(mb_strtolower($selected_filter_array['facility_id']) != "(all)" &&  $selected_filter_array['facility_id'] != ''){
    					$selected = 'Facility: ' . $this->facilitymodel->get_facility( $selected_filter_array['facility_id'])->result()[0]->name;
    				}
    				//Set Export
    				$data['filters'] = $this->export_info($items,$between,$selected,$ldapfilters);
    				$data['export_summary_list'] = $SummaryListing;
    				$data['is_export'] =  TRUE;
    				break;
    			case 'group_activity_summary':
    				//Set Variables
    				$page = 1;
    				$items_per_page =  $selected_filter_array['items_per_page'];
    				$order_search = $adhoc_report[0]->report_order_by ." " .$adhoc_report[0]->report_order_by_direction.",id ".$adhoc_report[0]->report_order_by_direction;
    				$order = $adhoc_report[0]->report_order_by;
    				$dir = $adhoc_report[0]->report_order_by_direction;
    				//Get Data
    				//sql query that excludes the date filter to include groups who had no acitivity during the time period specified
    				$sql_date_filter_excluded = preg_replace('/AND \(ms.timestamp \<\= [0-9]{10}\)/' , '' , $sql);
    				$sql_date_filter_excluded = preg_replace('/AND \(ms.timestamp \>\= [0-9]{10}\)/' , '' , $sql_date_filter_excluded);
    
    				$size = $this->groupsmodel->activity_summary_count($sql_date_filter_excluded);
    				$groups_activity_list = $this->groupsmodel->get_request_filter_group_activities($sql,$sql_date_filter_excluded,$order_search,$this->db->escape($page),$items_per_page);
    				//Get LDAP Information
    				$counter = 0;
    				$SummaryListing = array();
    				$items = array(
    						'group_name' => $this->search_type($selected_filter_array['group_name'],$selected_filter_array['group_name_type']),
    				);
    				//merge arrays
    				foreach ($groups_activity_list as $group_info){
    					//print_r($group_info);
    					$groupName = $group_info->group_name;
    					$groupID = $group_info->id;
    					$groupFacilityName = $group_info->Name;
    					$groupNumber_of_sent = $group_info->Number_of_sent;
    					$groupNumber_of_seen = $group_info->Number_of_seen;
    					$groupTotal_of_messages = $group_info->Total_messages;
    					$groupIsActive = $group_info->is_active;
    					//Get LDAP Information
    					$resultArray = $this->groupsmodel->get_ldap_request($groupName);
    						
    					//checking that LDAP Results are not null
    					if (isset ($resultArray[0]['cn'][0])){
    						$displayName = $resultArray[0]['cn'][0];
    					}else{
    						$displayName = "not found";
    					}
    						
    					if (isset ($resultArray[0]['mail'][0])){
    						$groupMail = $resultArray[0]['mail'][0];
    					}else{
    						$groupMail = "not found";
    					}
    						
    					if($groupIsActive == 1){
    						$groupActiveText = 'Active';
    					} else {
    						$groupActiveText = 'Inactive';
    					}
    					$SummaryListingObjects = new stdClass;
    					$SummaryListingObjects->groupName = $groupName;
    					$SummaryListingObjects->displayName = $displayName;
    					$SummaryListingObjects->groupMail = $groupMail;
    					$SummaryListingObjects->facilityName = $groupFacilityName;
    					$SummaryListingObjects->groupStatus = $groupActiveText;
    					$SummaryListingObjects->groupNumber_of_sent = $groupNumber_of_sent;
    					$SummaryListingObjects->groupNumber_of_seen = $groupNumber_of_seen;
    					$SummaryListingObjects->groupTotal_of_messages = $groupTotal_of_messages;
    					array_push($SummaryListing, $SummaryListingObjects);
    				}
    				//Sorting results
    				$ldapfilters = array();
    				//Converting to array for sorting
    				$new_array = $this->object_to_array($SummaryListing);
    					
    				//filter_va_address
    				$direct_address_filter =  $selected_filter_array['txtdirectaddress'];
    				if($direct_address_filter != ""){
    					$direct_address_filter_Type =  $selected_filter_array['direct_address_type'];
    					array_push($ldapfilters, 'Direct Address ' . mb_strtolower($data['compare'][$direct_address_filter_Type]). ': ' . $direct_address_filter);
    					//setting filter type
    					$search_direct_address = $this->search_type_for_array($direct_address_filter,$direct_address_filter_Type);
    					//Search on array for true values
    					$new_array = $this->array_multi_search_filter($new_array, 'groupMail', $search_direct_address);
    				}
    
    				$destination_page = 1;
    				unset($SummaryListing);
    				$SummaryListing = $this->array_to_object(array_slice($new_array, ($destination_page-1)*ITEMS_PER_PAGE_DEFAULT, $size));
    					
    				//Export Variables
    				$data['timezone_abbr'] = $this->locale->timezone_abbr_from_name(date_default_timezone_get());
    				$data['time'] = date('m/d/Y h:i:s A', time());
    				$data['group'] = $this->session->userdata('user_info')['first_name']. ' ' .$this->session->userdata('user_info')['last_name'];
    				$between = array(
    						'ms.timestamp' => $this->check_paired_dates($start_date,$end_date),
    				);
    
    				if(mb_strtolower($selected_filter_array['group_status_type']) == '(all)'){
    					$selected = "";
    				}
    				if($selected_filter_array['group_status_type'] == '1'){
    					$selected = 'Group Status: Active, ';
    				}
    				else {
    					$selected = 'Group Status: Inactive, ';
    				}
    
    				if(mb_strtolower($selected_filter_array['facility_id']) != "(all)" &&  $selected_filter_array['facility_id'] != ''){
    					$selected .= 'Facility: ' . $this->facilitymodel->get_facility( $selected_filter_array['facility_id'])->result()[0]->name;
    				}
    				//Set Export
    				$data['filters'] = $this->export_info($items,$between,$selected,$ldapfilters);
    				$data['export_summary_list'] = $SummaryListing;
    				$data['is_export'] =  TRUE;
    				break;
    			case 'facility':
    				//getting size number
    				$size = $this->facilitymodel->get_facility_list_size_reports_sql($sql)->result();
    				$size = $size[0]->count;
    				$page = 1;
    				$items = array();
    				$destination_page = $page;
    				$items_per_page = $size;

    				// Generating PDF Data
                    $total_size = $this->facilitymodel->get_facility_list_size_reports()->result();
                    $total_size = $total_size[0]->count;
                    $va_totals = new StdClass;
                    $va_totals->totalUsers = 0;
                    $va_totals->totalGroup = 0;
                    $va_totals->totalSent = 0;
                    $va_totals->totalMessages = 0;
                    $va_totals->totalReceived = 0;
                    $facility_list_totals = $this->facilitymodel->get_first_facilities($total_size)->result();
                    foreach( $facility_list_totals as $requests ) {
                        $va_totals->totalUsers      += $requests->Number_of_users;
                        $va_totals->totalGroup      += $requests->Number_in_group;
                        $va_totals->totalSent       += $requests->Number_of_sent;
                        $va_totals->totalMessages   += $requests->Total_messages - $requests->Number_of_drafts;
                    }

                    $va_totals->totalReceived   = $va_totals->totalMessages - $va_totals->totalSent;
                    $data['va_totals'] = $va_totals;


                    $facility_list = $this->facilitymodel->get_request_filter_facility_order($sql,$order,$this->db->escape($page),$this->db->escape($items_per_page))->result();
    				//$facility_list = $response_export_list;
    				$selector = $selected_filter_array['facility_id'];
    
    				//Setting Extra Export Info
    				$between = array(
    						'ms.timestamp' => $this->check_paired_dates($start_date,$end_date),
    				);
    				if($selector != '(all)' && $selector != ''){
    					$selected = 'Facility: ' . $this->facilitymodel->get_facility( $selected_filter_array['facility_id'])->result()[0]->name;
    				} else {
    					$selected = 'Facility: (ALL)';
    				}
    				$data['timezone_abbr'] = $this->locale->timezone_abbr_from_name(date_default_timezone_get());
    				$data['time'] = date('m/d/Y h:i:s A', time());
    				$data['user'] = $this->session->userdata('user_info')['first_name']. ' ' .$this->session->userdata('user_info')['last_name'];
    				$data['filters'] = $this->export_info($items,$between,$selected,null);
    					
    				//Getting_totals
    				$data['export_facility_list'] = $facility_list;
    				$data['is_export'] =  TRUE;
    				break;
    			case 'hisp':
    				$between = array(
    				'time' => $this->check_paired_dates($start_date,$end_date)
    				);
    				$items = array();
    				$selected_domain = $selected_filter_array['selected_domain'];
    				if (mb_strtolower($selected_domain) != "(ALL)"){
    					$selected = 'Domain: ' . $selected_domain;
    				}else {
    					$selected =null;
    				}
    				$destination_page = $selected_filter_array['adhoc_report_destination_page'];
    				$items_per_page = $selected_filter_array['adhoc_report_items_per_page'];
    				$is_export = true;
    				if($export_type == 'excel') {
    					$is_export = 'excel';
    				}
    				$message_counts = $this->hispmodel->get_message_counts_grouped_by_domain($selected_filter_array['selected_domain'], $between, $order, $dir, $destination_page, $items_per_page, $is_export);
    					
    				$data['is_export'] = $is_export;
    				$data['message_counts'] = $message_counts['list'];
    				$size = count($message_counts['list']);
    				$data['filters'] = $this->export_info(null,$between,$selected,null);
    				break;
    			case 'points_of_origin':
    				$between = array(
    				'call_date' => $this->check_paired_dates($start_date,$end_date)
    				);
    				$application_id = $selected_filter_array['application_id'];
    				$destination_page = $selected_filter_array['adhoc_report_destination_page'];
    				$items_per_page = $selected_filter_array['adhoc_report_items_per_page'];
    				$order = $adhoc_report[0]->report_order_by;
    				$dir = $adhoc_report[0]->report_order_by_direction;
    				$is_export = true;
    
    				if ($application_id != "(all)"){
    					$selected = 'Application: ' . $this->applicationmodel->get_application_name_by_id($application_id)->result()[0]->name;
    				}else {
    					$selected =null;
    					$application_id ="";
    				}
    
    				$message_counts = $this->pointsoforiginmodel->message_counts_by_application($application_id, $between, $order, $dir, $destination_page, $items_per_page, $is_export);
    				$size = count($message_counts['list']);
    				$data['filters'] = $this->export_info(null,$between,$selected,null);
    				$data['is_export'] =  TRUE;
    				$data['message_counts'] = $message_counts['list'];
    				break;
    			}
    			if($export_type === 'pdf') {
    				$html = $this->load->view('api/reports/result_tables/result_' . $report_type, $data, true);
    				$this->export_pdf($report_name.'.pdf', $html, $report_id, $size);
    			}
    			else if($export_type === 'html') {
    				$export_array = ['html' => $this->load->view('api/reports/result_tables/result_' . $report_type, $data, true),
    				'report_id' => $report_id,
    				'report_name'=> $report_name];
    				return $export_array;
    			}
    			else if($export_type === 'excel' || $export_type === 'excel_to_file') {
    				switch($report_type) {
    					case 'requests':
    						if($export_type === 'excel') {
    							$this->export(array('ID','Application','Call','Date ('.$timezone.')','Response Code','Response'),$responses_list,$report_name,$items,$between,$selected,null,$report_id,$size);
    							break;
    						}
    						else {
    							return $this->export(array('ID','Application','Call','Date ('.$timezone.')','Response Code','Response'),$responses_list,$report_name,$items,$between,$selected,null,$report_id,$size, true);
    						}
    					case 'events':
    						if($export_type === 'excel') {
    							$this->export(array('ID','Target Type','Target','Actor Type','Actor','Action','Date ('.$data['timezone_abbr'].')','Success'),$data['export_event_list'],$report_name,$extra_items,$between,$selected,null,$report_id,$size);
    							break;
    						}
    						else {
    							return $this->export(array('ID','Target Type','Target','Actor Type','Actor','Action','Date ('.$data['timezone_abbr'].')','Success'),$data['export_event_list'],$report_name,$extra_items,$between,$selected,null,$report_id,$size,true);
    						}
    					case 'mail':
    						if($export_type === 'excel') {
    							$this->export(array('ID','Date ('.$data['timezone_abbr'].')','Size(KB)','Sender','Recipient','Attachment Type','Success', 'Direction','MDN','7332'),$data['export_mail_list'],$report_name,$items,$between,null,null,$report_id,$size);

    							break;
    						}
    						else {
    							return $this->export(array('ID','Date ('.$data['timezone_abbr'].')','Size(KB)','Sender','Recipient','Attachment Type','Success', 'Direction','MDN','7332'),$data['export_mail_list'],$report_name,$items,$between,null,null,$report_id,$size,true);
    						}
    					case 'logins':
    						if($export_type === 'excel') {
    							$this->export(array('ID','Session ID','IP Address','Date ('.$data['timezone_abbr'].')','Message','Org ID','Success','Username'),collect('values_for_export', $responses_list),$report_name,$items,$between,$selected,null,$report_id,$size);
    							break;
    						}
    						else {
    							return $this->export(array('ID','Session ID','IP Address','Date ('.$data['timezone_abbr'].')','Message','Org ID','Success','Username'),$responses_list,$report_name,$items,$between,$selected,null,$report_id,$size,true);
    						}
    					case 'user_activity_summary':
    						$totalCount = count((array)$SummaryListing);
    						$newRowNumber = $totalCount + 1;
    						$SummaryListing->$totalCount = new StdClass;
    						$SummaryListing->$totalCount->userSN = '';
    						$SummaryListing->$totalCount->userGivenname = '';
    						$SummaryListing->$totalCount->username = '';
    						$SummaryListing->$totalCount->userMail = '';
    						$SummaryListing->$totalCount->facilityName = '';
    						$SummaryListing->$totalCount->userStatus = '';
    						$SummaryListing->$totalCount->user_ext_mail = 'VA Total:';
    						$SummaryListing->$totalCount->userNumber_of_sent = $this->sum_by_object_name((array)$SummaryListing, 'userNumber_of_sent');
    						$SummaryListing->$totalCount->userNumber_of_seen = $this->sum_by_object_name((array)$SummaryListing, 'userNumber_of_seen');
    						$SummaryListing->$totalCount->userTotal_of_messages = $this->sum_by_object_name((array)$SummaryListing, 'userTotal_of_messages');
    
    						if($export_type === 'excel') {
    							$this->export(array('Last Name', 'First Name','Username','Direct Address','VA Facility','User Status', 'VA email Address', 'Total Messages Sent', 'Total Messages Received', 'Total Messages'),$SummaryListing,$report_name,$items,$between,$selected,$ldapfilters,$report_id,$size);
    							break;
    						}
    						else {
    							return $this->export(array('Last Name', 'First Name','Username','Direct Address','VA Facility','User Status', 'VA email Address', 'Total Messages Sent', 'Total Messages Received', 'Total Messages'),$SummaryListing,$report_name,$items,$between,$selected,$ldapfilters,$report_id,$size,true);
    						}
    					case 'group_activity_summary':
    						$totalCount = count((array)$SummaryListing);
    						$newRowNumber = $totalCount + 1;
    						$SummaryListing->$totalCount = new StdClass;
    						$SummaryListing->$totalCount->groupName = '';
    						$SummaryListing->$totalCount->displayName = '';
    						$SummaryListing->$totalCount->groupMail = '';
    						$SummaryListing->$totalCount->facilityName = '';
    						$SummaryListing->$totalCount->groupStatus = 'VA Total:';
    						$SummaryListing->$totalCount->groupNumber_of_sent = $this->sum_by_object_name((array)$SummaryListing, 'groupNumber_of_sent');
    						$SummaryListing->$totalCount->groupNumber_of_seen = $this->sum_by_object_name((array)$SummaryListing, 'groupNumber_of_seen');
    						$SummaryListing->$totalCount->groupTotal_of_messages = $this->sum_by_object_name((array)$SummaryListing, 'groupTotal_of_messages');
    
    						if($export_type === 'excel') {
    							$this->export(array('Group Name','Display Name','Direct Address','VA Facility','Group Status', 'Total Messages Sent', 'Total Messages Received', 'Total Messages'),$SummaryListing,$report_name,$items,$between,$selected,$ldapfilters,$report_id,$size);
    							break;
    						}
    						else {
    							return $this->export(array('Group Name','Display Name','Direct Address','VA Facility','Group Status', 'Total Messages Sent', 'Total Messages Received', 'Total Messages'),$SummaryListing,$report_name,$items,$between,$selected,$ldapfilters,$report_id,$size,true);
    						}
    					case 'facility':
    						// Generating Excel Data
    						//$response_export_list = $this->facilitymodel->get_request_filter_facility_order($sql,$order.' '.$dir,$this->db->escape($page),$this->db->escape($items_per_page))->result();
    						//$facility_list = $response_export_list;
    						//Setting Totals for Excel Export
    						$totalCount = count((array)$facility_list);
    						//Unset Row Number for Export $totalCount = count((array)$facility_list);
    						for ($i = 0; $i < $totalCount; $i++) {
    							unset($facility_list[$i]->row);
    							unset($facility_list[$i]->id);
    						}
    						//Setting Totals for Excel Export
    						$facility_list[$totalCount] = new StdClass;
    						$facility_list[$totalCount]->name = 'VA Total:';
    						$facility_list[$totalCount]->Number_of_users = $this->sum_by_object_name((array)$facility_list, 'Number_of_users');
    						$facility_list[$totalCount]->Number_in_group = $this->sum_by_object_name((array)$facility_list, 'Number_in_group');
    						$facility_list[$totalCount]->Number_of_sent = $this->sum_by_object_name((array)$facility_list, 'Number_of_sent');
    						$facility_list[$totalCount]->Number_of_seen = $this->sum_by_object_name((array)$facility_list, 'Number_of_seen');
    						$facility_list[$totalCount]->Total_messages = $this->sum_by_object_name((array)$facility_list, 'Total_messages');
    
    						if($export_type === 'excel') {
    							$this->export(array('VA Facility','Number of Users','Number of Groups', 'Total Messages Sent','Total Messages Received','Total Messages'),$facility_list,$report_name,$items,$between,$selected,null,$report_id,$size);
    							break;
    						}
    						else {
    							return $this->export(array('VA Facility','Number of Users','Number of Groups', 'Total Messages Sent','Total Messages Received','Total Messages'),$facility_list,$report_name,$items,$between,$selected,null,$report_id,$size, true);
    						}
    							
    					case 'hisp':
    						if($export_type === 'excel') {
    							$this->export(array('Domain Name','Total Messages Sent', 'Total Messages Received','Total Messages'),$message_counts['list'],$report_name,$items,$between,$selected,null,$report_id,$size);
    							break;
    						}
    						else {
    							return $this->export(array('Domain Name','Total Messages Sent', 'Total Messages Received','Total Messages'),$message_counts['list'],$report_name,$items,$between,$selected,null,$report_id,$size, true);
    						}
    					case 'points_of_origin':
    						if($export_type === 'excel') {
    							$this->export(array('Originating Application','Total Messages Sent'),$message_counts['list'],$report_name,null,$between,$selected,null,$report_id,$size);
    							break;
    						}
    						else {
    							return $this->export(array('Originating Application','Total Messages Sent'),$message_counts['list'],$report_name,null,$between,$selected,null,$report_id,$size,true);
    						}
    				}
    			}
    			else {
    				$data['adhoc_print_page'] = true;
    				$this->load->view('api/reports/result_tables/result_' . $report_type, $data);
    			}
    	}   
   
        
    /**
     * ajax call to return groups
     */
    public function get_groups_to_share_report(){
        $which_report = $this->input->get('which_report',TRUE);
        $groups = $this->groupsmodel->get_groups();
        $group_array = array();
        foreach($groups as $group) {
            $members = $this->groupsmodel->get_members($group['ou']);
            foreach($members as $member) {
                $user_id = $this->usersmodel->get_user_id_from_user_name($member);
                $accessible_groups = $this->usersmodel->get_user($user_id)->groups;
                if($which_report === 'facility' || $which_report === 'user_activity_summary') {
                    if(in_array('API Admins', $accessible_groups) || in_array('Facility Leader', $accessible_groups)) {
                        $group_array[$group['ou']] = $group['cn'];
                        break;
                    }
                }
                else {
                    if(in_array('API Admins', $accessible_groups)) {
                        $group_array[$group['ou']] = $group['cn'];
                    }
                }
            }
        }
        echo $this->json->encode($group_array);
    }
    
    /**
     * ajax call to return users
     */
    public function get_users_to_share_report(){
        $current_user_id = $this->user->id();
        $which_report = $this->input->get('which_report',TRUE);
        $users = $this->usersmodel->get_users();
        $user_array = array();
        foreach($users as $user) {
            if($current_user_id != $user->user_id) {
                $accessible_groups = $this->usersmodel->get_user($user->user_id)->groups;
                if($which_report === 'facility' || $which_report === 'user_activity_summary') {
                    if(in_array('API Admins', $accessible_groups) || in_array('Facility Leader', $accessible_groups)) {
                        $user_array[$user->user_id] = $user->cn;
                    }
                }
                else {
                    if(in_array('API Admins', $accessible_groups)) {
                        $user_array[$user->user_id] = $user->cn;
                    }
                }
            }
        }
        echo $this->json->encode($user_array);
    }
    /**
     * ajax call to return report names
     */
    public function get_report_names_for_mutliple_downloads(){
        $export_type = $this->input->get('reportType',TRUE);
        if($export_type =="adhoc_export_pdf") { $export_image = 'pdf'; } 
        else { $export_image = 'excel'; }
        
        $which_report = $this->input->get('which_report_id',TRUE);
        $reports_id = explode(",", $which_report);
        $report_names = array();
        foreach ($reports_id as $id) {
            $result_security = $this->adhoc_report_security_check($id);
            if($result_security !== FALSE){
                $name_report = $this->adhocreportsmodel->get_report_name_by_id($id)->result()[0]->report_name;
                if (!empty($name_report)) {
                    $report_names[$id]= $name_report;
                }
            }
        }
        echo $this->json->encode($report_names);
    }
    
    /**
     * convert date time
     */
    protected function get_utf_time($date_time){
        $date = new DateTime($date_time);
        $date->format("U");
        return $date->getTimestamp();
    }
    
    /**
     * convert date to a new time period
     */
    protected function return_different_start_date($diff_time_period){
        //Date Settings    
        switch ($diff_time_period) {
            case 'seven_days':
                //Seven Days
                $diff_period_start = $this->get_utf_time(date('m/d/Y 00:00:00', strtotime('-7 days')));
                break;
            case 'thirty_days':
                //Thirty Days
                $diff_period_start = $this->get_utf_time(date('m/d/Y 00:00:00', strtotime('-30 days')));
                break;
            case 'last_month':
                //Last Month
                $diff_period_start = $this->get_utf_time(date('m/d/Y 00:00:00', strtotime('first day of last month')));
                break;
            }
        return $diff_period_start;
    }
    
    /**
     * convert date to a new time period
     */
    protected function return_different_end_date($diff_time_period){
        //Date Settings    
        switch ($diff_time_period) {
            case 'seven_days':
                //Seven Days
                $diff_period_end = time('m/d/Y 23:59:59', strtotime(time()));
                break;
            case 'thirty_days':
                //Thirty Days
                $diff_period_end = time('m/d/Y 23:59:59', strtotime(time())); 
                break;
            case 'last_month':
                //Last Month
                $diff_period_end = $this->get_utf_time(date('m/d/Y 23:59:59', strtotime('last day of last month')));
                break;
            }
        return $diff_period_end;    
    }
    
    /**
     * Create new SQL based on the different time selected
     */
    protected function create_different_time_period_query($sql_query_generator_array,$time_start_check,$time_end_check,$time_period_field,$diff_period_start,$diff_period_end){
        $sql = '';
        $i = 0;
        $sql_queries_by_part = explode('AND', $sql_query_generator_array);
        //Loop throughout the query array to edit dates
        if(!empty($time_start_check) && !empty($time_end_check)) {
            foreach($sql_queries_by_part as $id) {
                if($i == 0) { $sql .= ''; } 
                else { $sql .= ' AND '; }
                if (string_contains('time', $id) || string_contains('call_date', $id) /*request table time stamp*/) {
                        if (string_contains('<=', $id)) {
                            $sql .= '('.$time_period_field. ' >= ' . $diff_period_start . ')';
                        }
                        if (string_contains('>=', $id)) {
                            $sql .= '('.$time_period_field. ' <= ' . $diff_period_end . ')';    
                        } 
                } 
                else { $sql .= $id; }
                $i++;    
            }
        } 
        else {
            $sql .= '('.$time_period_field. ' <= ' . $diff_period_end . ') AND ('.$time_period_field. ' >= ' . $diff_period_start . ') AND ';    
            foreach ($sql_queries_by_part as $id){
                if($i === 0) { //theoretically there should be no reason to have this if you take the last AND off the query above
                    $sql .= ''; 
                    $sql .= $id; 
                }
                //if the query already has something limiting the time period
                else if(string_contains($time_period_field, $id)) {  $sql .= ''; }
                else { $sql .= ' AND '; $sql .= $id; }
                
                $i++;    
            }
        }
        //Return New SQL Query
        return $sql;
    }
    
    /**
     * ajax call to edit report attributes
     */
    public function edit_report_attributes() {
        $report_id = $this->input->get('report_id',TRUE);
        $report_name = $this->input->get('report_name',TRUE);
        $report_description = $this->input->get('report_description',TRUE);
        $data = $this->adhocreportsmodel->edit_adhoc_report_attributes($report_id, $report_name);
        echo $this->json->encode($data);
    }
    
    /**
     * ajax call to delete users
     */
    public function get_share_user_to_delete(){
        $report_id = $this->input->get('report_id',TRUE);
        $user_id = $this->input->get('user_id',TRUE);
        //Deleting User
        $data = $this->adhocreportsmodel->delete_user_access_to_report($report_id, $user_id);
        echo $this->json->encode($data);
    }
    
    public function save_objects_for_sharing_report() {
        $report_id = $this->input->get('report_id',TRUE);
        $selected_items = $this->input->get('selected_items',TRUE);
        $data = $this->adhocreportsmodel->add_user_access_to_report($report_id, $selected_items);
        echo $this->json->encode($data);
    }
    /**
     * Adhoc Report Security Check
     */

	protected function adhoc_report_security_check($report_id){
        
        //Get userID
        $session_id = User::organization_id_from_session();
        $userID = $this->usersmodel->get_user_id_from_org_id($session_id); 
        
        //Get Report Type
        $report_access = $this->adhocreportsmodel->get_report_type_by_id($report_id)->result();    
        if(!isset($report_access[0])){
            return false;
        }
        if (!$this->user->is_admin()){
            //Check Current if on Shared report list
            if($report_access[0]->report_access_type == "shared"){
                $report_security_check = $this->adhocreportsmodel->security_check($report_id, $userID)->result();    
                if (isset($report_security_check[0]->report_access_id)){ $result  = true; } else { $result = false; }
            } elseif($report_access[0]->report_access_type == "private"){
                $report_security_check = $this->adhocreportsmodel->security_check_private($report_id, $userID)->result();    
                if (isset($report_security_check[0]->report_id)){ $result  = true;    } else { $result = false; }
            } else {
                $result  = true;
            }
        } else {
            $result  = true;
        }
        return $result;
    }

    protected function parse_date($date_string) {
        try {
            $date = new DateTime($date_string);
            return $date;
        }
        catch ( Exception $ex ) {
            return false;
        }
    }

    protected function is_a_report_filter_date($date_string) {
        $pattern_date = '((0{0,1}[1-9])|(1[0-2]))\/((0{0,1}[1-9])|([1-2][0-9])|(3[0-1]))\/([0-9]{4})';
        //$pattern_time = '(((0{0,1}[0-9])|(1[0-2]))(:((0{0,1}[0-9])|([1-5][0-9]))){1,2}[[:space:]]+(am|pm))|(((0{0,1}[0-9])|(1[0-9])|(2[0-4]))(:((0{0,1}[0-9])|([1-5][0-9]))){1,2})';
        // regex only works at certain levels of nested parentheses. Looks like this is the limit. 
        $pattern_time[0] = '(((0{0,1}[0-9])|(1[0-2]))(:((0{0,1}[0-9])|([1-5][0-9]))){1,2}[[:space:]]+(am|pm))';
        $pattern_time[1] = '(((0{0,1}[0-9])|(1[0-9])|(2[0-4]))(:((0{0,1}[0-9])|([1-5][0-9]))){1,2})';

        // Based on time zone abbreviations from NIST website 
        $pattern_time_zone = '(AST|EST|CST|MST|PST|AKST|HST|SST|ChST|ADT|EDT|CDT|MDT|PDT|AKDT|HDT)';
        // This pattern is almost there, but doesn't cover all the scenarios!
        $patterns = array();
        for ( $i = 0; $i < 2; $i++ ) {
            $patterns[] = '/^' . $pattern_date . '([[:space:]]+' . $pattern_time[$i] . '){0,1}([[:space:]]+' . $pattern_time_zone . '){0,1}$/i';
        }

        if ( preg_match($patterns[0], $date_string) ||  preg_match($patterns[1], $date_string)) {
            return true;
        }
        
        return false;
    }
    protected function has_access($access){
        if(in_array("reports", $this->account_permissions["Permission"])) return true;
        return parent::has_access($access);
    }
}