<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
* Parent controller for all areas limited to logged-in users.  
*
* Checks to make sure that we have the user set up in the session, and sets a class var for the user so that we don't have to keep hitting up the database
* every time we need the username or other db info.  Having only one place where this code is written will ensure that it's consistent and make it easier to
* make any necessary changes.
*
* @package direct-as-a-service
* @subpackage controllers
*/ /** */


require_once APPPATH.'controllers/admin/DAAS_controller.php';

/**
* @package direct-as-a-service
* @subpackage controllers
*/ 
class Admin_controller extends DAAS_Controller {
	
	var $show;
	var $account_permissions;
	
	public function __construct(){
		parent::__construct();
		
		$this->load->model(array('applicationmodel','usersettingsmodel'));
		
		 //there are a few rare cases where we don't require va authorization - see DAAS_controller for more info
		if(method_exists($this, 'allow_non_va_users') && $this->allow_non_va_users()) return;
		
		//from here on, we assume that users must be active users of the site

		//check that the authenticated user from the parent class is not active and is not stored in the DB
		if(!User::is_an_entity($this->user) || !$this->user->active){
			redirect('onboarding');
		}
		
		$this->account_permissions = $this->user->permissions;
		$this->show = $this->permissions->set_tab_access_from_permissions($this->account_permissions);
		$this->verify_access($this->uri->segment(1));
	}

	protected function has_access($access){
		if($this->user->is_admin())	return true;
		return in_array(mb_strtolower($access), $this->account_permissions["Permission"]);
	}
	
	protected function verify_access($access){
		if($this->user->is_admin())	return;

		$access = mb_strtolower($access);

		// VAD-2152: Myke Carter - To avoid show_404() the value of $access must be either a string element within the
		// $this->account_permissions['Permission'] array or a key within $this->show which is also set to 1 (true).
		// If either of these conditions are true access to a non-admin user to a given tab/page will be granted.
		if(!(in_array($access, $this->account_permissions["Permission"])||(isset($this->show[$access])&&$this->show[$access]))) 
			show_404();
	}

}