<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage controllers
*/ 

/**
* A controller for any areas of the site that do *not* require that the user provide authentication credentials.
*
* @package direct-as-a-service
* @subpackage controllers
*/ 
class Public_controller extends CI_Controller {
	
	public function log_out(){
		$this->load->library('template');
		require_model('user');
		
		$this->session->destroy_entirely();
		
		$this->template->show_navbar = false;
		$this->template->set('title', PRODUCT_NAME);
		$this->template->set('page_title', 'You have successfully logged out.');
		
		//there is so little content to this page that it doesn't seem worth redirecting
		$content = '<p>We recommend that you close your browser to ensure that you are completely logged out. Did you log out by mistake?  You can use the button below to log in again.</p>';
		$content .= '<div class="text-center">'.link_to_as_button(site_url(), 'Log In').'</div>';
		$this->template->load_string('template', $content);
	}
	
	//only available for local development environments - shows the main CSS patterns for the site
 	public function style_guide(){
		if(!is_on_local()) show_404();
		$this->load->helper('file_helper');
		$this->load->library('template');
		$this->template->show_navbar = true;
		$this->template->active_nav = 'onboarding';
		$this->template->load('template', 'style_guide/style_guide', array('page_title' => 'Living Style Guide'));
	}	

}