<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage config
*//** */


/**
* File and directory Modes
* 
* These prefs are used when checking and setting modes when working
* with the file system.  The defaults are fine on servers with proper
* security, but you may wish (or even need) to change the values in
* certain environments (Apache running a separate process for each
* user, PHP under CGI with Apache suEXEC, etc.).  Octal values should
* always be used to set the mode correctly.
*/

define('FILE_READ_MODE', 0644);
define('FILE_WRITE_MODE', 0666);
define('DIR_READ_MODE', 0755);
define('DIR_WRITE_MODE', 0777);

/**
* File Stream Modes
* 
* These modes are used when working with fopen()/popen()
*/

define('FOPEN_READ',							'rb');
define('FOPEN_READ_WRITE',						'r+b');
define('FOPEN_WRITE_CREATE_DESTRUCTIVE',		'wb'); // truncates existing file data, use with care
define('FOPEN_READ_WRITE_CREATE_DESTRUCTIVE',	'w+b'); // truncates existing file data, use with care
define('FOPEN_WRITE_CREATE',					'ab');
define('FOPEN_READ_WRITE_CREATE',				'a+b');
define('FOPEN_WRITE_CREATE_STRICT',				'xb');
define('FOPEN_READ_WRITE_CREATE_STRICT',		'x+b');

/**
* Application Settings
*/

define('DIRECT_ATTACHMENT_SIZE_LIMIT', 5242880); //in bytes
define('ITEMS_PER_PAGE_DEFAULT','10'); //must be one of the values defined in application\third_party\Paginator\display_items_per_page:$ipp_array
define('PAGINATION_MID_RANGE','9');
define('MAX_MESSAGES','100');
define('SEND_DISPLAY_MDN',TRUE);
define('REQUEST_DISPATCHED_MDN',FALSE);
define('NESTED_FOLDER_MAX_DEPTH', '3');
define('REPORTS_EXPORT_MAX_LIMIT',1500); //max number of records allowed during export
define('REPORTS_EXPORT_WARNING_LIMIT', 1000); //number of records that will trigger a warning

/**
* Application Security Settings
* These are used to configure application security related constants
*/

define('USE_CAC_AUTH',FALSE);
define('USE_PIV_AUTH',TRUE);
define('IS_AJAX', isset($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest');


//set up constants based on our ini file for sensitive data or very environment-specific data
$application_ini_config = parse_ini_file(APPLICATION_INI_LOCATION);
define('DATABASE_PASSWORD', $application_ini_config['database_password']);
define('LDAP_ANON_ADMIN_PASSWORD', $application_ini_config['ldap_anon_admin_password']);
define('LDAP_ANON_SEARCH_PASSWORD', $application_ini_config['ldap_anon_search_password']);
define('WEBSERVICE_PUBLIC_KEY', $application_ini_config['webservice_public_key']);
define('WEBSERVICE_PRIVATE_KEY', $application_ini_config['webservice_private_key']);
define('TLS_SERVER_CERT_PATH', $application_ini_config['tls_server_cert_path']);
define('TLS_SERVER_KEY_PATH', $application_ini_config['tls_server_key_path']);
define('VAP_URI', $application_ini_config['vap_uri']);
define('VAP_HOME_COMMUNITY_ID', $application_ini_config['vap_home_community_id']);

define('LOG_ENTRY_MAX_LENGTH_IN_BYTES', (array_key_exists('log_entry_max_length_in_bytes', $application_ini_config) ? $application_ini_config['log_entry_max_length_in_bytes'] : 10240));

define('FILE_TRANSFER_EXPIRATION_IN_DAYS', 30); //large file transfers will not be available for download after this time

/**
* Environment Settings
* Used to configure constants that changed based on environment
*/
define('DIRECT_ENVIRONMENT', 'DEMO');	
switch(DIRECT_ENVIRONMENT) {

	case 'DEMO':
		define('ENVIRONMENT_TIMEZONE','America/New_York'); //environment default time zone
		define('CLINICAL_DOMAIN', 'demo.direct.DNS   ');
		define('PATIENT_DOMAIN', 'patient.demo.direct.DNS   ');
		define('API_DOMAIN', 'api.'.CLINICAL_DOMAIN);
		define('API_ADMINPANEL_DOMAIN', 'developer.'.CLINICAL_DOMAIN);
		define('API_FILETRANSFER_DOMAIN', 'filetransfer.'.CLINICAL_DOMAIN);
		define('GATEWAY_SMTP_HOSTNAME',	'DNS     dem11.aac.DNS   ');
		define('GATEWAY_HOSTNAME','DNS     dem11.aac.DNS   ');
		define('GATEWAY_SMTP_PORT',	'25');
		define('GATEWAY_EXTERNAL_EMAIL_PORT', '587');
		define('EMAIL_SIGNATURE', 'VLER Direct Team');
		define('EXTERNAL_EMAILS_FROM', 'notifications@'.CLINICAL_DOMAIN);
		define('ALL_USERS_MOCK_ADDRESS', 'all-va-direct-users@'.CLINICAL_DOMAIN);
		define('GATEWAY_SMTP_TIMEOUT', '1');
		define('DIRECT_SEND_PROTOCOL', 'smtp');
		define('DATABASE_HOSTNAME', 'DNS  DIRSQL811.aac.dva.DNS   \DNS  DIRSQL811,1433');
		define('DATABASE_NAME', 'api');
		define('MAIL_DATABASE_NAME', 'mail');
		define('DATABASE_USERNAME', 'api-db');
		define('DATABASE_DRIVER', 'sqlsrv');
		define('LDAP_HOSTNAME', 'DNS     dem10.aac.DNS   ');
		define('LDAP_PORT', '389');
		define('LDAP_BASE_RDN', 'dc=api,dc=demo,dc=direct,dc=va,dc=gov');
		define('LDAP_API_ADMIN_GROUP', 'ou=api_admins,'.LDAP_BASE_RDN);
		define('LDAP_APPLICATION_GROUP', 'ou=applications,'.LDAP_BASE_RDN);
		define('LDAP_DISABLED_APPLICATION_GROUP', 'ou=disabled_applications,'.LDAP_BASE_RDN);
		define('LDAP_DIRECT_API_PERMISSIONS_GROUP', 'ou=direct_api_apps,'.LDAP_BASE_RDN);
		define('LDAP_ADMIN_API_PERMISSIONS_GROUP', 'ou=admin_api_apps,'.LDAP_BASE_RDN);
		define('LDAP_DISCLOSURE_API_PERMISSIONS_GROUP', 'ou=disclosure_api_apps,'.LDAP_BASE_RDN);
		define('LDAP_APPLICATION_ADMIN_GROUP_NAME', 'admins');
		define('LDAP_APPLICATION_USER_GROUP_NAME', 'users');
		define('LDAP_ACCOUNT_GROUP', 'ou=accounts,'.LDAP_BASE_RDN);
		define('LDAP_DISABLED_ACCOUNT_GROUP', 'ou=disabled_accounts,'.LDAP_BASE_RDN);
		define('LDAP_ROLES_GROUP', 'ou=roles,'.LDAP_BASE_RDN);
		define('LDAP_GROUPS_GROUP', 'ou=groups,'.LDAP_BASE_RDN);
		define('LDAP_DISABLED_GROUPS_GROUP', 'ou=disabled_groups,'.LDAP_BASE_RDN);
		define('LDAP_ANON_SEARCH_USERNAME', 'cn=webmailsearch,dc=demo,dc=direct,dc=va,dc=gov');
		define('LDAP_ANON_ADMIN_USERNAME', 'cn=admin,dc=demo,dc=direct,dc=va,dc=gov');

		define('WEBSERVICE_URL', 'http://'.API_DOMAIN);

		define('PRODUCT_NAME', 'Direct Secure Messaging API');
		define('WKHTMLTOPDF_EXE_PATH', 'C:\Program Files (x86)\wkhtmltopdf\wkhtmltopdf.exe');
		define('WARNING_BANNER_TITLE', 'VA Notice and Consent Banner');
		define('WARNING_BANNER_PAGE_TITLE', 'Direct API: VA Notice and Consent');
		define('WARNING_BANNER', '<p>VA systems are intended to be used by authorized VA network users for viewing and retrieving information only except as otherwise explicitly authorized for official business and limited personal use under VA policy.</p>
								<p>
									Information from this system resides on and transmits through computer systems and networks funded by the VA.
									All access or use constitutes understanding and acceptance that there is no reasonable expectation of privacy in the use of Government networks or systems.
								</p>
								<p>All access or use of this system constitutes user understanding and acceptance of these terms and constitutes unconditional consent to review and action including (but not limited to) monitoring recording copying auditing inspecting investigating restricting access blocking  tracking disclosing to authorized personnel or any other authorized actions by all authorized VA and law enforcement personnel.</p>
								Unauthorized user attempts or acts to
								<ul style="list-style-type: none;">
								<li>(1) access upload download change or delete information on this system</li>
								<li>(2) modify this system</li>  
								<li>(3) deny access to this system</li>
								<li>(4) accrue resources for unauthorized use or</li> 
								<li>(5) otherwise misuse this system are strictly prohibited.</li>
								</ul>
								<p>Such attempts or acts are subject to action that may result in criminal civil or administrative penalties.</p>');
		define('TLS_SERVER_VERIFYHOST', FALSE);
		define('TLS_SERVER_VERIFYPEER', FALSE);
		define('VLERDAS_PROTOCOL', 'https');
		define('VLERDAS_HOSTNAME', '.vaco.DNS   ');
		define('VLERDAS_PORT', '443');
		define('VLERDAS_ECRUD_RESOURCE', 'ecrud/v1');
		define('VLERDAS_DATABASE', 'core');
		define('VLERDAS_COLLECTION', 'directSecureMessaging.cda/transform');
		define('WIDGET_DOCUMENTATION_ICN', '1012638924V546709');
		
		break;
}

/**#@-*/
/* End of file constants.php */
/* Location: ./application/config/constants.php */
