<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
* AUTO-LOADER
* 
* This file specifies which systems should be loaded by default.
*
* In order to keep the framework as light-weight as possible only the
* absolute minimal resources are loaded by default. For example,
* the database is not connected to automatically since no assumption
* is made regarding whether you intend to use it.  This file lets
* you globally define which systems you would like loaded with every
* request.
*
* 
* Instructions
* 
*
* These are the things you can load automatically:
*
* 1. Packages
* 2. Libraries
* 3. Helper files
* 4. Custom config files
* 5. Language files
* 6. Models
*
* @package direct-as-a-service
* @subpackage config
*//** */

global $installer;

/**
* Auto-load Packges
* 
* Prototype:  $autoload['packages'] = array(APPPATH.'third_party', '/usr/local/shared');
*
* @global array $autoload['packages']
*/
$autoload['packages'] = array(APPPATH.'third_party');


if( !isset($installer) || !$installer) { // don't autoload while installer is active
	/**
	* Auto-load Libraries
	* 
	* These are the classes located in the system/libraries folder
	* or in your application/libraries folder.
	*
	* Prototype: $autoload['libraries'] = array('database', 'session', 'xmlrpc');
	*
	* @global array $autoload['libraries']
	*/
	$autoload['libraries'] = array('database', 'encrypt', 'error', 'eventlog', 'json', 'locale', 'permissions', 'session', 'template');
}

/**
* Auto-load Helper Files
* 
* Prototype: $autoload['helper'] = array('url', 'file');
*
* @global array $autoload['helper']
*/

$autoload['helper'] = array('loader', 'array', 'debug', 'environment', 'file', 'form', 'html','htmlpurifier','number', 'security', 'string', 'url');


/**
* Auto-load Config files
* 
* Prototype: $autoload['config'] = array('config1', 'config2');
*
* NOTE: This item is intended for use ONLY if you have created custom
* config files.  Otherwise, leave it blank.
*
* @global array $autoload['config']
*/

$autoload['config'] = array();


/**
* Auto-load Language files
* 
* Prototype: $autoload['language'] = array('lang1', 'lang2');
*
* NOTE: Do not include the "_lang" part of your file.  For example
* "codeigniter_lang.php" would be referenced as array('codeigniter');
*
* @global array $autoload['language']
*/

$autoload['language'] = array('feedback');


if( !isset($installer) || !$installer) { // don't autoload while installer is active
	/**
	* Auto-load Models
	* 
	* Prototype: $autoload['model'] = array('model1', 'model2');
	*
	* @global array $autoload['model']
	*/
	$autoload['model'] = array('groupsmodel', 'facilitymodel', 'usersmodel');
}

//the classes for these models will be made available, but not actually loaded using the CI singleton pattern
$autoload['entity_models'] = array('entity', 'account_request', 'application_request', 'disclosure', 'attachment_disclosure', 'event', 'file_transfer', 'folder', 'group', 'mailbox', 'message', 'patient', 'request', 'system_wide_message', 'ticket', 'ticket_category', 'user'); 

/* End of file autoload.php */
/* Location: ./application/config/autoload.php */