<?PHP 
/**
* @package direct-project-innovation-initiative
* @subpackage views
* @filesource
*/ /** */

	
	$this->load->view('header/header_settings');
	$this->load->view('message_modal');
?>
				<a class="hidden_context hidden_link" name="menuContent" id="menuContent">Menu</a>
				<a class="hidden_context hidden_link" name="menuContent" id="skipAdminMenu" href="#mainContent">Skip Menu</a>
				<div id="admin_menu">
					<div class="menuwrap">
						<div class="tab"><a href="/settings">Account Settings</a></div>
					</div>
					<div class="menuwrap">
						<div class="tab"><a href="/settings/notifications">Notification Settings</a></div>
					</div>
					<div class="menuwrap">
						<div class="tab active"><a href="/settings/application">Application Settings</a></div>
					</div>
				</div>
			</div>
			<a name="mainContent" id="mainContent" class="hidden_context hidden_link">Main Content</a>
			<div class="content_settings">
			
			<?PHP echo form_open("/settings/update_app_settings"); ?>
				<div class="settings">
				<h2>Application Settings</h2>
				<?php echo $this->session->flashdata('m');?>
				<h3>Locale Settings</h3>
				<table role="presentation" id="setting_table">
					<tr>
						<td><label for="country">Country</label></td>
						<td>
							<select name="country" id="country" onchange="updateTimezoneList(this)">
							<?PHP
								foreach($countries as $key => $country) {
									if($current_country == $key) {
										echo '<option value="'.$key.'" selected>'.$country.'</option>';
									}
									else { 
										echo '<option value="'.$key.'">'.$country.'</option>';
									}
								}
							?>
							</select>
						</td>
					</tr>
					<tr>
						<td><label for="timezone">Timezone</label></td>
						<td>
							<select name="timezone" id="timezone">
							<?PHP
								foreach($timezones as $timezone) {
									$offset = $timezone['offset'];
									if($current_timezone == $timezone['timezone']) {
										echo '<option value="'.$timezone['timezone'].'" selected>'.str_replace('_',' ',$timezone['timezone']) . ' ' . '(GMT ' . ($offset < 0 ? $offset : '+'.$offset) . ':00) '. $this->locale->timezone_abbr_from_name($timezone['timezone']) .'</option>';
									}
									else {
										echo '<option value="'.$timezone['timezone'].'">'.str_replace('_',' ',$timezone['timezone']) . ' ' . '(GMT ' . ($offset < 0 ? $offset : '+'.$offset) . ':00) '. $this->locale->timezone_abbr_from_name($timezone['timezone']) .'</option>';
									}
								}
							?>
							</select>
						</td>
					</tr>
				</table>
				<button class="minimal" type="submit" style="margin-top: 25px; padding-left: 5px; padding-right: 5px;">Update Information</button>
				<h3>&nbsp;</h3>
				<h3>API Service Permission Settings</h3>
				<button class="minimal" type="button" style="margin-top: 10px; padding-left: 5px; padding-right: 5px;" id="change_service_permission" onclick="javascript:getWebservicePermission('<?php echo $username;?>',0);">Change Service Permission</button>
				</div>
			<?PHP echo form_close(); ?>
			</div>
		</div>
		<?PHP $this->load->view("footer"); ?>
	</body>
</html>