<?PHP 
/**
* Markup to view any message that is not a draft.
* 
* Note that this view is intended to be used within the larger context of inbox/{@link template.php}, in conjunction with the 
* {@link _view_menu} partial.
*
* <code>
* $this->template->set('menu_partial', '_view_menu');
* $this->template->load('template', 'inbox/view', $data); 
* </code>
*
* @package direct-project-innovation-initiative
* @subpackage views
* @filesource
*/ /** */
																													
//sent messages include icons to indicate delivery status; let's format them before we display the markup to keep the markup as clear as possible
//this will result in a $to and a $cc address
foreach(array('to', 'cc') as $recipient_type){
	if(!$message->sent){
		$$recipient_type = array_map('htmlentities', $message->addresses_for_display($recipient_type));
	}else{
		$$recipient_type = array();
		foreach($message->addresses_for_display($recipient_type) as $address){	 
			$markup = '<a style="text-decoration:none; color:#000000">' . htmlentities($address) . ' </a>'; //why are we putting the address in an <a>? 
			$markup .= '<img src="/images/email_icons/' . make_string_css_friendly($message->delivery_status($address)) . '.png" title="' . $message->delivery_status($address) . '" alt="'.$message->delivery_status($address).' Icon">';
			array_push($$recipient_type, $markup); //wouldn't normally use array_push, but PHP doesn't seem to like [] with $$ syntax
		}
	}
}

$security_token = $this->security->get_csrf_token_name().'='.$this->security->get_csrf_hash();

?>
<input style="display:none;" id="current_user" value="<?PHP if(isset($status_enabled)){echo $user->id;}?>"/>
<input style="display:none;" id="display_name" value="<?PHP if(isset($status_enabled)){echo $user->cn;}?>"/>
<div id="msg_header">
	<div class="subject" title="<?php echo $message->subject_for_display(); ?>">
		<?php if(isset($status_enabled) && $status_enabled) echo $this->load->view('inbox/_assignment_link', compact('user', 'message', 'workflow_item'), TRUE); ?>
		<?php echo $message->subject_for_display(); ?>
	<?php if($message->importance != 'normal'): ?>
		<br />
		<span class="msg_priority">This message was sent with <?php echo ucfirst($message->importance) ?> importance.</span>
	<?php endif ?>
	</div>
	<div id="msg_subheader">
		<div class="date"><?php echo $message->timestamp_for_display() ?></div>
		<div class="addresses">
			<div class="address-item"><strong>From</strong>: <?php echo implode(', ', array_map('htmlentities', $message->addresses_for_display('sender')))  ?> </div>
				<div class="address-item"><strong>To</strong>: <?php echo implode(', ',  $to) ?></div>
				<?php if(!$message->property_is_empty('cc')): ?>
					<div class="address-item"><strong>CC</strong>: <?php echo implode(', ',  $cc) ?></div>
				<?php endif ?>
		</div>
	<?php if($message->has_attachments()): ?>
		<div class="attachments"> 
			<strong>Attachments</strong>: <br />
			<input type="hidden" name="msg_id" value="<?php echo $message->id ?>" />
			<table id="attachments-list">
			  <tbody>
				<tr>
			<?php $i = 0; ?>
			<?php foreach($message->attachment_files as $attachment): ?>
					<td class="<?php echo $attachment->extension ?> <?php if($attachment->property_exists('schema')) echo $attachment->schema ?>" <?php if(is_a($attachment, 'Patient_document_attachment')):?>style="width: 20%;"<?php endif ?>> 
						<?php if(is_a($attachment, 'XDM_attachment')): ?>
							<a href="#" title="Click to collapse clinical document content from zip archive" class="zip-expand-icon expanded" data-attachment-index="<?php echo $i;?>">&#x25BC;</a>
							<a href="#" class="zip-expand-icon zip-name expanded" data-attachment-index="<?php echo $i;?>"><?php echo $attachment->name;?></a>
						<?php else: echo $attachment->link(); ?>
						<?php endif ?>
						(<?php echo byte_format($attachment->bytes); ?>)
						<?php if(is_a($attachment, 'XDM_attachment')): ?>
						(<?php echo $attachment->link('Download');?>)
						<?php endif ?>
				<?php if(is_a($attachment, 'Patient_document_attachment')): //note that we shouldn't be adding additional columns without making colspan adjustments.  refactor later - grids would probably be better ?>
					</td>
					<td class="no" style="width: 50px;">
						<input type="button" title="File Actions for <?php echo $attachment->name ?>" value="Actions" class="btn btn-default btn-xs" data-dropdown="#dropdown-<?php echo $i; ?>"/>
						<div id="dropdown-<?php echo $i; ?>" class="dropdown dropdown-relative dropdown-tip">
							<ul class="dropdown-menu">
								<li><?php echo $attachment->link('View') ?></a></li>
							<?php if($attachment->schema != 'CCR'): ?>
								<li><a href="<?php echo '/inbox/message/'.$message->id.'/attachments/save_to_das/'.rawurlencode($attachment->name).'?'.$security_token  ?>">Save to DAS <?php if(!$attachment->property_is_empty('das_save_date')): ?>- Last saved on <?php echo $attachment->das_save_date('n/d/Y \a\t g:ia'); ?><?php endif ?></a></li>
							<?php endif ?>
								<li><a href="<?php echo $attachment->url_for_download().'?'.$security_token ?>">Download</a></li>
								<li><a href="<?php echo $attachment->url_for_download_as_pdf().'?'.$security_token  ?>">Download as PDF</a></li>
							</ul>
						</div>
					</td>
					<td class="no">
						<span class="c32name">
							(<?php echo $attachment->description ?>) 
						</span> 
				<?php endif ?>
				<?php if(is_a($attachment, 'XDM_attachment')): ?>
					<ul id="zip_contents<?php echo $i; ?>" class="zip-file-list">
						<?php 
							$archive_files = $attachment->archive_files();
							array_walk_recursive($archive_files, function($value, $key, $attachment) {
								require_library('attachments/archived_attachment');
								$zip_attachment = Archived_Attachment::create($key, base64_decode($value->body), array(), $attachment);
						?>
						<?php if(is_a($zip_attachment->_source_class, 'Patient_document_attachment')): ?>
							<li class="<?php echo $zip_attachment->extension; ?>"><?php echo $zip_attachment->link(null, array('data-zip-name' => $attachment->name, 'data-zip-index' => $zip_attachment->_zip_index)); ?>
								<input type="button" title="File Actions for <?php echo $zip_attachment->name ?>" value="Actions" class="btn btn-default btn-xs" data-dropdown="#dropdown-<?php echo hash('sha256', $key.$zip_attachment->_zip_index); ?>"/>
								<div id="dropdown-<?php echo hash('sha256', $key.$zip_attachment->_zip_index); ?>" class="dropdown dropdown-relative dropdown-tip">
										<ul class="dropdown-menu">
										<li><?php echo $zip_attachment->link('View') ?></a></li>
										<li><a href="<?php echo $zip_attachment->url_for_download(); ?>">Download</a></li>
										<li><a href="<?php echo $zip_attachment->url_for_download_as_pdf(); ?>">Download as PDF</a></li>
									</ul>
								</div>
								<span class="c32name"> (<?php echo $zip_attachment->_description?>)</span>
						<?php endif ?>
							</li>
						<?php
							}, $attachment);
						?>
					</ul>
				<?php endif ?>
					</td>
				</tr>
				<?php $i++; ?>
			<?php endforeach ?>
			</tbody>
			</table>
		</div>
	<?php endif ?>
	</div>
</div>
<div id="msg_body"><?php echo $message->body_for_display ?></div>