<?php $non_patient_document_attachments = array_diff_key($message->attachment_files, $message->attached_patient_documents); ?>
<div class="overlay"></div>
<div class="modal bootstrap purpose-of-disclosure">
	<h3>Accounting of Disclosures</h3>
<?php foreach($feedback_messages as $feedback_type => $feedback_message): ?>
	<?php if(!empty($feedback_message)): ?>
		<div class="feedback-message alert alert-<?php echo $feedback_type ?>">
			<button type="button" class="close" data-dismiss="alert" aria-label="Close">
			<span aria-hidden="true">&times;</span></button><?php echo $feedback_message ?>
		</div>
	<?php endif ?>
<?php endforeach ?>
	<?php echo form_open('inbox/compose/draft/'.$message->id, array('novalidate'=>'novalidate')); //novalidate because we're hiding the form fields before submitting them & Firefox/Chrome don't like that for form validation ?>
		<?php foreach($markup_generator->fields as $field){ if($field->type == 'hidden') echo $field->markup(); } ?>
	<?php if(!$message->property_is_empty('attached_patient_documents')): ?>
		<fieldset>
			<legend>Continuity of Care Documents</legend>
			<p>Please enter additional details about the patients in the attached Continuity of Care Documents.  This information is required.</p>
			<table class="table table-condensed">
				<tr>
					<th>Document</th>
					<th>Patient Name</th>
					<th>Social Security Number <span class="req">*</span></th>
					<th class="purpose-of-disclosure-column">Purpose of Disclosure <span class="req">*</span></th>
				</tr>
			<?php foreach($message->attached_patient_documents as $attachment): ?>
				<tr>
					<td class="document-name"><span><?php echo $attachment->name ?></span></td>
					<td class="patient-name"><span><?php echo $attachment->parser->patient_name() ?></span></td>
					<td>
						<div class="social-security-number-form-control-container">
							<?php echo $markup_generator->field('disclosures[patient_documents]['.$attachment->html_friendly_name.'][ssn]')->field_markup() ?>
						</div>
					</td>
					<td><?php echo $markup_generator->field('disclosures[patient_documents]['.$attachment->html_friendly_name.'][purpose_of_disclosure]')->field_markup() ?></td>
				</tr>
			<?php endforeach ?>
			</table>
		</fieldset>
	<?php endif ?>
	<?php if(!empty($non_patient_document_attachments)): ?>
		<fieldset>
			<legend>Attachments</legend>
			<p>Do these attachments disclose any patient information? If so, please specify the patients.  You may leave these fields blank if no patient information was disclosed in these attachments.</p>
			<table class="table table-condensed">
				<tr>
					<th>Attachment</th>
					<th>Given Name</th>
					<th>Family Name</th>
					<th>Social Security Number</th>
					<th class="purpose-of-disclosure-column">Purpose of Disclosure</th>
				</tr>
			<?php foreach($non_patient_document_attachments as $attachment): ?>
				<tr>
					<td class="document-name"><span><?php echo $attachment->name ?></span></td>
					<?php echo $markup_generator->field('disclosures[attachments]['.$attachment->html_friendly_name.']')->field_markup() ?>
				</tr>
			<?php endforeach ?>
			</table>
		</fieldset>
	<?php endif ?>
		<fieldset>
			<legend><?php echo $markup_generator->field('disclosures[message_body_has_patient_data]')->referral_label() ?></legend>
			<?php echo $markup_generator->field('disclosures[message_body_has_patient_data]')->markup() ?>
			<table class="table table-condensed message-body"<?php if($markup_generator->field('disclosures[message_body_has_patient_data]')->value != 'yes') echo ' style="display:none;"' ?>>
				<tr>
					<th class="row-number">#</th>
					<th>Given Name</th>
					<th>Family Name</th>
					<th>Social Security Number</th>
					<th class="purpose-of-disclosure-column">Purpose of Disclosure</th>
					<th></th>
				</tr>
			<?php for($i=1; $markup_generator->field_exists('disclosures[message][patient-'.$i.']'); $i++): ?>
				<tr>
					<th scope="row" class="row-number"><?php echo $i ?></th>
					<?php echo $markup_generator->field('disclosures[message][patient-'.$i.']')->field_markup() ?>
					<td><?php if(!$markup_generator->field_exists('disclosures[message][patient-'.($i + 1).']')): ?>
						<a href="#" class="btn" title="Click to add information about another patient disclosed in this message" onclick="cloneFormRow($(this).closest('tr'));">Add Patient</a>
					<?php endif ?></td>
				</tr>
			<?php endfor ?>
			</table>
		</fieldset>
		<div class="button-container">
			<?php echo form_submit('send', 'Send Message', 'class="btn btn-primary btn-sm" onclick="$(\'.modal\').hide(); $(\'.overlay\').remove();loadingScreen();"' ) ?>
			<?php echo form_button('cancel_button','Cancel','onclick="$(\'.modal\').remove(); $(\'.overlay\').remove(); return false;" class="btn btn-default btn-sm"') ?>
		</div>
	<?php echo form_close() ?>
</div>