<?php
/**
* @package direct-project-innovation-initiative
* @subpackage views
* @filesource
*/ /** */

//todo - this level of logic belongs somewhere other than a view, but we're also going to be changing where we get this information.  
//move this logic when we refactor to get this data elsewhere
$patients = array();

if($message->property_exists('patients')){
	foreach($message->patients as $patient){
		$key = strtoupper($patient['family_name'].'-'.$patient['given_name'].'-'.$patient['date_of_birth']);
		if(array_key_exists($key, $patients)){
			$patients[$key]['organizations'] = array_merge($patients[$key]['organizations'], array($patient['organization'] => $patient['organization']));
			$patients[$key]['documents'] = array_merge($patients[$key]['documents'], array($patient['file_name'] => $patient['file_name']));		
		}else{
			$patient['name'] = strtoupper(implode_nonempty(' ', array($patient['given_name'], $patient['family_name'])));
			if(empty($patient['name'])) $patient['name'] = 'NAME UNKNOWN';
			
			if(!array_key_exists('date_of_birth', $patient) || strlen($patient['date_of_birth']) != 8)
				$patient['date_of_birth'] = 'Unknown';
			else
				$patient['date_of_birth'] = strip_from_beginning('0', substr($patient['date_of_birth'], 4, 2).'/'.substr($patient['date_of_birth'], 6, 2).'/'.substr($patient['date_of_birth'], 0, 4));
			
			$patient['organizations'] = array($patient['organization'] => $patient['organization']);
			$patient['documents'] = array($patient['file_name'] => $patient['file_name']);
			$patients[$key] = $patient;	
		}		
	}
}
ksort($patients);

$patient_count = count($patients); 


$i = 1;
?>
<div id="message-<?php echo $message->id ?>-patients" class="patient-popover" data-toggle="popover">
	<a href="#" onclick="closeAllPopovers(); return false;" title="Click to view information for <?php echo number_as_text($patient_count) ?> <?php echo pluralize_if_necessary('patient', $patient_count) ?> in this message">
		<img src="/images/information.png" alt="Patient Information Icon" />
	</a>
	<?php foreach($patients as $patient): ?>
		<?php $identifier = 'message-'.$message->id.'-patient-'.$i ?>
			<div class="title <?php echo $identifier ?>" style="display: none;">
				<div class="popover-nav">
				<?php if($patient_count > 1 && $i > 1): ?>
					<button type="button" id="<?php echo $identifier ?>-arrow-previous" class="close arrow popover-arrow arrow-previous unit" onclick="popoverDisplayPrevious(this)">
					  <span aria-hidden="true">&lt;</span>
					  <span class="sr-only">Previous Patient</span>
					</button>
				<?php endif ?>
				<?php if($patient_count > 1): ?>
					<span class="popover-item-count"><?php echo $i .' of '. $patient_count; ?></span>
				<?php endif ?>
				<?php if($patient_count > 1 && $i < $patient_count): ?>
					<button type="button" id="<?php echo $identifier ?>-arrow-next" class="close arrow popover-arrow arrow-next unit" onclick="popoverDisplayNext(this)">
					  <span aria-hidden="true">&gt;</span>
					  <span class="sr-only">Next Patient</span>
					</button>
				<?php endif ?>
					<button type="button" class="close unit" onclick="closeAllPopovers();">
					  <span aria-hidden="true">&times;</span>
					  <span class="sr-only">Close</span>
					</button>
				</div>
				<?php echo strtoupper($patient['name']) ?>
			</div>
			<div class="body <?php echo $identifier ?>" style="display: none;">
				<div class="mock-dl">
					<div class="line"><span class="dt unit">Date of Birth</span><span class="dd"><?php echo $patient['date_of_birth'] ?></span></div>	
					<div class="line">
						<span class="dt unit"><?php echo ucfirst(pluralize_if_necessary('organization', count($patient['organizations']))) ?></span>
						<span class="dd"><?php echo implode_nonempty(', ', $patient['organizations'] )?></span>
					</div>	
					<div class="line">
						<span class="dt unit"><?php echo ucfirst(pluralize_if_necessary('document', count($patient['documents']))) ?></span>
						<span class="dd"><?php echo implode_nonempty(', ', $patient['documents'] )?></span>
					</div>
				</div>
			</div>
		<?php $i++ ?>
	<?php endforeach ?>	
</div>