<?php
/**
* @package direct-project-innovation-initiative
* @subpackage views
* @filesource
*/ /** */

/* Note - this code applies the same id to many elements, which is invalid HTML and may cause unexpected behavior for js/css.
If we're ever refactoring this code, we should consider changing the id="sender", id="subject", id="priority", etc. for table columns
to classes instead.  Additionally, it would be easier to work with this code if it was embedded PHP in HTML instetad of echoed strings,
so that we'd have the benefit of syntax highlighting/code formatting. - MG 2014-05-05 */

$mailbox_location = get_instance()->session->mailbox_location();
$mailbox_location_display_name = get_instance()->session->mailbox_location_display_name();
$is_group = get_instance()->mailbox->is_group;

?>
<table id="messages" class="messages<?php if($is_group): ?> group<?php endif ?>" style="border-spacing: 1px;" summary="This table lists messages in the <?php echo $mailbox_location_display_name ?> folder. Each row contains a checkbox for selecting an individual message to perform an action, such as Archive, Move, or Mark as Read. Each table cell after the checkbox contains information about the message: The sender of the message, the subject (and the priority if applicable), the date it was sent, and the message size.">
	<caption class="hidden_context">List of messages in mailbox folder: <?php echo $mailbox_location_display_name ?></caption>
	<!--[if lte IE 8 ]>
		<colgroup span="<?php echo ($is_group ? '8' : '7') ?>">
			<col style="width: 40px;">
			<col style="width: 40px;">
			<col style="width: 100px;">
		<?php if($is_group): ?>
			<col style="width: 100px;">
			<col style="width: 250px;">
		<?php else: ?>
			<col style="width: 360px;">
		<?php endif ?>
			<col style="width: 40px;">
			<col style="width: 50px;">
			<col style="width: 80px;">
			<col style="width: 50px;">';
			<?php if($mailbox_location=='sent'): ?><col style="width: 50px;"><?php endif ?>
		</colgroup>
	<![endif]-->
	<tr class="header">
		<th id="messages-select" class="select">
			<label for="selectall" class="hidden_context" >Select All</label>
			<input type="checkbox" name="selectall" id="selectall" onclick="selectAll()" />
		</th>
		<th id="messages-attachment" class="attachment"><img src="/images/paperclip.png" style="height: 15px;" alt="Has Attachment" title="Attachment" /></th>
<?php if($is_group): ?>
		<th id="messages-sender" class="sender"><a href="/inbox/sort/sender">From<?php if($sort_column == 'sender') echo $sort_icon ?></a></th>
<?php endif ?>
		<th id="messages-recipient" class="recipient"><a href="/inbox/sort/to">To<?php if($sort_column == 'to') echo $sort_icon ?></a></th>
		<th id="messages-subject" class="subject" colspan="2"><a href="/inbox/sort/subject">Subject<?php if($sort_column == 'subject') echo $sort_icon ?></a></th>
		<th id="messages-flag" class="flag"><a href="/inbox/sort/flag"><img src="/images/icons/flag_less_transparent.png" alt="Flag" title="Flag"/><?php if($sort_column == 'flag') echo $sort_icon ?></a></th>
		<th id="messages-priority" class="priority"><a href="/inbox/sort/priority">Priority<?php if($sort_column == 'priority') echo $sort_icon ?></a></th>
		<th id="messages-date" class="date"><a href="/inbox/sort/timestamp">Date<?php if($sort_column == 'timestamp') echo $sort_icon ?></a></th>
		<th id="messages-size" class="size"><a href="/inbox/sort/size">Size<?php if($sort_column == 'size') echo $sort_icon ?></a></th>
		<?php if($mailbox_location == 'sent'): ?><th id="messages-status-code" class="status_code">Status</th><?php endif ?>
<?php //start markup with no differences ?>
	</tr>
<?php foreach($headers as $msg_uid => $message): ?>
	<?php $header = $message; ?>
	<?php $message_url = site_url('inbox/viewmsg/'.$message->id); ?>
	<tr<?php if(!$message->seen): ?> class="newmsg"<?php endif ?>>
		<td  headers="messages-select" class="select">
			<label for="select<?php echo $message->id ?>" class="hidden_context">Select Message with Subject: <?php echo $message->subject_for_display ?></label>
			<input class="selectmsg" type="checkbox" name="selected_messages[<?php echo $message->id ?>]" id="select<?php echo $message->id ?>" onclick="selectMsg(this)" />
		</td>
		<td headers="messages-attachment" class="attachment">
		<?php if($message->has_attachments()): ?>
			<a href="<?php echo $message_url ?>/">
				<img src="/images/paperclip.png" alt="Attachment Icon" />
			</a>
		<?php endif; ?>
		</td>
	<?php if($is_group): ?>
		<td headers="messages-sender" class="sender">
			<a title="<?php echo $message->sender_for_display ?>" href="<?php echo $message_url ?>"><?php echo $message->sender_for_display ?></a>
		</td>
	<?php endif ?>
		<td headers="messages-recipient" class="recipients">
			<a title="<?php echo $message->to_for_display ?>" href="<?php echo $message_url ?>"><?php echo $message->to_for_display ?></a>
		</td>
		<td headers="messages-subject" class="subject"><?php echo $this->load->view('inbox/messages/_subject', compact('message'), TRUE) ?></td>
		<td headers="messages-subject" class="patients bootstrap"><?php if(!$message->property_is_empty('patients')) echo $this->load->view('inbox/messages/_patients', compact('message'), TRUE) ?></td>
		<td headers="messages-flag" class="flag"><?php echo $this->load->view('inbox/messages/_flag', compact('header', 'msg_uid'), TRUE) ?></td>
		<td headers="messages-priority" class="priority">
			<a href="<?php echo $message_url ?>">
				<span title="<?php echo ucfirst($message->importance) ?> Priority" class="<?php echo $message->importance ?>_priority">
					<?php if($message->importance == 'high'): ?>!<?php elseif($message->importance == 'low'): ?>&#8595;<?php else: ?>&nbsp;<?php endif ?>
				</span>
			</a>
		</td>
		<td headers="messages-date" class="date"><a href="<?php echo $message_url ?>"><?php echo $message->timestamp_for_display() ?></a></td>
		<td headers="messages-size" class="size"><a href="<?php echo $message_url ?>"><?php echo $message->size_for_display() ?></a></td>
<?php //END SECTION THAT IS THE SAME IN BOTH _MESSAGES AND _messages-SENT_DRAFT
	if ($mailbox_location=='sent'): ?>
		<td headers="messages-status-code" class="status_code">
		<?php if($message->delivery_status()): ?>
			<a href="<?php echo $message_url ?>">
				<img onmouseover="showRecipients(this, <?php implode(',',$message->delivery_statistics()) ?>)" class="status_code_icon" href="<?php echo $message_url ?>" src="/images/email_icons/<?php echo make_string_css_friendly($message->delivery_status()) ?>.png" title="<?php echo ucwords($message->delivery_status) ?>" alt="<?php echo ucwords($message->delivery_status) ?> Icon"/>
			</a>
		<?php endif; ?>
		</td>
	<?php endif ?>
	</tr>
<?php endforeach ?>
</table>