<?php
/**
* Navigation for available actions when multiple messages in an inbox (Inbox, Sent, Drafts, Archive, custom folders, search results)
*
* This partial is called by the main template for viewing the inbox ({@link template.php}), and will be contained in the .menu div.  
*
* @package direct-project-innovation-initiative
* @subpackage views
* @filesource
*/ /** */

/* variables that should be passed to this partial: 
	$CI; //a reference to the controller object
	$show_workflow; //true if we should be showing the workflow options; this could be eliminated and replaced with a $CI->mailbox->is_group check
	$message_count; //int, number of messages being displayed on this page
	$other_members;
	$page_start;
	$total; //int, total number of messages in this location */

//set up other members (TODO - can we just take care of this in the controller?)
foreach($other_members as $key => $member){
	$other_members[$member['id']] = $member['name'];
	unset($other_members[$key]);
}

$options_for_move = array();
foreach($CI->mailbox->folders_for_move() as $id => $folder){
	$options_for_move[$id] = $folder->indented_name_for_display;
}

?>
<div class="button-container unit size1of1 line">
	<div class="buttons unit">
		<button class="minimal minimal-short" type="button" id="get_mail_btn" onclick="ajaxMessageCheck(this);">Get Mail</button>
	<?php if($CI->session->mailbox_location() != 'archived'): ?>
		<button type="submit" class="minimal minimal-short" id="archive_btn" name="archive" disabled="disabled" aria-hidden="true" style="width: 135px;">Archive Message</button>
		<input type="submit" class="hidden_context" name="archive_hidden" id="archive_hidden" value="Archive" />
	<?php endif ?>
		<?php echo form_hidden('last_button', $this->session->flashdata('last_button'), 'last_button'); ?>
	<?php if(!in_array($CI->session->mailbox_location(), array('sent', 'draft'))): ?>
		<label for="move_select" class="hidden_context">Select Folder for Move</label>
		<?php echo form_dropdown('move_select', $options_for_move, '', 'id="move_select" class="hidden_context"'); ?>
		<input type="submit" name="move_hidden" id="move_hidden" class="hidden_context" value="Move" />
		<button type="button" class="minimal minimal-short" id="move_btn" name="move" disabled="disabled" aria-hidden="true">Move</button>
	<?php endif ?>
	<?php if($CI->session->mailbox_location() === 'archived'): ?>
		<button type="button" data-dropdown="#dropdown-filter" class="minimal minimal-short" title="Filter folders" id="filter_btn"  name="filter_btn" aria-hidden="true"><?PHP echo ((isset($filter_folder) && $filter_folder) ? ucfirst($filter_folder):'All');  ?> &#x25BE;</button>
		<div id="dropdown-filter" class="dropdown dropdown-tip dropdown-relative dropdown-anchor-right">
			<ul class="dropdown-menu">
				<li><a href="/inbox/filter_archive/All">All</a></li>
				<li><a href="/inbox/filter_archive/inbox">Inbox</a></li>
				<li><a href="/inbox/filter_archive/sent">Sent</a></li>
				<li><a href="/inbox/filter_archive/draft">Drafts</a></li>
			</ul>
		</div>
	<?php endif ?>
	<?php if($show_workflow): ?>
		<button type="button" class="minimal minimal-short" id="assign_button" name="assign_button" disabled="disabled" aria-hidden="true">Assign &#x25BE;</button>
		<label for="assign_select" class="hidden_context">Select Group Member for Assign</label>
		<?php echo form_dropdown('assign_select', $other_members,'', 'id="assign_select" class="hidden_context"'); ?>
		<input type="button" name="assign_select_btn_hidden" id="assign_select_btn_hidden" class="hidden_context" onclick="assign_selected($('#assign_select option:selected').val(),$('#assign_select option:selected').text());" value="Assign Select"/>
		<button type="button" onclick="complete_selected();" class="minimal minimal-short" id="complete_button"  name="complete_button" disabled="disabled" aria-hidden="true">Complete</button>
		<button type="button" onclick="complete_selected();" class="hidden_context" id="complete_button_hidden"  name="complete_button_hidden" aria-hidden="true">Complete</button>
	<?php endif ?>
	<?php if(!in_array($CI->session->mailbox_location(), array('draft', 'sent', 'archived'))):?>
		<input type="submit"  style="display:none;" id="mark_as_read_btn" name="mark_as_read" aria-hidden="true" />
		<input type="submit"  style="display:none;" id="mark_as_read_unbtn" name="mark_as_unread" aria-hidden="true" />
		<input type="submit" class="hidden_context" name="mark_as_read_hidden" id="mark_as_read_hidden" value="Mark as Read" />
		<input type="submit" class="hidden_context" name="mark_as_unread_hidden" id="mark_as_unread_hidden" value="Mark as Unread" />
		<button type="button" data-dropdown="#dropdown-1" class="minimal minimal-short" title="More menu" id="more_button"  name="more_button" disabled="disabled" aria-hidden="true">More &#x25BE;</button>
		<div id="dropdown-1" class="dropdown dropdown-tip dropdown-relative dropdown-anchor-right">
			<ul class="dropdown-menu">
				<li><a onclick="$('#mark_as_read_btn').trigger('click');" href="#">Mark as read</a></li>
				<li><a onclick="$('#mark_as_read_unbtn').trigger('click');" href="#">Mark as unread</a></li>
			</ul>
		</div>
	<?php endif ?>
	</div>
<?php if(!empty($message_count)): ?>		
	<div id="pagination" class="unit unit-right">
		<span class="text"><?php echo $page_start ?><abbr title="to">-</abbr><?php echo $message_count + $page_start - 1?> of <?php echo $total ?></span>
	<?php if($page_start > 1): //if this is not the first page ?>
		<a class="move_page" href="<?php echo site_url('inbox/page/'.($page_start - INBOX_DISPLAY_PER_PAGE)) ?>"><span><img src="/images/lt.png" alt="Previous Page" height="10" /></span></a>
	<?php endif ?>
	<?php if($page_start + INBOX_DISPLAY_PER_PAGE <= $total && $message_count <= INBOX_DISPLAY_PER_PAGE): //if this is not the last page, display a next page link ?>
		<a class="move_page" href="<?php echo site_url('inbox/page/' . ($page_start + INBOX_DISPLAY_PER_PAGE)) ?>"><span><img src="/images/gt.png" alt="Next Page" height="10" /></span></a>
	<?php endif ?>	
	</div>
<?php endif ?>	
</div>