<?PHP if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
* @package direct-project-innovation-initiative
* @subpackage models
*/

require_models('database_model', 'user');

/**
* @package direct-project-innovation-initiative
* @subpackage models
*/
class User_model extends Database_model {
	protected $primary_key = 'user_id';
	protected $_logged_in_user; //set in is_logged_in()
	protected $_is_admin;
	
	//////////////////////////////////////////
	// METHODS CONCERNING THE LOGGED IN USER
	//////////////////////////////////////////
	
	/**
	* True if a user is logged in.
	* @todo Allow a username to be passed in to check if a specific user is logged in
	* @return boolean
	*/
	public function is_logged_in(){
		$user = User::find_from_session();
		if(!User::is_an_entity($user) || $user->user_deleted_flag) return false;
		
		$this->_logged_in_user = $user->values();
		$this->_logged_in_user['dn'] = "uid=" . $user->username . "," . LDAP_ACCOUNTS_DN;
		
		return true;
	}
	
	/**
	* True if the logged in user is an admin.
	* @return boolean
	*/
//deprecated - use User instead	
	public function is_admin(){
		$user = User::find_from_session();
		if(!User::is_an_entity($user)) return false;
		return $user->is_admin;
	}

	
	/**
	* The credentials that should be used to sign into LDAP.
	* Generally, this is the logged-in user's own credentials.  If no one is logged in,
	* defaults to the credentials for the {@link LDAP_SEARCH_USERNAME} account.
	* @return array
	*/
	public function ldap_credentials(){
		$username = $this->logged_in_user('user_name');
		if(!empty($username)){
			return array( 'user' => $username,
						  'pwd' => $this->encrypt->decode($this->session->userdata('ep')));
		}
		return array('user' => LDAP_SEARCH_USERNAME, 'pwd' => LDAP_SEARCH_PASSWORD);
	}
	
	public function last_login_info() {
		return $this->db->query('SELECT TOP(2) * FROM logins WHERE username=' . $this->db->escape($this->session->userdata('username')) . ' ORDER BY login_time DESC');
	}
	
	public function logged_in_user($field = null){				
		if(!$this->is_logged_in()) return array();
		if(is_null($field))
			return $this->_logged_in_user;
		if(!array_key_exists($field, $this->_logged_in_user)) return $this->error->should_be_a_recognized_user_property($field);
		return $this->_logged_in_user[$field];		
	}
	
	//deprecated
	public function log_out($destination = 'auth'){
		User::log_out($destination); 
	}
	
	////////////////////////////////////////
	// METHODS CONCERNING ALL USERS
	////////////////////////////////////////
	
	//note - if you're going to need more info than just the username, it's more efficient to just get the user object and get the info from it
	//that way, we can just do one db lookup at a timed	
	public function user_cn_from_id($id) {
		if(!$this->is->nonzero_unsigned_integer($id)) return $this->error->should_be_a_nonzero_unsigned_int($id);
		
		//check to see if the id is for the current logged-in user, so we can skip looking up the user
		$CI = get_instance();
		if(User::is_an_entity($CI->user) && $CI->user->id == $id) return $this->user->cn;
		
		$user = User::find_one($id);
		if(User::is_an_entity($user))
			return $user->cn;
		return FALSE;
	}
	
	public function create_user($username,$first, $middle,$last,$department,$organization,$telephone,$mobile,$location,$title,$ext_mail,$piv_id,$edipi){
		#$this->load->model('webmailmodel'); //we autoload this, no need for the overhead of calling it twice
		$pass = User::random_password();
		$userpassword = $this->encrypt->ssha256_encode($pass);
		
		$db_attributes = array(
			'edipi' => (isset($edipi)) ? $edipi : null,
			'piv_id' => $piv_id,
			'username' => $username,
			'ext_mail' => $ext_mail,
			'pass' => $pass,
			'actor_id' => 0,
			'user_ext_notify_flag' => 1,
			'user_ext_group_notify_flag' => 1,
			'user_deleted_flag' => 0,
			'user_is_group' => 0,
		);
		$create_user_rec = $this->webmailmodel->create_user_record($db_attributes);
		if($create_user_rec == FALSE) { 
			return FALSE; 
		}
		
		$conn = $this->prepare_ldap_conn();
		$ldap_bind = ldap_bind($conn, LDAP_ADMIN_USERNAME, LDAP_ADMIN_PASSWORD);	
		if($ldap_bind) {
			$attributes = array();
			$attributes["objectClass"] = array("posixAccount", "top", "person", "organizationalPerson", "inetOrgPerson");
			$attributes["gidNumber"] = "5000";
			$attributes["uidNumber"] = "5000";
			$attributes["uid"] = $username;
			$attributes["homeDirectory"] = "/var/mailboxes/" . $username;
			$attributes["cn"] =($first . " " . $last);
			$attributes["givenName"] = $first;
			$attributes["sn"] = $last;
			$attributes["mail"] = $username . "@" . DIRECT_DOMAIN;
			$attributes["userPassword"] = $userpassword;
			if(!is_null($middle) && $middle !== "") { $attributes["initials"] = $middle; $attributes["displayName"] = ($last . ", " . $first . " " . $middle); }
			else { $attributes["displayName"] = ($last . ", " . $first); }
			if(!is_null($department) && $department !== "") { $attributes["departmentNumber"] = $department; }
			if(!is_null($organization) && $organization !== "") { $attributes["o"] = $organization; }
			if(!is_null($telephone) && $telephone !== "") { $attributes["telephoneNumber"] = $telephone; }
			if(!is_null($mobile) && $mobile !== "") { $attributes["mobile"] = $mobile; }
			if(!is_null($location) && $location !== "") { $attributes["physicaldeliveryofficename"] = $location; }
			if(!is_null($title) && $title !== "") { $attributes["title"] = $title; }
			if(!ldap_add($conn, "uid=" . $attributes["uid"] . "," . LDAP_ACCOUNTS_DN,$attributes)) { 
				$this->db->query('DELETE FROM users WHERE user_name=' . $this->db->escape($username));
				return FALSE; 
			}
		}
		else {
			$this->db->query('DELETE FROM users WHERE user_name=' . $this->db->escape($username));
			return FALSE;
		}
		$get_target_id = $this->webmailmodel->get_user_id($username);
		if($get_target_id) {
			$target_id_row = $get_target_id->row_array();
			$target_id = $target_id_row["user_id"];
			$this->load->library("audit");
			$this->audit->log_event("edit",array($target_id,0,"Create User",date('U')));
			return true; 
		}
		return false;
	}
	
	protected function prepare_ldap_conn() {
		$ldap_conn = ldap_connect(LDAP_HOSTNAME, LDAP_PORT);
		if(!ldap_set_option($ldap_conn, LDAP_OPT_PROTOCOL_VERSION, 3)) { return FALSE; } 
		if(!ldap_set_option($ldap_conn, LDAP_OPT_REFERRALS, 0)) { return FALSE; }
		return $ldap_conn;
	}
}
