<?PHP if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
* @package direct-project-innovation-initiative
* @subpackage models
*/

require_model('entity');

/**
* Parent class for models based on a database table.
*
* Handles basic CRUD functionality, reducing the amount of custom code that needs to be written for each model & enforcing consistency.
* This parent classed is based off of the {@link http://en.wikipedia.org/wiki/Active_record_pattern Active Record Pattern}.  Static
* methods deal with multiple rows of the database table, or meta-information about the model as whole.  An instance of this model
* encapsulates a specific row of the database and useful methods for dealing with that data, including the ability to retrieve 
* related entities.
*
* *NOTE* - Models that extend from this class deviate from the usual CI model paradigm and should *NOT* be loaded in the usual CI fashion.
* The CI model loader instantiates a single instance of the model class and adds it as a class variable to the controller so that its methods
* are available throughout the application; this was a work around to cope with PHP's limited static inheritance capabilities prior to PHP 5.3.
* Since the paradigm for this model assumes that each instance of the model encapsulates a row of the database, attempting to load the model
* will only confuse the issue.
*
*
* @package direct-project-innovation-initiative
* @subpackage models
*/
class DB_entity extends Entity {
	
	public function __construct($values = array()){
		parent::__construct($values);
		if(is_a($this, 'Entity') && get_class($this) != 'Entity'){			
			$table = static::$table; //not nesc., but makes phpdocumentor happier
			$primary_key = static::$primary_key; //not nesc., but makes phpdocumentor happier

			//verify that the table & primary_key values are valid
			if(empty($table) || !$this->db->table_exists($table)){
				$this->error->should_be_a_table_in_the_database($table);
				#show_error(DEFAULT_ERROR_MESSAGE);
			}
			if(empty($primary_key) || !$this->db()->field_exists($primary_key, $table)){
				$this->error->should_be_a_column_for_table($primary_key, $table);
				#show_error(DEFAULT_ERROR_MESSAGE);
			}		
		} 
	}	
}