<?php
/**
* @package vler
* @subpackage form-markup-generator
*/

if(!isset($markup_generator) || !is_a($markup_generator, 'Field_markup_generator'))
	$this->error_helper->should_be_a_field_markup_generator($markup_generator);

$markup = array();
foreach($markup_generator->field_names as $field_name): 
	//label has a sr-only class so that it will only be visible to screen readers
	$markup[$field_name] = $markup_generator->field($field_name)->label_markup().$markup_generator->field($field_name)->field_markup(); 
endforeach;

if($markup_generator->has_error){
	foreach($markup as $field_name => $field_markup){
		if(!$markup_generator->field($field_name)->validates && $markup_generator->field($field_name)->has_error){
			$markup[$field_name] = '<div class="has-error">'.$field_markup.'</div>';
		}
	}
}

//echo '<div class="form-inline"><div class="input-group">'.implode('<div class="input-group-addon">/</div>', $markup).'</div></div>';

?>
<div class="form-inline">
	<div class="input-group">
		<?php echo $markup['month'] ?>
		<div class="input-group-addon">&nbsp;</div>
		<?php echo $markup['day'] ?>
		<div class="input-group-addon">,</div>
		<?php echo $markup['year'] ?>
	</div>
</div>
