<?php
/**
* @package vler
* @subpackage form-markup-generator
*/

/**
* require parent file
*/
require_once field_markup_generator_path('integer_text_input');

/**
* @uses _text_input.php
* @uses _text_input_field.php
* @uses _label.php
*
* @package vler
* @subpackage form-markup-generator
*/
class Year_text_input_markup_generator extends Integer_text_input_markup_generator{
	protected $_type = 'year_text_input';
	protected $_feedback_invalid_input = "Please enter a year for the %s field.  You should include all four digits of the year (for example, 1942)."; 
	
	function attributes(){
		$default_attributes = array('maxlength' => 4, 'size' => 4);
		return merge_attributes($default_attributes, parent::attributes());
	}
	
	function has_valid_value_if_any(){
		if(strlen($this->value) > 1 && strlen($this->value) != 4) return false;
		return parent::has_valid_value_if_any();
	}
	
	function feedback_invalid_input(){
		$feedback_invalid_input = parent::feedback_invalid_input();
		if(isset($this->minimum) && !isset($this->maximum))
			return replace_first_with('year', 'year after '.($this->minimum -1), $feedback_invalid_input);
		if(!isset($this->minimum) && isset($this->maximum))
			return replace_first_with('year', 'year before '.($this->maximum+1), $feedback_invalid_input);
		if(isset($this->minimum) && isset($this->maximum))
			return replace_first_with('year', 'year between '.$this->minimum.' and '.$this->maximum, $feedback_invalid_input);
		return $feedback_invalid_input;
	}		
}