<?php
/**
* @package vler
* @subpackage form-markup-generator
*/

/**
* require parent file
*/
require_once field_markup_generator_path('text_area');

/**
* @uses _text_area.php
* @uses _rich_text_area_field.php
* @uses _label.php
*
* @package vler
* @subpackage form-markup-generator
*/
class Rich_text_area_markup_generator extends Text_area_markup_generator{
	protected $_type = 'rich_text_area';
	protected $_toolbar;
	protected $_height;
  protected $_security_sanitization_method = 'sanitizeHTMLString'; 
	protected $_property_validation_rules= array( 'toolbar' => 'nonempty_string_with_no_whitespace',
																								'height' => 'nonempty_string_with_no_whitespace'); //needs to include unit, so not #
	
	function set_value($value){
		if(!is_null($value)) parent::set_value($value);
	}
	
	function attributes(){
		$default_attributes = array(/*'class' => 'ckeditor',*/ 'cols' => '80', 'rows' => '10');
		$parent_attributes = parent::attributes();
		if(isset($parent_attributes['required']))
			unset($parent_attributes['required']); //ckeditor gets confused if the textarea has the required attribute.  Generator will still check.
		return merge_attributes($default_attributes, $parent_attributes);
	}
		
}