<?php
/**
* @package vler
* @subpackage form-markup-generator
*/

/**
* require parent file
*/
require_once field_markup_generator_path('text_input');

/**
* @uses _text_input.php
* @uses _text_input_field.php
* @uses _label.php
*
* @package vler
* @subpackage form-markup-generator
*/
class Numeric_text_input_markup_generator extends Text_input_markup_generator{
	protected $_type = 'numeric_text_input';
	protected $validation_method = 'numeric'; 
	protected $_security_validation_method = 'isValidNumericString';
	protected $_security_sanitization_method = 'sanitizeNumericString'; 

	protected $_feedback_invalid_input = "Please enter a number for the %s field."; //child classes should implement a specific description of the value

	protected $_minimum;
	protected $_maximum;
	
	protected $_property_validation_rules= array(	'minimum' => 'numeric',
																								'maximum' => 'numeric'
																							);

	function has_valid_value_if_any(){
		if(isset($this->value) && isset($this->minimum) && $this->value < $this->minimum) return false;
		if(isset($this->value) && isset($this->maximum) && $this->value > $this->maximum) return false;
		return parent::has_valid_value_if_any();
	}
																							
	function feedback_invalid_input(){
		$feedback_invalid_input = parent::feedback_invalid_input();
		if(isset($this->minimum) && !isset($this->maximum))
			return replace_first_with('number', 'number greater than or equal to '.number_as_text($this->minimum), $feedback_invalid_input);
		if(!isset($this->minimum) && isset($this->maximum))
			return replace_first_with('number', 'number less than or equal to '.number_as_text($this->maximum), $feedback_invalid_input);
		if(isset($this->minimum) && isset($this->maximum))
			return replace_first_with('number', 'number between '.number_as_text($this->minimum).' and '.number_as_text($this->maximum), $feedback_invalid_input);
		return $feedback_invalid_input;
	}																						
	
}