<?php
/**
* @package vler
* @subpackage form-markup-generator
*/

/**
* require parent file
*/
require_once field_markup_generator_path('numeric_text_input');

/**
* @uses _text_input.php
* @uses _text_input_field.php
* @uses _label.php
*
* @package vler
* @subpackage form-markup-generator
*/
class Integer_text_input_markup_generator extends Numeric_text_input_markup_generator{
	protected $_type = 'integer_text_input';
	protected $validation_method = 'integer'; 
	protected $_security_validation_method = 'isValidInteger';
	protected $_security_sanitization_method = 'sanitizeInteger'; 
	protected $_feedback_invalid_input = "Please enter a whole number for the %s field."; //child classes should implement a specific description of the value
	
	function attributes(){
		$default_attributes = array();
		if(isset($this->maximum))
			$default_attributes = array('maxlength' => strlen($this->maximum), 'size' => strlen($this->maximum));
		return merge_attributes($default_attributes, parent::attributes());
	}	
}