<?php
/**
* @package vler
* @subpackage form-markup-generator
*/

/**
* require parent file
*/
require_once field_markup_generator_path('text_input');

/**
* @uses _text_input.php
* @uses _text_input_field.php
* @uses _label.php
*
* @package vler
* @subpackage form-markup-generator
*/
class Date_text_input_markup_generator extends Text_input_markup_generator{
	protected $_type = 'date_text_input';
	protected $_max_length = 10;
	protected $validation_method = 'mysql_date'; 
	protected $_security_validation_method = 'isValidDate';
	protected $_feedback_invalid_input = "Please enter a valid date for the %s field.";
	

	function has_valid_value_if_any(){
		if(isset($this->value) && isset($this->minimum) && $this->value < $this->minimum) return false;
		if(isset($this->value) && isset($this->maximum) && $this->value > $this->maximum) return false;
		return parent::has_valid_value_if_any();
	}																		
	
}