<?php
/**
* @package vler
* @subpackage form-markup-generator
*/

/**
* require parent file
*/
require_once field_markup_generator_path('field_group');
require_once field_markup_generator_path('integer_text_input');
require_once field_markup_generator_path('year_text_input');

/**
* @uses _field_group.php
* @uses _time_field.php
* @uses _label.php
*
* @package vler
* @subpackage form-markup-generator
*/
class Date_markup_generator extends Field_group_markup_generator{
	protected $_type = 'date';
	protected $_field_templates = array('month' => array('type' => 'dropdown', 'options' => array('' => '', '01' => 'January', '02' => 'February', '03' => 'March', '04' => 'April', '05' => 'May', '06' => 'June', '07' => 'July',
														 '08' => 'August', '09' => 'September', '10' => 'October', '11' => 'November', '12' => 'December'), 'label_attributes' => array('class' => 'sr-only')),
										'day' => array('type' => 'integer_text_input', 'minimum' => 1, 'maximum' => 31, 'attributes' => array('size' => 2, /*'placeholder' => 'DD' */),
										  			   'label_attributes' => array('class' => 'sr-only')),
										'year' => array('type' => 'year_text_input', /*'attributes' => array('placeholder' => 'YYYY'), */ 'label_attributes' => array('class' => 'sr-only')));


	function value(){
		//we'll always have a month value, so make sure that we have a day specified
		$values = $this->values();
		if(count(array_unique($values)) > 1 && !empty($values['month']))
			return $values['year'].'-'.$values['month'].'-'.str_pad($values['day'], 2, '0', STR_PAD_LEFT);
	}

	function set_required($value){
		$this->_required = $value;
		if(isset($this->fields) && !empty($this->fields)){
			foreach($this->fields as $field_name => $field){
				$this->field($field_name)->required = $value;
			}
		}
		else{
			foreach($this->_field_templates as $field_name => $info){
				if(!is_array($info)) $info = array('type' => $info);
				$this->_field_templates[$field_name]['required'] = $value;
			}
		}
	}

	function set_value($value){
		if($this->validator->is_a_mysql_date($value) && !mysql_date_is_empty($value)){
			$value = array('year' => $pieces[0], 'month' => $pieces[1], 'day' => $pieces[2]);					 
		}		
		
		if($this->validator->is_an_array($value)) parent::set_values($value);
	}
	
#TODO - this will cause a problem if someone accidentally sets a value and then wants to unset it.  be less lazy and set up new messages.
	function has_valid_value_if_any(){
		if(!$this->field('month')->property_is_empty('value') || !$this->field('day')->property_is_empty('value') || !$this->field('year')->property_is_empty('value')){ 
			$this->field('month')->required = true;
			$this->field('day')->required = true;
			$this->field('year')->required = true;
		}
		return parent::has_valid_value_if_any();
	}

}