<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
* @package direct-project-innovation-initiative
* @subpackage libraries
*/

/**
* Extends the CI session library to allow for VLER customizations.
* Additionally, some methods have been extended/overridden to include updates from CI v2.2, and several changes in an attempt to fix the race condition 
* error described here: http://www.hiretheworld.com/blog/tech-blog/codeigniter-session-race-conditions.
* @package direct-project-innovation-initiative
* @subpackage libraries
**/
class DPII_Session extends CI_Session {

	/**
	* Changes the system's idea of where we are in the inbox (drafts, sent messages, custom folders, etc.).
	* Should you need to accomplish this and reload the page, you can redirect to inbox/change_mailbox, but if 
	* this method will allow you to change the location in the session without doing a full redirect.
	* VLER method - does not override any methods in the parent class.
	* @param string|int Either the name of a location (inbox, draft, etc) or the numeric id of a custom folder
	*/
	function set_mailbox_location($location){
		//first - a couple actions we'll take care of no matter which location we're going to
		$_SESSION['page_start'] = 1; //bring user back to first page
		if(isset($_SESSION['filter_folder'])){unset($_SESSION['filter_folder']);}//remove archive filter
	

		//handle custom folders first so that we can default to inbox if we can't find the folder
		if(Folder::formatted_like_an_id($location)){
			$folder = Folder::find_one($location);
			
			if(Folder::is_an_entity($folder)){
				$_SESSION['folder'] = $location;
				$_SESSION['folder_name'] = $folder->name;
				return true; //we're done
			}
			
			//if we couldn't find the folder, trigger a warning and default to inbox
			get_instance()->error->warning(get_instance()->error->describe($location).' is not a known folder, defaulting to inbox');
			$location = 'inbox';
		}
				
		//location names mapped to the display name
		$known_locations = array('inbox' => 'Inbox',
								 'sent' => 'Sent',
								 'draft' => 'Drafts',
								 'archived' => 'Archive');
		
		if(!array_key_exists($location, $known_locations)){
			get_instance()->error->warning(get_instance()->error->describe($location).' is not a known folder, defaulting to inbox');
			$location = 'inbox';
		} 
		
		$_SESSION['folder'] = $location;
		$_SESSION['folder_name'] = $known_locations[$location];
		return true;
	}

	/**
	* Returns the current mailbox location, defaulting to inbox if not set.
	* @return string
	*/
	function mailbox_location(){
		if(empty($_SESSION['folder'])) $this->set_mailbox_location('inbox');
		return $_SESSION['folder'];
	}
	
	/**
	* Returns the display name of the current mailbox location, defaulting to Inbox if not set.
	* @return string
	*/
	function mailbox_location_display_name(){
		if(empty($_SESSION['folder_name'])) $this->set_mailbox_location($this->mailbox_location()); //will default to inbox if necessary, otherwise make sure display name for current folder is set
		return $_SESSION['folder_name'];
	}
	

	/**
	* Sets an error message in the flashdata, to be displayed the next time the page loads.
	* VLER method - does not override any methods in the parent class.
	* @param string
	*/	
	public function set_error_message($message){
		$this->set_flashdata('message',json_encode($message));
		$this->set_flashdata('message_class','error');
	}
	
	
	/**
	* Sets a service permission error in the flashdata, to be displayed the next time the page loads.
	* VLER method - does not override any methods in the parent class.
	* @param string 
	* @param string
	*/
	public function set_service_permission_error_message($service, $message){
		$this->session->set_flashdata('service_failure_due_to_permission',true);
		$this->session->set_flashdata('failed_service_name', json_encode($service));
		$this->session->set_flashdata('service_failure_due_to_permission_message',json_encode($message));       
	}
	
	/**
	* Sets a success feedback message in the flashdata, to be displayed the next time the page loads.
	* VLER method - does not override any methods in the parent class.
	* @param string
	*/
	public function set_success_message($message){
		$this->set_flashdata('message', json_encode($message));
		$this->set_flashdata('message_class','success');	
	}
	
} 