<?php 
/**
* @package direct-project-innovation-initiative
* @subpackage hooks
*/

/**
* Runs any system-wide code based on the constants file.
* For example, the timezone needs to be set to the default timezone for this instance of Direct.
*/
function set_system_defaults(){
	date_default_timezone_set(ENVIRONMENT_TIMEZONE); //this instance of Direct will be configured with a default timezone, we want it set as early as possible
}

function set_up_session(){
	//at this point, the controller has not been instantiated yet, but the core/Codeigniter bootstrap script has determined which controller and method will be called
	global $class; //the name of the controller class
	global $method; //the method of the controller class which CI will call
	
	$class = strtolower($class);
	$method = strtolower($method); 

	
#TODO - WOULD THIS WORK BETTER IF WE SET IT TO /?  IT LOOKS LIKE THE SECOND PARAM IS MEANT TO BE THE PATH, WHICH IS NOT ALWAYS THE SAME AS THE CONTROLLER CLASS NAME	
	session_set_cookie_params(0,'/'/*.$class*/, DIRECT_DOMAIN, TRUE, TRUE);
	session_cache_limiter('none'); //this was included in the restricted controller, but doesn't appear to be a valid value for cache_limiter - should be nocache if we're doing this
#	session_start();

}

/**
* Check to see if there's a theme set for this user and set it as a controller class var if there is.
*/
function set_user_theme(){
	$hooks_disabled = array('install');
	$CI = get_instance();
	$controller = strtolower(get_class($CI));
	if(!in_array($controller, $hooks_disabled)) { 
		$CI->user_theme = $CI->webmailmodel->get_user_theme_info()->row_array();
	}
}
 

/* End of file hook_functions.php */
/* Location: ./application/hooks/hook_functions.php */
