<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-project-innovation-initiative
* @subpackage helpers
*/

#load_libraries('Error', 'Validator'); //autoloaded in this application, don't add the overhead of an attempted re-load


/**
* Checks against various zero-date formats to see if the given date has a value.
* @param string Date in a MYSQL format
* @return boolean
*/
if(!function_exists('mysql_date_is_empty')){
	function mysql_date_is_empty($mysql_date){
		if(empty($mysql_date)) return true; //empty string, boolean false, null, are all OK
		if(!validates_as('mysql_date', $mysql_date) && !validates_as('mysql_datetime', $mysql_date))
			 return should_be('a mysql date (YYYY-MM-DD) or a mysql datetime (YYYY-MM-DD HH:MM:SS)', $mysql_date);
		$possibilities = array('0', '0000-00-00', '0000-00-00 00:00:00');
		return (empty($mysql_date) || in_array($mysql_date, $possibilities));
	}
}