<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
* @package direct-project-innovation-initiative
* @subpackage core
*/


/**
* DPII CodeIgniter Security Class Extension
*
* @package direct-project-innovation-initiative
* @subpackage core
* @author		         
*/
class DPII_Security extends VLER_Security {

	protected function is_ajax_accessible_public_page(){
		global $RTR; //this method gets run early enough that we don't have access to the controller or the standard router - grab the early global version of the router class instead
		return ($RTR->class == 'auth' && $RTR->method == 'logout');
	}
	
	
	#TODO - IF WE HAVE A USER AVAILABLE, TRY TO LOG THEM OUT
	protected function log_out(){
		global $RTR;
		
		if($RTR->class != 'auth' && $RTR->method != 'logout'){	
			header("Location: https://".DIRECT_DOMAIN.'/auth/logout', TRUE, 302); //redirect to the logout page
		}
		
		if(session_status() == PHP_SESSION_ACTIVE) session_destroy(); //just in case the redirect didn't work, make sure the session gets destroyed
	}
}