<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
* AUTO-LOADER
* 
* This file specifies which systems should be loaded by default.
*
* In order to keep the framework as light-weight as possible only the
* absolute minimal resources are loaded by default. For example,
* the database is not connected to automatically since no assumption
* is made regarding whether you intend to use it.  This file lets
* you globally define which systems you would like loaded with every
* request.
*
* 
* Instructions
* 
*
* These are the things you can load automatically:
*
* 1. Packages
* 2. Libraries
* 3. Helper files
* 4. Custom config files
* 5. Language files
* 6. Models
*
* @package direct-project-innovation-initiative
* @subpackage config
*//** */

global $installer;

/*
* 
*  Auto-load Packges
* 
* Prototype:
*
*  $autoload['packages'] = array(APPPATH.'third_party', '/usr/local/shared');
*
*/

$autoload['packages'] = array();


/*
* 
*  Auto-load Libraries
* 
* These are the classes located in the system/libraries folder
* or in your application/libraries folder.
*
* Prototype:
*
*	$autoload['libraries'] = array('database', 'session', 'xmlrpc');
*/

if( !isset($installer) || !$installer) { // don't autoload while installer is active
	$autoload['libraries'] = array('session','error','api', 'encrypt', 'form_validation', 'json', 'locale', 'mailformat', 'template','user_agent');
}

/*
* 
*  Auto-load Helper Files
* 
* Prototype:
*
*	$autoload['helper'] = array('url', 'file');
*/

//MG, loader really does need to go first, stop alphabetizing!  -- MG
if( !isset($installer) || !$installer) { // don't autoload while installer is active
	$autoload['helper'] = array('loader', 'array', 'date', 'debug', 'environment', 'file', 'form', 'html', 'inflector', 'htmlpurifier', 'number',  'security', 'sort', 'string', 'url');
}
else {
	$autoload['helper'] = array('loader');
}


/*
* 
*  Auto-load Config files
* 
* Prototype:
*
*	$autoload['config'] = array('config1', 'config2');
*
* NOTE: This item is intended for use ONLY if you have created custom
* config files.  Otherwise, leave it blank.
*
*/

$autoload['config'] = array();


/*
* 
*  Auto-load Language files
* 
* Prototype:
*
*	$autoload['language'] = array('lang1', 'lang2');
*
* NOTE: Do not include the "_lang" part of your file.  For example
* "codeigniter_lang.php" would be referenced as array('codeigniter');
*
*/

$autoload['language'] = array();


/*
* 
*  Auto-load Models
* 
* Prototype:
*
*	$autoload['model'] = array('model1', 'model2');
*
*/
if( !isset($installer) || !$installer) { // don't autoload while installer is active
	$autoload['model'] = array('user_model','api_model', 'distribution_list_model', 'private_distribution_list_model', 'public_distribution_list_model', 'role_model', 'webmailmodel');
}

//the classes for these models will be made available, but not actually loaded using the CI singleton pattern
$autoload['entity_models'] = array('entity', 'api_entity', 'db_entity', 'mailbox', 'message', 'folder', 'user'); 

/* End of file autoload.php */
/* Location: ./application/config/autoload.php */