var selected_group_names = '';
var selected_user_names = '';

var selectedCategoryValue = '';
var selectedCategoryText= '';

function getGroups(){
	$.ajax({
		url : '/reports/get_groups/?'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val(), 
		success: function(data,statusText,xhr) {
			var data_arr = $.parseJSON(data);
			$("#group_select").empty();
			$.each(data_arr, function(key, value) {
				 $('#group_select').append($('<option>', { 
				        value: key,
				        text : value 
				}));
			});
			$('#group_select').on('change', function() {
				
				$(this).find('option:selected').each(
						function(){
							if($('#row_' + this.value).length <= 0 && this.value != 'multiselect-all') {
								insertRowInSelectedEntryTable(this.value, $(this).text());
							}
						}
		            );
				$(this).find('option:not(:selected)').each(
						 function(){
				            	deselectEntry(this.value, selectedCategoryValue);
				            	
						 });
				
				if($(this).val() != null) {
					$('#selected_group_names').attr('value',$(this).val().toString().replace('multiselect-all,', ''));
				}
				else {
					$('#selected_group_names').attr('value','');
				}
				
			});
			$('#group_select').multiselect({
				includeSelectAllOption: true,
	        	//enableFiltering: true,
	        	//filterBehavior: 'text',
	        	//filterPlaceholder: 'Search',
	        	maxHeight: 150
			});
		}
	});
}

function getUsers(){
	$.ajax({
		url : '/reports/get_users/?'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val(), 
		success: function(data,statusText,xhr) {
			var data_arr = $.parseJSON(data);
			$("#user_select").empty();
			$.each(data_arr, function(key, value) {
				 $('#user_select').append($('<option>', { 
				        value: key,
				        text : value 
				}));
			});
			$('#user_select').on('change', function() {
				$(this).find('option:selected').each(
		            function(){
		            	
		            	if($('#row_' + this.value).length <= 0 && this.value != 'multiselect-all') {
		            		insertRowInSelectedEntryTable(this.value, $(this).text());
		            	}
		            });
				$(this).find('option:not(:selected)').each(
					 function(){
						 if($('#row_' + this.value).length > 0 && this.value != 'multiselect-all') {
			            	deselectEntry(this.value, selectedCategoryValue);
						 }
					 });
				if($(this).val() != null) {
					$('#selected_user_names').attr('value',$(this).val().toString().replace('multiselect-all,', ''));
				}
				else {
					$('#selected_user_names').attr('value','');
				}
			});
			$('#user_select').multiselect({
				includeSelectAllOption: true,
	        	//enableFiltering: true,
	        	//filterBehavior: 'text',
	        	//filterPlaceholder: 'Search',
	        	maxHeight: 150
			});
			 
		}
	});
}
function changeElementSize(elementId) {
	$('#' + elementId).animate({height:'500px'}, 500);
}

function changeCategory() {
	selectedCategoryValue = $('#category_select').val();
	selectedCategoryText = $('#category_select option:selected').text();
	
	if(selectedCategoryValue == 'group') {
		$('#group_select_div').show();
		$('#user_select_div').hide();
	}
	else {
		$('#user_select_div').show();
		$('#group_select_div').hide();
	}
}

function deselectEntry(entry, category) {
	$('#' + category + '_select').multiselect('deselect', entry);
	$('#' + category + '_select').multiselect('deselect', 'multiselect-all');
	var tr = $('#row_' + entry);
	tr.css("background-color","#F5F5F5");
    tr.fadeOut(400, function(){
        tr.remove();
    });
	
    //assign adhoc form vlaues
    if($('#' + category + '_select').val() != null) {
		$('#selected_' + category + '_names').attr('value',$('#' + category + '_select').val().toString());
	}
	else {
		$('#selected_' + category + '_names').attr('value','');
	}
}

function insertRowInSelectedEntryTable(value, text) {
	$('#selected_entry_table').append('<tr id="row_'+ value + '">' +
        	'<td>' + selectedCategoryText + '</td>' +
        	'<td>' + text + '</td>' + 
        	'<td align="center"><button class="blue-button" type="button" onclick="deselectEntry(\'' + value + '\',\'' + selectedCategoryValue + '\');">Remove</button></td></tr>');
}
var loaded = false;
function toggleShareMenu(reportAccess) {
	if(reportAccess == 'share') {
		if(!loaded) {
			getUsers();
			getGroups();
		}
		loaded = true;
		$('#share_div').fadeIn('slow');
		$('#category_select').multiselect();
		$('#share_select_users').focus();
	}
	else {
		$('#share_div').fadeOut('slow');
	}
	
}