<?php
/**
* @package direct-as-a-service
* @subpackage views
 * @filesource
*/ /** */

	$this->load->view('api/header'); 
	$this->load->view('api/nav'); 
?>
				<h1><a href="/onboarding/documentation/" class="underline">Documentation</a> &rarr; <a class="underline" href="/onboarding/validate">/direct/validate</a> - GET</h1>
				<p>The validate web service allows authorized applications to check if a Direct address is a trusted recipient and can be accessed by sending a GET request to /direct/validate. Below are some code examples for sending a message using the validate web service.</p>
				<h3>Java</h3>
				<p>
					<?php 
			require_once APPPATH.'third_party/luminous/luminous.php'; 
			echo luminous::highlight('java', 'import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
 
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
 
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
 
import java.text.SimpleDateFormat;
 
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
 
 
public class VLERDirectTest {
 
    private String makeRequest(String urlloc) {
        String pubkey ="8f5f968d19047f8d8614338d7e10b550022f858d49215195e6320640c31b42eb";
        String prvkey ="acbb607d9ca14d16ba5e916b1acc92b6995848690b0ea6c0ad375f59298b8a56";
        String rtc = "";
        HttpURLConnection conn = null;
       
        try {
            System.out.println("urlloc>>"+urlloc+"<<");
            URL url = new URL(urlloc);
            conn = (HttpURLConnection)url.openConnection();
 
            java.util.Date dt = new java.util.Date();
            SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss z");
            String dstr = sdf.format(dt);
            String address = "swilliams@example.com";
	    String encaddr = new sun.misc.BASE64Encoder().encode(address.getBytes());
            String reqstr = "GET\n" + dstr + "\n/direct/validate/format/json?address=" + encaddr;
            System.out.println("reqest str>>" + reqstr + "<<");
            Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
            SecretKeySpec secret_key = new SecretKeySpec(prvkey.getBytes(),"HmacSHA256");
            sha256_HMAC.init(secret_key);
 
            byte[] sha = sha256_HMAC.doFinal(reqstr.getBytes());
            String encsha = new sun.misc.BASE64Encoder().encode(sha);
            System.out.println("encoded request str>>" + encsha + "<<");
            String auth = "DAAS " + pubkey + ":" + encsha;
            System.out.println("auth>>" + auth + "<<");
 
            conn.setRequestProperty("Authorization", auth);
            conn.setRequestProperty("Date", dstr);
            conn.setRequestProperty("X-DaaS-Date", dstr);
            conn.setRequestProperty("Accept", "application/json");
            conn.setRequestMethod("GET");
 
            if (conn.getResponseCode() != 200) {
                throw new RuntimeException("Failed : HTTP error code : " + conn.getResponseCode());
            }
 
            BufferedReader br = new BufferedReader(new InputStreamReader((conn.getInputStream())));
 
            String output;
            String resp = "";
            while ((output = br.readLine()) != null) {
                resp += output;
                System.err.println(output);
            }
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        } catch (InvalidKeyException e) {
            e.printStackTrace();
        } catch (MalformedURLException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rtc;
    }
 
    public static void main(String[] args) {
        VLERDirectTest test = new VLERDirectTest();
        String address = "swilliams@example.com";
	String encaddr = new sun.misc.BASE64Encoder().encode(address.getBytes());
		     System.out.println(test.makeRequest("https://api.demo.careinbox.com/direct/validate/format/json?address=" + encaddr));
    }
 
}
', false);
		?>
				</p>
				<h3>HTML and JavaScript</h3>
				<p>
					<?php 
						echo luminous::highlight('php', html_entity_decode('&lt;html&gt;
	&lt;head&gt;
		&lt;title&gt;&lt;?PHP echo $title; ?&gt;&lt;/title&gt;
		&lt;LINK href=&quot;/css/example.css&quot; rel=&quot;stylesheet&quot; type=&quot;text/css&quot;&gt;
		&lt;link rel=&quot;stylesheet&quot; type=&quot;text/css&quot; href=&quot;/css/custom-theme/jquery-ui-1.8.18.custom.css&quot; /&gt;
		&lt;script type=&quot;text/javascript&quot; src=&quot;/js/jquery.min.js&quot;&gt;&lt;/script&gt;
		&lt;script type=&quot;text/javascript&quot; src=&quot;/js/jquery-ui-1.8.17.custom.min.js&quot;&gt;&lt;/script&gt;
		&lt;script type=&quot;text/javascript&quot; src=&quot;/js/jquery.form.js&quot;&gt;&lt;/script&gt;
		&lt;script type=&quot;text/javascript&quot; src=&quot;/js/rollups/hmac-sha256.js&quot;&gt;&lt;/script&gt;
		&lt;script type=&quot;text/javascript&quot; src=&quot;/js/components/enc-base64-min.js&quot;&gt;&lt;/script&gt;
		&lt;script type=&quot;text/javascript&quot; src=&quot;/js/date.format.js&quot;&gt;&lt;/script&gt;
		&lt;script type=&quot;text/javascript&quot;&gt;	

			var keyStr = &quot;ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=&quot;;

			//a function for base64 encoding an input string
			function encode64(input) {
			   if (!String(input).length) return false;
			   var output = &quot;&quot;;
			   var chr1, chr2, chr3;
			   var enc1, enc2, enc3, enc4;
			   var i = 0;
	
			   do {
			      chr1 = input.charCodeAt(i++);
			      chr2 = input.charCodeAt(i++);
			      chr3 = input.charCodeAt(i++);
	
			      enc1 = chr1 &gt;&gt; 2;
			      enc2 = ((chr1 &amp; 3) &lt;&lt; 4) | (chr2 &gt;&gt; 4);
			      enc3 = ((chr2 &amp; 15) &lt;&lt; 2) | (chr3 &gt;&gt; 6);
			      enc4 = chr3 &amp; 63;
	
			      if (isNaN(chr2)) {
			         enc3 = enc4 = 64;
			      } else if (isNaN(chr3)) {
			         enc4 = 64;
			      }
	
			      output = output + keyStr.charAt(enc1) + keyStr.charAt(enc2) + 
			         keyStr.charAt(enc3) + keyStr.charAt(enc4);
			   } while (i &lt; input.length);
			   
			   return output;
			}
		
			$(function() {
				$(&quot;.json&quot;).click(function() {
					$(&quot;#sender&quot;).css(&quot;background-color&quot;,&quot;#fff&quot;);
					$(&quot;#to&quot;).css(&quot;background-color&quot;,&quot;#fff&quot;);
					var oldVal = $(\'#address\').val();
					$(\'#address\').val(encode64(&quot;&quot;+$(\'#address\').val())); 
					$(&quot;#messageForm&quot;).ajaxSubmit({  
						type: &quot;GET&quot;,  
					  	url: &quot;/direct/validate/format/json&quot;,
					  	beforeSend: function(request){
							start = new Date().getTime();
							//use this block if you want to send UTC stamp
							/*var d = Date.now();
							var currentDate = Math.round(d / 1000);*/
							//use this block if you want to send normal timestamp with timezone
							var d = new Date();
							var currentDate = d.format(&quot;mm/dd/yyyy HH:MM:ss Z&quot;);
							var hash_string = &quot;GET\n&quot;+currentDate+&quot;\n/direct/validate/format/json?address=&quot;+encodeURIComponent($(\'#address\').val()).replace(/%20/g,&quot;+&quot;);
							var hashString = CryptoJS.HmacSHA256(hash_string,&quot;947d0e7ada02a75f2643fa409f19e976b235db5e86b93b292697d980ba177206&quot;);
							var base64 = encode64(&quot;&quot;+hashString);
							var authorization = &quot;DAAS 323716a85b68f3f1ef7595900c00f5d6e395fad9e88537589a43a688904c511e:&quot;+base64;
							request.setRequestHeader(&quot;Authorization&quot;, authorization);
							request.setRequestHeader(&quot;X-Daas-Date&quot;, currentDate);
						  }, 
					  	success: function(data, status, jqXHR) {
						  	if (data[\'message\'])
					  			$(\'#success\').html(data[\'message\']).slideDown(500).delay(5000).slideUp(500);
						  	else 
								$(\'#success\').html(&quot;Valid address string.&quot;).slideDown(500).delay(5000).slideUp(500);

							$(\'#address\').val(oldVal);
					  	},
					  	error: function (jqXHR, textStatus, errorThrown) {
					  		if ($.parseJSON(jqXHR.responseText)[\'message\'])
					  			$(\'#error\').html($.parseJSON(jqXHR.responseText)[\'message\']).slideDown(500).delay(5000).slideUp(500);
						  	else 
								$(\'#error\').html(&quot;Not a valid address string.&quot;).slideDown(500).delay(5000).slideUp(500);

					  		$(\'#address\').val(oldVal);
					  	}
					});
				});
			});
		&lt;/script&gt;
	&lt;/head&gt;
	&lt;body&gt;
		&lt;div class=&quot;container&quot;&gt;
			&lt;h1&gt;Direct Mail&lt;/h1&gt;
			&lt;div id=&quot;success&quot;&gt;Valid address string.&lt;/div&gt;
			&lt;div id=&quot;error&quot;&gt;&lt;div class=&quot;imageText&quot;&gt;Not a valid address string.&lt;/div&gt;&lt;/div&gt;
			&lt;div class=&quot;wrapper&quot;&gt;
				&lt;form id=&quot;messageForm&quot; action=&quot;/direct/validate&quot; method=&quot;GET&quot;&gt;
					&lt;label&gt;Address:&lt;/label&gt; &lt;input class=&quot;full&quot; type=&quot;text&quot; name=&quot;address&quot; id=&quot;address&quot;&gt;
				&lt;/form&gt;
				&lt;br/&gt;
			&lt;/div&gt;
			&lt;div class=&quot;button-container&quot;&gt;&lt;input type=&quot;button&quot; class=&quot;button json&quot; value=&quot;Send&quot;&gt;&lt;/div&gt;
		&lt;/div&gt;
	&lt;/body&gt;
&lt;/html&gt;'), false);
					?>
				</p>
			</div>
			<?PHP $this->load->view('api/footer'); ?>
		</div>
	</body>
</html>